/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.theories.EvaluablePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsValidParameterRangeRefinementPredicate
implements EvaluablePredicate {
    private final Logger logger = LoggerFactory.getLogger(IsValidParameterRangeRefinementPredicate.class);
    private final Collection<Component> components;
    private final Map<Component, Map<Parameter, ParameterRefinementConfiguration>> refinementConfiguration;
    private final Map<ComponentInstance, Double> knownCompositionsAndTheirScore = new HashMap<ComponentInstance, Double>();

    public IsValidParameterRangeRefinementPredicate(Collection<Component> components, Map<Component, Map<Parameter, ParameterRefinementConfiguration>> refinementConfiguration) {
        this.components = components;
        this.refinementConfiguration = refinementConfiguration;
    }

    public Collection<List<ConstantParam>> getParamsForPositiveEvaluation(Monom state, ConstantParam ... partialGrounding) {
        this.logger.info("Computing params that evaluate isValidParameterRangeRefinement positively in state with hash code {}.", (Object)state.hashCode());
        if (partialGrounding.length != 6) {
            throw new IllegalArgumentException("The interpreted predicate " + this.getClass().getName() + " requires 6 arguments when oracled but " + partialGrounding.length + " have been provided!");
        }
        String componentName = partialGrounding[0].getName();
        String componentIdentifier = partialGrounding[1].getName();
        String parameterName = partialGrounding[2].getName();
        Optional<Component> searchedComponent = this.components.stream().filter(c -> c.getName().equals(componentName)).findAny();
        if (!searchedComponent.isPresent()) {
            throw new IllegalArgumentException("Could not find matching component.");
        }
        Component component = searchedComponent.get();
        Optional<Parameter> optParam = component.getParameters().stream().filter(p -> p.getName().equals(parameterName)).findAny();
        if (!optParam.isPresent()) {
            throw new IllegalArgumentException("Could not find required parameter");
        }
        Parameter param = optParam.get();
        List<ConstantParam> partialGroundingAsList = Arrays.asList(partialGrounding);
        String containerName = partialGrounding[3].getName();
        String currentParamValue = partialGrounding[4].getName();
        this.logger.info("Determining positive evaluations for isValidParameterRangeRefinementPredicate({},{},{},{},{},{})", new Object[]{componentName, componentIdentifier, parameterName, containerName, currentParamValue, partialGrounding[5]});
        boolean hasBeenSetBefore = state.contains((Object)new Literal("overwritten('" + containerName + "')"));
        ComponentInstance instance = Util.getComponentInstanceFromState(this.components, state, componentIdentifier, false);
        this.logger.debug("Derived component instance to be refined: {}. Parameter to refine: {}. Current value of parameter: {}", new Object[]{instance, param, currentParamValue});
        try {
            Map<Parameter, IParameterDomain> paramDomains = Util.getUpdatedDomainsOfComponentParameters(instance);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parameter domains are: {}", (Object)paramDomains.keySet().stream().map(k -> "\n\t" + k + ": " + paramDomains.get(k)).collect(Collectors.joining()));
            }
            if (param.isNumeric()) {
                boolean isAtomicInterval;
                NumericParameterDomain currentlyActiveDomain = (NumericParameterDomain)paramDomains.get(param);
                Interval currentInterval = new Interval(currentlyActiveDomain.getMin(), currentlyActiveDomain.getMax());
                assert (!hasBeenSetBefore || currentInterval.getInf() == Double.valueOf((String)SetUtil.unserializeList((String)currentParamValue).get(0)).doubleValue() && currentInterval.getSup() == Double.valueOf((String)SetUtil.unserializeList((String)currentParamValue).get(1)).doubleValue()) : "The derived currently active domain of an explicitly set parameter deviates from the domain specified in the state!";
                ParameterRefinementConfiguration refinementConfig = this.refinementConfiguration.get(component).get(param);
                if (refinementConfig == null) {
                    throw new IllegalArgumentException("No refinement configuration for parameter \"" + parameterName + "\" of component \"" + componentName + "\" has been supplied!");
                }
                double relativeLength = currentInterval.getSup() / currentInterval.getInf() - 1.0;
                double absoluteLengt = currentInterval.getSup() - currentInterval.getInf();
                boolean bl = isAtomicInterval = refinementConfig.isInitRefinementOnLogScale() && relativeLength < refinementConfig.getIntervalLength() || !refinementConfig.isInitRefinementOnLogScale() && absoluteLengt < refinementConfig.getIntervalLength();
                if (isAtomicInterval) {
                    this.logger.info("Returning an empty list as this is a numeric parameter that has been narrowed sufficiently. Required interval length is {}, and actual interval length is {}", (Object)refinementConfig.getIntervalLength(), (Object)(currentInterval.getSup() - currentInterval.getInf()));
                    if (!hasBeenSetBefore) {
                        ArrayList<Interval> unmodifiedRefinement = new ArrayList<Interval>();
                        unmodifiedRefinement.add(currentInterval);
                        return this.getGroundingsForIntervals(unmodifiedRefinement, partialGroundingAsList);
                    }
                    return new ArrayList<List<ConstantParam>>();
                }
                this.logger.debug("Current interval [{},{}] is not considered atomic. Relative length is {}, and absolute length is {}", new Object[]{currentInterval.getInf(), currentInterval.getSup(), relativeLength, absoluteLengt});
                if (currentlyActiveDomain.isInteger() && Math.floor(currentInterval.getSup()) - Math.ceil(currentInterval.getInf()) + 1.0 <= (double)refinementConfig.getRefinementsPerStep()) {
                    ArrayList<Interval> proposedRefinements = new ArrayList<Interval>();
                    for (int i2 = (int)Math.ceil(currentInterval.getInf()); i2 <= (int)Math.floor(currentInterval.getSup()); ++i2) {
                        proposedRefinements.add(new Interval((double)i2, (double)i2));
                    }
                    this.logger.info("Ultimate level of integer refinement reached. Returning refinements: {}.", proposedRefinements.stream().map(i -> "[" + i.getInf() + ", " + i.getSup() + "]").collect(Collectors.toList()));
                    return this.getGroundingsForIntervals(proposedRefinements, partialGroundingAsList);
                }
                if (hasBeenSetBefore || !refinementConfig.isInitRefinementOnLogScale()) {
                    List<Interval> proposedRefinements = this.refineOnLinearScale(currentInterval, refinementConfig.getRefinementsPerStep(), refinementConfig.getIntervalLength(), refinementConfig.isInitRefinementOnLogScale(), refinementConfig.isInitWithExtremalPoints() && !hasBeenSetBefore);
                    for (Interval proposedRefinement : proposedRefinements) {
                        assert (proposedRefinement.getInf() >= currentInterval.getInf() && proposedRefinement.getSup() <= currentInterval.getSup()) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of " + currentParamValue + "].";
                        assert (!proposedRefinement.equals(currentInterval)) : "No real refinement! Intervals are identical.";
                    }
                    this.logger.info("Returning linear refinements: {}.", proposedRefinements.stream().map(i -> "[" + i.getInf() + ", " + i.getSup() + "]").collect(Collectors.toList()));
                    return this.getGroundingsForIntervals(proposedRefinements, partialGroundingAsList);
                }
                Optional<Literal> focusPredicate = state.stream().filter(l -> l.getPropertyName().equals("parameterFocus") && ((LiteralParam)l.getParameters().get(0)).getName().equals(componentIdentifier) && ((LiteralParam)l.getParameters().get(1)).getName().equals(parameterName)).findAny();
                if (!focusPredicate.isPresent()) {
                    throw new IllegalArgumentException("The given state does not specify a parameter focus for the log-scale parameter " + parameterName + " on object \"" + componentIdentifier + "\"");
                }
                double focus = Double.parseDouble(((LiteralParam)focusPredicate.get().getParameters().get(2)).getName());
                if (refinementConfig.getLogBasis() <= 1.0) {
                    throw new UnsupportedOperationException("The basis for log-scaled parameter " + param.getName() + " of component " + instance.getComponent().getName() + " must be strictly greater than 1 (but is " + refinementConfig.getLogBasis() + ").");
                }
                List<Interval> proposedRefinements = this.refineOnLogScale(currentInterval, refinementConfig.getRefinementsPerStep(), refinementConfig.getLogBasis(), focus, refinementConfig.isInitWithExtremalPoints() && !hasBeenSetBefore);
                for (Interval proposedRefinement : proposedRefinements) {
                    double epsilon = 1.0E-7;
                    assert (proposedRefinement.getInf() + epsilon >= currentInterval.getInf() && proposedRefinement.getSup() <= currentInterval.getSup() + epsilon) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of " + currentParamValue + "].";
                    assert (!proposedRefinement.equals(currentInterval)) : "No real refinement! Intervals are identical.";
                }
                this.logger.info("Returning log-scale refinements with focus point {}: {}.", (Object)focus, proposedRefinements.stream().map(i -> "[" + i.getInf() + ", " + i.getSup() + "]").collect(Collectors.toList()));
                return this.getGroundingsForIntervals(proposedRefinements, partialGroundingAsList);
            }
            if (param.isCategorical()) {
                ArrayList<String> possibleValues = new ArrayList<String>();
                if (hasBeenSetBefore) {
                    this.logger.info("Returning empty list since param has been set before.");
                    return new ArrayList<List<ConstantParam>>();
                }
                for (String valAsObject : ((CategoricalParameterDomain)paramDomains.get(param)).getValues()) {
                    possibleValues.add(valAsObject.toString());
                }
                this.logger.info("Returning possible values {}.", possibleValues);
                return this.getGroundingsForOracledValues(possibleValues, partialGroundingAsList);
            }
            throw new UnsupportedOperationException("Currently no support for parameters of class \"" + param.getClass().getName() + "\"");
        }
        catch (Exception e) {
            this.logger.error("Unexpected exception observed", (Throwable)e);
            System.exit(1);
            return new ArrayList<List<ConstantParam>>();
        }
    }

    private Collection<List<ConstantParam>> getGroundingsForIntervals(List<Interval> refinements, List<ConstantParam> partialGrounding) {
        ArrayList<String> paramValues = new ArrayList<String>();
        for (Interval oracledInterval : refinements) {
            paramValues.add("[" + oracledInterval.getInf() + ", " + oracledInterval.getSup() + "]");
        }
        return this.getGroundingsForOracledValues(paramValues, partialGrounding);
    }

    private Collection<List<ConstantParam>> getGroundingsForOracledValues(List<String> refinements, List<ConstantParam> partialGrounding) {
        ArrayList<List<ConstantParam>> groundings = new ArrayList<List<ConstantParam>>();
        for (String oracledValue : refinements) {
            ArrayList<ConstantParam> grounding = new ArrayList<ConstantParam>(partialGrounding);
            grounding.set(5, new ConstantParam(oracledValue));
            groundings.add(grounding);
        }
        return groundings;
    }

    public void informAboutNewSolution(ComponentInstance solution, double score) {
        this.knownCompositionsAndTheirScore.put(solution, score);
    }

    public boolean isOracable() {
        return true;
    }

    public Collection<List<ConstantParam>> getParamsForNegativeEvaluation(Monom state, ConstantParam ... partialGrounding) {
        throw new UnsupportedOperationException();
    }

    public boolean test(Monom state, ConstantParam ... params) {
        throw new NotImplementedException("Testing the validity-predicate is currently not supported. This is indirectly possible using the oracle.");
    }

    public List<Interval> refineOnLinearScale(Interval interval, int maxNumberOfSubIntervals, double minimumLengthOfIntervals, boolean wasInitiallyLogarithmic, boolean createPointIntervalsForExtremalValues) {
        double min = interval.getInf();
        double max = interval.getSup();
        double length = max - min;
        double logLength = max / min - 1.0;
        double relevantLength = wasInitiallyLogarithmic ? logLength : length;
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        this.logger.debug("Refining interval [{}, {}] in a linear fashion. Was initially refined on log-scale: {}", new Object[]{min, max, wasInitiallyLogarithmic});
        if (relevantLength <= minimumLengthOfIntervals) {
            intervals.add(interval);
            if (createPointIntervalsForExtremalValues) {
                intervals.add(0, new Interval(min, min));
                intervals.add(new Interval(max, max));
            }
            return intervals;
        }
        int numberOfIntervals = Math.min((int)Math.ceil(relevantLength / minimumLengthOfIntervals), maxNumberOfSubIntervals);
        if (createPointIntervalsForExtremalValues) {
            numberOfIntervals -= 2;
        }
        numberOfIntervals = Math.max(numberOfIntervals, 1);
        this.logger.trace("Splitting interval of length {} and log-length {} into {} sub-intervals.", new Object[]{length, logLength, numberOfIntervals});
        double stepSize = length / (double)numberOfIntervals;
        for (int i2 = 0; i2 < numberOfIntervals; ++i2) {
            intervals.add(new Interval(min + (double)i2 * stepSize, min + (double)(i2 + 1) * stepSize));
        }
        if (createPointIntervalsForExtremalValues) {
            intervals.add(0, new Interval(min, min));
            intervals.add(new Interval(max, max));
        }
        this.logger.trace("Derived sub-intervals {}", intervals.stream().map(i -> "[" + i.getInf() + ", " + i.getSup() + "]").collect(Collectors.toList()));
        return intervals;
    }

    public List<Interval> refineOnLogScale(Interval interval, int numSubIntervals, double basis, double pointOfConcentration, boolean createPointIntervalsForExtremalValues) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        double min = interval.getInf();
        double max = interval.getSup();
        this.logger.debug("Received call to create {} log-scaled sub-intervals for interval [{},{}] to the basis {}.", new Object[]{numSubIntervals, min, max, basis});
        double length = max - min;
        if (pointOfConcentration <= min || pointOfConcentration >= max) {
            int numOfGeneratedSubIntervals = numSubIntervals;
            if (createPointIntervalsForExtremalValues) {
                numOfGeneratedSubIntervals -= 2;
            }
            if (numOfGeneratedSubIntervals <= 0) {
                throw new IllegalArgumentException("Number of created sub-intervals must be strictly positive but is " + numOfGeneratedSubIntervals + ".");
            }
            double lengthOfShortestInterval = length * (1.0 - basis) / (1.0 - Math.pow(basis, numOfGeneratedSubIntervals));
            while (lengthOfShortestInterval < 1.0E-10) {
                this.logger.trace("Initial interval would have size {} for a total number of {} sub-intervals, but length must be at least 10^-10. Reducing the number by 1.", (Object)lengthOfShortestInterval, (Object)numOfGeneratedSubIntervals);
                lengthOfShortestInterval = length * (1.0 - basis) / (1.0 - Math.pow(basis, --numOfGeneratedSubIntervals));
            }
            this.logger.debug("Generating {} log-scaled sub-intervals for interval [{},{}] to the basis {}. Length of shortest interval is {}", new Object[]{numOfGeneratedSubIntervals, min, max, basis, lengthOfShortestInterval});
            if (pointOfConcentration <= min) {
                double endOfLast = min;
                for (int i = 0; i < numOfGeneratedSubIntervals; ++i) {
                    double start = endOfLast;
                    assert (start >= min);
                    endOfLast = start + Math.pow(basis, i) * lengthOfShortestInterval;
                    assert (endOfLast <= max) : "Sub-Interval must not assume values greater than a vaule of the original interval.";
                    if (endOfLast <= start) {
                        throw new IllegalArgumentException("Interval size for [" + start + ", " + (start + Math.pow(basis, i) * lengthOfShortestInterval) + "] is not positive.");
                    }
                    list.add(new Interval(start, endOfLast));
                    this.logger.trace("Added interval [{}, {}]", (Object)start, (Object)endOfLast);
                }
            } else {
                double endOfLast = max;
                for (int i = 0; i < numOfGeneratedSubIntervals; ++i) {
                    double start = endOfLast;
                    endOfLast = start - Math.pow(basis, i) * lengthOfShortestInterval;
                    list.add(new Interval(endOfLast, start));
                }
                Collections.reverse(list);
            }
            if (createPointIntervalsForExtremalValues) {
                list.add(0, new Interval(min, min));
                list.add(new Interval(max, max));
            }
            return list;
        }
        double distanceFromMinToFocus = Math.abs(interval.getInf() - pointOfConcentration);
        int segmentsForLeft = (int)Math.max(1.0, Math.floor((double)numSubIntervals * distanceFromMinToFocus / length));
        if (createPointIntervalsForExtremalValues) {
            segmentsForLeft += 2;
        }
        int segmentsForRight = numSubIntervals - segmentsForLeft;
        assert (segmentsForRight >= 1);
        if (!createPointIntervalsForExtremalValues || segmentsForRight < 3) {
            throw new IllegalArgumentException("No refinement possible if interval points are not included or segments for the right are less than 3");
        }
        this.logger.debug("Focus {} is inside the given interval. Create two partitions, one on the left ({} segments), and one on the right ({} segments).", new Object[]{pointOfConcentration, segmentsForLeft, segmentsForRight});
        list.addAll(this.refineOnLogScale(new Interval(min, pointOfConcentration), segmentsForLeft, basis, pointOfConcentration, createPointIntervalsForExtremalValues));
        list.addAll(this.refineOnLogScale(new Interval(pointOfConcentration, max), segmentsForRight, basis, pointOfConcentration, createPointIntervalsForExtremalValues));
        return list;
    }
}

