/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.serialization.ComponentLoader;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class SoftwareConfigurationProblem<V extends Comparable<V>> {
    private final Collection<Component> components;
    private final String requiredInterface;
    private final IObjectEvaluator<ComponentInstance, V> compositionEvaluator;

    public SoftwareConfigurationProblem(File configurationFile, String requiredInerface, IObjectEvaluator<ComponentInstance, V> compositionEvaluator) throws IOException {
        ComponentLoader cl = new ComponentLoader();
        cl.loadComponents(configurationFile);
        this.components = cl.getComponents();
        this.requiredInterface = requiredInerface;
        this.compositionEvaluator = compositionEvaluator;
    }

    public SoftwareConfigurationProblem(Collection<Component> components, String requiredInterface, IObjectEvaluator<ComponentInstance, V> compositionEvaluator) {
        this.components = components;
        this.requiredInterface = requiredInterface;
        this.compositionEvaluator = compositionEvaluator;
    }

    public SoftwareConfigurationProblem(SoftwareConfigurationProblem<V> problem) {
        this.components = problem.getComponents();
        this.requiredInterface = problem.requiredInterface;
        this.compositionEvaluator = problem.compositionEvaluator;
    }

    public Collection<Component> getComponents() {
        return this.components;
    }

    public String getRequiredInterface() {
        return this.requiredInterface;
    }

    public IObjectEvaluator<ComponentInstance, V> getCompositionEvaluator() {
        return this.compositionEvaluator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.components == null ? 0 : this.components.hashCode());
        result = 31 * result + (this.compositionEvaluator == null ? 0 : this.compositionEvaluator.hashCode());
        result = 31 * result + (this.requiredInterface == null ? 0 : this.requiredInterface.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoftwareConfigurationProblem other = (SoftwareConfigurationProblem)obj;
        if (this.components == null ? other.components != null : !this.components.equals(other.components)) {
            return false;
        }
        if (this.compositionEvaluator == null ? other.compositionEvaluator != null : !this.compositionEvaluator.equals(other.compositionEvaluator)) {
            return false;
        }
        return !(this.requiredInterface == null ? other.requiredInterface != null : !this.requiredInterface.equals(other.requiredInterface));
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("components", this.components);
        fields.put("requiredInterface", this.requiredInterface);
        fields.put("compositionEvaluator", this.compositionEvaluator);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

