/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.basic.IInformedObjectEvaluatorExtension;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import java.util.Map;

public class TimeRecordingEvaluationWrapper<V extends Comparable<V>>
implements IObjectEvaluator<ComponentInstance, V>,
IInformedObjectEvaluatorExtension<V> {
    private final IObjectEvaluator<ComponentInstance, V> baseEvaluator;
    private final Map<ComponentInstance, Integer> consumedTimes = new HashMap<ComponentInstance, Integer>();

    public TimeRecordingEvaluationWrapper(IObjectEvaluator<ComponentInstance, V> baseEvaluator) {
        this.baseEvaluator = baseEvaluator;
    }

    public V evaluate(ComponentInstance object) throws InterruptedException, ObjectEvaluationFailedException {
        long start = System.currentTimeMillis();
        Comparable score = this.baseEvaluator.evaluate((Object)object);
        long end = System.currentTimeMillis();
        this.consumedTimes.put(object, (int)(end - start));
        return (V)score;
    }

    public boolean hasEvaluationForComponentInstance(ComponentInstance inst) {
        return this.consumedTimes.containsKey(inst);
    }

    public int getEvaluationTimeForComponentInstance(ComponentInstance inst) {
        return this.consumedTimes.get(inst);
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("baseEvaluator", this.baseEvaluator);
        fields.put("consumedTimes", this.consumedTimes);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    public void updateBestScore(V bestScore) {
        if (this.baseEvaluator instanceof IInformedObjectEvaluatorExtension) {
            ((IInformedObjectEvaluatorExtension)this.baseEvaluator).updateBestScore(bestScore);
        }
    }
}

