/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.core;

import ai.libs.hasco.core.IHASCOPlanningReduction;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.Dependency;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.LiteralParam;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.classical.algorithms.strips.forward.StripsUtil;
import ai.libs.jaicore.planning.core.Action;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.search.model.other.SearchGraphPath;
import ai.libs.jaicore.search.model.travesaltree.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final String LITERAL_RESOLVES = "resolves";
    private static final String LITERAL_PARAMCONTAINER = "parameterContainer";
    private static final String LITERAL_VAL = "val";
    private static final String LITERAL_INTERFACEIDENTIFIER = "interfaceIdentifier";
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    static Map<String, String> getParameterContainerMap(Monom state, String objectName) {
        HashMap<String, String> parameterContainerMap = new HashMap<String, String>();
        List<Literal> containerLiterals = state.stream().filter(l -> l.getPropertyName().equals(LITERAL_PARAMCONTAINER) && ((LiteralParam)l.getParameters().get(2)).getName().equals(objectName)).collect(Collectors.toList());
        containerLiterals.forEach(l -> parameterContainerMap.put(((LiteralParam)l.getParameters().get(1)).getName(), ((LiteralParam)l.getParameters().get(3)).getName()));
        return parameterContainerMap;
    }

    public static Map<ComponentInstance, Map<Parameter, String>> getParametrizations(Monom state, Collection<Component> components, boolean resolveIntervals) {
        HashMap<String, ComponentInstance> objectMap = new HashMap<String, ComponentInstance>();
        HashMap parameterContainerMap = new HashMap();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        HashMap<ComponentInstance, Map<Parameter, String>> parameterValuesPerComponentInstance = new HashMap<ComponentInstance, Map<Parameter, String>>();
        Collection<String> overwrittenDataContainers = Util.getOverwrittenDatacontainersInState(state);
        for (Literal l : state) {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l.getPropertyName()) {
                case "resolves": {
                    String componentName = params[2];
                    String objectName = params[3];
                    Optional<Component> component = components.stream().filter(c -> c.getName().equals(componentName)).findAny();
                    assert (component.isPresent()) : "Could not find component with name " + componentName;
                    ComponentInstance object = new ComponentInstance(component.get(), new HashMap<String, String>(), new HashMap<String, ComponentInstance>());
                    objectMap.put(objectName, object);
                    break;
                }
                case "parameterContainer": {
                    if (!parameterContainerMap.containsKey(params[2])) {
                        parameterContainerMap.put(params[2], new HashMap());
                    }
                    ((Map)parameterContainerMap.get(params[2])).put(params[1], params[3]);
                    break;
                }
                case "val": {
                    if (!overwrittenDataContainers.contains(params[0])) break;
                    parameterValues.put(params[0], params[1]);
                    break;
                }
            }
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            HashMap<Parameter, String> paramValuesForThisComponent = new HashMap<Parameter, String>();
            String objectName = (String)entry.getKey();
            ComponentInstance object = (ComponentInstance)entry.getValue();
            parameterValuesPerComponentInstance.put(object, paramValuesForThisComponent);
            for (Parameter p : object.getComponent().getParameters()) {
                assert (parameterContainerMap.containsKey(objectName)) : "No parameter container map has been defined for object " + objectName + " of component " + object.getComponent().getName() + "!";
                assert (((Map)parameterContainerMap.get(objectName)).containsKey(p.getName())) : "The data container for parameter " + p.getName() + " of " + object.getComponent().getName() + " is not defined!";
                String assignedValue = (String)parameterValues.get(((Map)parameterContainerMap.get(objectName)).get(p.getName()));
                String interpretedValue = "";
                if (assignedValue == null) continue;
                if (p.getDefaultDomain() instanceof NumericParameterDomain) {
                    if (resolveIntervals) {
                        NumericParameterDomain np = (NumericParameterDomain)p.getDefaultDomain();
                        List vals = SetUtil.unserializeList((String)assignedValue);
                        Interval interval = new Interval(Double.valueOf((String)vals.get(0)).doubleValue(), Double.valueOf((String)vals.get(1)).doubleValue());
                        interpretedValue = np.isInteger() ? String.valueOf((int)Math.round(interval.getBarycenter())) : String.valueOf(interval.getBarycenter());
                    } else {
                        interpretedValue = assignedValue;
                    }
                } else if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
                    interpretedValue = assignedValue;
                } else {
                    throw new UnsupportedOperationException("No support for parameters of type " + p.getClass().getName());
                }
                paramValuesForThisComponent.put(p, interpretedValue);
            }
        }
        return parameterValuesPerComponentInstance;
    }

    public static Collection<String> getOverwrittenDatacontainersInState(Monom state) {
        return state.stream().filter(l -> l.getPropertyName().equals("overwritten")).map(l -> ((LiteralParam)l.getParameters().get(0)).getName()).collect(Collectors.toSet());
    }

    public static Collection<String> getClosedDatacontainersInState(Monom state) {
        return state.stream().filter(l -> l.getPropertyName().equals("closed")).map(l -> ((LiteralParam)l.getParameters().get(0)).getName()).collect(Collectors.toSet());
    }

    static Map<String, ComponentInstance> getGroundComponentsFromState(Monom state, Collection<Component> components, boolean resolveIntervals) {
        HashMap<String, ComponentInstance> objectMap = new HashMap<String, ComponentInstance>();
        HashMap parameterContainerMap = new HashMap();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        HashMap<String, String> interfaceContainerMap = new HashMap<String, String>();
        Collection<String> overwrittenDatacontainers = Util.getOverwrittenDatacontainersInState(state);
        for (Literal l2 : state) {
            String[] params = l2.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l2.getPropertyName()) {
                case "resolves": {
                    String componentName = params[2];
                    String objectName = params[3];
                    Optional<Component> component = components.stream().filter(c -> c.getName().equals(componentName)).findAny();
                    assert (component.isPresent()) : "Could not find component with name " + componentName;
                    ComponentInstance object = new ComponentInstance(component.get(), new HashMap<String, String>(), new HashMap<String, ComponentInstance>());
                    objectMap.put(objectName, object);
                    break;
                }
                case "parameterContainer": {
                    if (!parameterContainerMap.containsKey(params[2])) {
                        parameterContainerMap.put(params[2], new HashMap());
                    }
                    ((Map)parameterContainerMap.get(params[2])).put(params[1], params[3]);
                    break;
                }
                case "val": {
                    parameterValues.put(params[0], params[1]);
                    break;
                }
                case "interfaceIdentifier": {
                    interfaceContainerMap.put(params[3], params[1]);
                    break;
                }
            }
        }
        state.stream().filter(l -> l.getPropertyName().equals(LITERAL_RESOLVES)).forEach(l -> {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            String parentObjectName = params[0];
            String objectName = params[3];
            ComponentInstance object = (ComponentInstance)objectMap.get(objectName);
            if (!parentObjectName.equals("request")) {
                assert (interfaceContainerMap.containsKey(objectName)) : "Object name " + objectName + " for requried interface must have a defined identifier ";
                ((ComponentInstance)objectMap.get(parentObjectName)).getSatisfactionOfRequiredInterfaces().put((String)interfaceContainerMap.get(objectName), object);
            }
        });
        for (Map.Entry entry : objectMap.entrySet()) {
            String objectName = (String)entry.getKey();
            ComponentInstance object = (ComponentInstance)entry.getValue();
            for (Parameter p : object.getComponent().getParameters()) {
                assert (parameterContainerMap.containsKey(objectName)) : "No parameter container map has been defined for object " + objectName + " of component " + object.getComponent().getName() + "!";
                assert (((Map)parameterContainerMap.get(objectName)).containsKey(p.getName())) : "The data container for parameter " + p.getName() + " of " + object.getComponent().getName() + " is not defined! State: " + state.stream().sorted().map(l -> "\n\t" + l).collect(Collectors.joining());
                String paramContainerName = (String)((Map)parameterContainerMap.get(objectName)).get(p.getName());
                if (!overwrittenDatacontainers.contains(paramContainerName)) continue;
                String assignedValue = (String)parameterValues.get(paramContainerName);
                assert (assignedValue != null) : "parameter containers must always have a value!";
                object.getParameterValues().put(p.getName(), Util.getParamValue(p, assignedValue, resolveIntervals));
            }
        }
        return objectMap;
    }

    public static <N, A, V extends Comparable<V>> ComponentInstance getSolutionCompositionForNode(IHASCOPlanningReduction<N, A> planningGraphDeriver, Collection<Component> components, Monom initState, Node<N, ?> path, boolean resolveIntervals) {
        return Util.getSolutionCompositionForPlan(components, initState, (IPlan)planningGraphDeriver.decodeSolution(new SearchGraphPath(path.externalPath())), resolveIntervals);
    }

    public static <N, A, V extends Comparable<V>> ComponentInstance getComponentInstanceForNode(IHASCOPlanningReduction<N, A> planningGraphDeriver, Collection<Component> components, Monom initState, Node<N, ?> path, String name, boolean resolveIntervals) {
        return Util.getComponentInstanceForPlan(components, initState, (IPlan)planningGraphDeriver.decodeSolution(new SearchGraphPath(path.externalPath())), name, resolveIntervals);
    }

    public static Monom getFinalStateOfPlan(Monom initState, IPlan plan) {
        Monom state = new Monom((Collection)initState);
        for (Action a : plan.getActions()) {
            StripsUtil.updateState((Monom)state, (Action)a);
        }
        return state;
    }

    public static ComponentInstance getSolutionCompositionForPlan(Collection<Component> components, Monom initState, IPlan plan, boolean resolveIntervals) {
        return Util.getSolutionCompositionFromState(components, Util.getFinalStateOfPlan(initState, plan), resolveIntervals);
    }

    public static ComponentInstance getComponentInstanceForPlan(Collection<Component> components, Monom initState, IPlan plan, String name, boolean resolveIntervals) {
        return Util.getComponentInstanceFromState(components, Util.getFinalStateOfPlan(initState, plan), name, resolveIntervals);
    }

    public static ComponentInstance getSolutionCompositionFromState(Collection<Component> components, Monom state, boolean resolveIntervals) {
        return Util.getComponentInstanceFromState(components, state, "solution", resolveIntervals);
    }

    public static ComponentInstance getComponentInstanceFromState(Collection<Component> components, Monom state, String name, boolean resolveIntervals) {
        return Util.getGroundComponentsFromState(state, components, resolveIntervals).get(name);
    }

    public static List<ComponentInstance> getComponentInstancesOfComposition(ComponentInstance composition) {
        LinkedList<ComponentInstance> components = new LinkedList<ComponentInstance>();
        ArrayDeque<ComponentInstance> componentInstances = new ArrayDeque<ComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            ComponentInstance curInstance = (ComponentInstance)componentInstances.pop();
            components.add(curInstance);
            Map<String, String> requiredInterfaces = curInstance.getComponent().getRequiredInterfaces();
            Set<String> requiredInterfaceNames = requiredInterfaces.keySet();
            for (String requiredInterfaceName : requiredInterfaceNames) {
                ComponentInstance instance = curInstance.getSatisfactionOfRequiredInterfaces().get(requiredInterfaceName);
                componentInstances.push(instance);
            }
        }
        return components;
    }

    public static String getComponentNamesOfComposition(ComponentInstance composition) {
        StringBuilder builder = new StringBuilder();
        ArrayDeque<ComponentInstance> componentInstances = new ArrayDeque<ComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            ComponentInstance curInstance = (ComponentInstance)componentInstances.pop();
            builder.append(curInstance.getComponent().getName());
            Map<String, String> requiredInterfaces = curInstance.getComponent().getRequiredInterfaces();
            Set<String> requiredInterfaceNames = requiredInterfaces.keySet();
            for (String requiredInterfaceName : requiredInterfaceNames) {
                ComponentInstance instance = curInstance.getSatisfactionOfRequiredInterfaces().get(requiredInterfaceName);
                componentInstances.push(instance);
            }
        }
        return builder.toString();
    }

    public static List<Component> getComponentsOfComposition(ComponentInstance composition) {
        LinkedList<Component> components = new LinkedList<Component>();
        ArrayDeque<ComponentInstance> componentInstances = new ArrayDeque<ComponentInstance>();
        componentInstances.push(composition);
        while (!componentInstances.isEmpty()) {
            ComponentInstance curInstance = (ComponentInstance)componentInstances.pop();
            components.add(curInstance.getComponent());
            Map<String, String> requiredInterfaces = curInstance.getComponent().getRequiredInterfaces();
            Set<String> requiredInterfaceNames = requiredInterfaces.keySet();
            for (String requiredInterfaceName : requiredInterfaceNames) {
                ComponentInstance instance = curInstance.getSatisfactionOfRequiredInterfaces().get(requiredInterfaceName);
                componentInstances.push(instance);
            }
        }
        return components;
    }

    public static Map<Parameter, IParameterDomain> getUpdatedDomainsOfComponentParameters(Monom state, Component component, String objectIdentifierInState) {
        HashMap<String, String> parameterContainerMap = new HashMap<String, String>();
        HashMap<String, String> parameterContainerMapInv = new HashMap<String, String>();
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (Object l : state) {
            String[] params = l.getParameters().stream().map(LiteralParam::getName).collect(Collectors.toList()).toArray(new String[0]);
            switch (l.getPropertyName()) {
                case "parameterContainer": {
                    if (!params[2].equals(objectIdentifierInState)) break;
                    parameterContainerMap.put(params[1], params[3]);
                    parameterContainerMapInv.put(params[3], params[1]);
                    break;
                }
                case "val": {
                    parameterValues.put(params[0], params[1]);
                    break;
                }
            }
        }
        HashMap<Parameter, String> paramValuesForThisComponentInstance = new HashMap<Parameter, String>();
        for (Parameter p : component.getParameters()) {
            if (!parameterContainerMap.containsKey(p.getName())) {
                throw new IllegalStateException("The data container for parameter " + p.getName() + " of " + objectIdentifierInState + " is not defined!");
            }
            String assignedValue = (String)parameterValues.get(parameterContainerMap.get(p.getName()));
            if (assignedValue == null) {
                throw new IllegalStateException("No value has been assigned to parameter " + p.getName() + " stored in container " + (String)parameterContainerMap.get(p.getName()) + " in state " + state);
            }
            String value = Util.getParamValue(p, assignedValue, false);
            assert (value != null) : "Determined value NULL for parameter " + p.getName() + ", which is not plausible.";
            paramValuesForThisComponentInstance.put(p, value);
        }
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        ComponentInstance instance = Util.getComponentInstanceFromState(components, state, objectIdentifierInState, false);
        return Util.getUpdatedDomainsOfComponentParameters(instance);
    }

    private static String getParamValue(Parameter p, String assignedValue, boolean resolveIntervals) {
        if (assignedValue == null) {
            throw new IllegalArgumentException("Cannot determine true value for assigned param value " + assignedValue + " for parameter " + p.getName());
        }
        String interpretedValue = "";
        if (p.isNumeric()) {
            if (resolveIntervals) {
                NumericParameterDomain np = (NumericParameterDomain)p.getDefaultDomain();
                List vals = SetUtil.unserializeList((String)assignedValue);
                Interval interval = new Interval(Double.valueOf((String)vals.get(0)).doubleValue(), Double.valueOf((String)vals.get(1)).doubleValue());
                interpretedValue = np.isInteger() ? String.valueOf((int)Math.round(interval.getBarycenter())) : String.valueOf(interval.checkPoint(((Double)p.getDefaultValue()).doubleValue(), 0.001) == Region.Location.INSIDE ? ((Double)p.getDefaultValue()).doubleValue() : interval.getBarycenter());
            } else {
                interpretedValue = assignedValue;
            }
        } else if (p.getDefaultDomain() instanceof CategoricalParameterDomain) {
            interpretedValue = assignedValue;
        } else {
            throw new UnsupportedOperationException("No support for parameters of type " + p.getClass().getName());
        }
        return interpretedValue;
    }

    public static Map<Parameter, IParameterDomain> getUpdatedDomainsOfComponentParameters(ComponentInstance componentInstance) {
        Component component = componentInstance.getComponent();
        HashMap<Parameter, IParameterDomain> domains = new HashMap<Parameter, IParameterDomain>();
        for (Parameter p : componentInstance.getParametersThatHaveBeenSetExplicitly()) {
            if (p.isNumeric()) {
                NumericParameterDomain defaultDomain = (NumericParameterDomain)p.getDefaultDomain();
                Interval interval = SetUtil.unserializeInterval((String)componentInstance.getParameterValue(p));
                domains.put(p, new NumericParameterDomain(defaultDomain.isInteger(), interval.getInf(), interval.getSup()));
                continue;
            }
            if (!p.isCategorical()) continue;
            domains.put(p, new CategoricalParameterDomain(new String[]{componentInstance.getParameterValue(p)}));
        }
        for (Parameter p : componentInstance.getParametersThatHaveNotBeenSetExplicitly()) {
            domains.put(p, p.getDefaultDomain());
        }
        assert (domains.keySet().equals(component.getParameters())) : "There are parameters for which no current domain was derived.";
        for (Dependency dependency : component.getDependencies()) {
            if (Util.isDependencyPremiseSatisfied(dependency, domains)) {
                logger.info("Premise of dependency {} is satisfied, applying its conclusions ...", (Object)dependency);
                for (Pair<Parameter, IParameterDomain> newDomain : dependency.getConclusion()) {
                    Parameter param = (Parameter)newDomain.getX();
                    IParameterDomain concludedDomain = (IParameterDomain)newDomain.getY();
                    if (!componentInstance.getParametersThatHaveBeenSetExplicitly().contains(param)) {
                        domains.put(param, concludedDomain);
                        logger.debug("Changing domain of {} from {} to {}", new Object[]{param, domains.get(param), concludedDomain});
                        continue;
                    }
                    logger.debug("Not changing domain of {} since it has already been set explicitly in the past.", (Object)param);
                }
                continue;
            }
            logger.debug("Ignoring unsatisfied dependency {}.", (Object)dependency);
        }
        return domains;
    }

    public static boolean isDependencyPremiseSatisfied(Dependency dependency, Map<Parameter, IParameterDomain> values) {
        logger.debug("Checking satisfcation of dependency {} with values {}", (Object)dependency, values);
        for (Collection<Pair<Parameter, IParameterDomain>> condition : dependency.getPremise()) {
            boolean check = Util.isDependencyConditionSatisfied(condition, values);
            logger.trace("Result of check for condition {}: {}", condition, (Object)check);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static boolean isDependencyConditionSatisfied(Collection<Pair<Parameter, IParameterDomain>> condition, Map<Parameter, IParameterDomain> values) {
        for (Pair<Parameter, IParameterDomain> conditionItem : condition) {
            IParameterDomain actualDomain;
            Parameter param = (Parameter)conditionItem.getX();
            if (!values.containsKey(param)) {
                throw new IllegalArgumentException("Cannot check condition " + condition + " as the value for parameter " + param.getName() + " is not defined in " + values);
            }
            if (values.get(param) == null) {
                throw new IllegalArgumentException("Cannot check condition " + condition + " as the value for parameter " + param.getName() + " is NULL in " + values);
            }
            IParameterDomain requiredDomain = (IParameterDomain)conditionItem.getY();
            if (requiredDomain.subsumes(actualDomain = values.get(param))) continue;
            return false;
        }
        return true;
    }

    public static List<Interval> getNumericParameterRefinement(Interval interval, double focus, boolean integer, ParameterRefinementConfiguration refinementConfig) {
        double sup;
        double inf = interval.getInf();
        if (inf == (sup = interval.getSup())) {
            return new ArrayList<Interval>();
        }
        if (integer && Math.floor(sup) - Math.ceil(inf) + 1.0 <= (double)refinementConfig.getRefinementsPerStep()) {
            ArrayList<Interval> proposedRefinements = new ArrayList<Interval>();
            for (int i = (int)Math.ceil(inf); i <= (int)Math.floor(sup); ++i) {
                proposedRefinements.add(new Interval((double)i, (double)i));
            }
            return proposedRefinements;
        }
        if (sup - inf < refinementConfig.getIntervalLength()) {
            return new ArrayList<Interval>();
        }
        if (!refinementConfig.isInitRefinementOnLogScale()) {
            List<Interval> proposedRefinements = Util.refineOnLinearScale(interval, refinementConfig.getRefinementsPerStep(), refinementConfig.getIntervalLength());
            for (Interval proposedRefinement : proposedRefinements) {
                assert (proposedRefinement.getInf() >= inf && proposedRefinement.getSup() <= sup) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of [" + inf + ", " + sup + "].";
                if (!proposedRefinement.equals(interval)) continue;
                throw new IllegalStateException("No real refinement! Intervals are identical.");
            }
            return proposedRefinements;
        }
        List<Interval> proposedRefinements = Util.refineOnLogScale(interval, refinementConfig.getRefinementsPerStep(), 2.0, focus);
        for (Interval proposedRefinement : proposedRefinements) {
            double epsilon = 1.0E-7;
            assert (proposedRefinement.getInf() + epsilon >= inf && proposedRefinement.getSup() <= sup + epsilon) : "The proposed refinement [" + proposedRefinement.getInf() + ", " + proposedRefinement.getSup() + "] is not a sub-interval of [" + inf + ", " + sup + "].";
            if (!proposedRefinement.equals(interval)) continue;
            throw new IllegalStateException("No real refinement! Intervals are identical.");
        }
        return proposedRefinements;
    }

    public static List<Interval> refineOnLinearScale(Interval interval, int maxNumberOfSubIntervals, double minimumLengthOfIntervals) {
        double min = interval.getInf();
        double max = interval.getSup();
        double length = max - min;
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        if (length <= minimumLengthOfIntervals) {
            intervals.add(interval);
            return intervals;
        }
        int numberOfIntervals = Math.min((int)Math.ceil(length / minimumLengthOfIntervals), maxNumberOfSubIntervals);
        double stepSize = length / (double)numberOfIntervals;
        for (int i = 0; i < numberOfIntervals; ++i) {
            intervals.add(new Interval(min + (double)i * stepSize, min + (double)(i + 1) * stepSize));
        }
        return intervals;
    }

    public static List<Interval> refineOnLogScale(Interval interval, int n, double basis, double pointOfConcentration) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        double min = interval.getInf();
        double max = interval.getSup();
        double length = max - min;
        if (pointOfConcentration <= min || pointOfConcentration >= max) {
            double lengthOfShortestInterval = length * (1.0 - basis) / (1.0 - Math.pow(basis, n));
            if (pointOfConcentration <= min) {
                double endOfLast = min;
                for (int i = 0; i < n; ++i) {
                    double start = endOfLast;
                    endOfLast = start + Math.pow(basis, i) * lengthOfShortestInterval;
                    list.add(new Interval(start, endOfLast));
                }
            } else {
                double endOfLast = max;
                for (int i = 0; i < n; ++i) {
                    double start = endOfLast;
                    endOfLast = start - Math.pow(basis, i) * lengthOfShortestInterval;
                    list.add(new Interval(endOfLast, start));
                }
                Collections.reverse(list);
            }
            return list;
        }
        double distanceFromMinToFocus = Math.abs(interval.getInf() - pointOfConcentration);
        int segmentsForLeft = (int)Math.max(1.0, Math.floor((double)n * distanceFromMinToFocus / length));
        int segmentsForRight = n - segmentsForLeft;
        list.addAll(Util.refineOnLogScale(new Interval(min, pointOfConcentration), segmentsForLeft, basis, pointOfConcentration));
        list.addAll(Util.refineOnLogScale(new Interval(pointOfConcentration, max), segmentsForRight, basis, pointOfConcentration));
        return list;
    }

    public static void refineRecursively(Interval interval, int maxNumberOfSubIntervalsPerRefinement, double basis, double pointOfConcentration, double factorForMaximumLengthOfFinestIntervals) {
        List<Interval> initRefinement = Util.refineOnLogScale(interval, maxNumberOfSubIntervalsPerRefinement, basis, pointOfConcentration);
        Collections.reverse(initRefinement);
        LinkedList<Interval> openRefinements = new LinkedList<Interval>();
        openRefinements.addAll(initRefinement);
        int depth = 0;
        do {
            Interval intervalToRefine = (Interval)openRefinements.pop();
            if (logger.isInfoEnabled()) {
                StringBuilder offsetSB = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    offsetSB.append("\t");
                }
                logger.info("{}[{}, {}]", new Object[]{offsetSB, intervalToRefine.getInf(), intervalToRefine.getSup()});
            }
            double distanceToPointOfContentration = Math.min(Math.abs(intervalToRefine.getInf() - pointOfConcentration), Math.abs(intervalToRefine.getSup() - pointOfConcentration));
            double maximumLengthOfFinestIntervals = Math.pow(distanceToPointOfContentration + 1.0, 2.0) * factorForMaximumLengthOfFinestIntervals;
            logger.info("{} * {} = {}", new Object[]{Math.pow(distanceToPointOfContentration + 1.0, 2.0), factorForMaximumLengthOfFinestIntervals, maximumLengthOfFinestIntervals});
            List<Interval> refinements = Util.refineOnLinearScale(intervalToRefine, maxNumberOfSubIntervalsPerRefinement, maximumLengthOfFinestIntervals);
            ++depth;
            if (refinements.size() == 1 && refinements.get(0).equals(intervalToRefine)) {
                --depth;
                continue;
            }
            Collections.reverse(refinements);
            openRefinements.addAll(refinements);
        } while (!openRefinements.isEmpty());
    }
}

