/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.gui.statsplugin;

import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginModel;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginView;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.UnparametrizedComponentInstance;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.ScoredSolutionCandidateInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HASCOModelStatisticsComponentSelector
extends TreeItem<HASCOModelStatisticsComponentSelector> {
    private static final Logger logger = LoggerFactory.getLogger(HASCOModelStatisticsComponentSelector.class);
    private final HASCOModelStatisticsComponentSelector parent;
    private final String requiredInterface;
    private final ComboBox<String> componentSelector;
    private final HASCOModelStatisticsPluginModel model;

    public HASCOModelStatisticsComponentSelector(HASCOModelStatisticsPluginView rootView, HASCOModelStatisticsPluginModel model) {
        this(rootView, null, null, model);
    }

    public HASCOModelStatisticsComponentSelector(final HASCOModelStatisticsPluginView rootView, HASCOModelStatisticsComponentSelector parent, String requiredInterface, final HASCOModelStatisticsPluginModel model) {
        this.parent = parent;
        this.requiredInterface = requiredInterface;
        this.model = model;
        this.componentSelector = new ComboBox();
        this.componentSelector.getItems().add((Object)"*");
        this.componentSelector.setValue((Object)"*");
        this.componentSelector.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                HASCOModelStatisticsComponentSelector.this.getChildren().clear();
                if (!newValue.equals("*")) {
                    Map<String, String> requiredInterfacesOfThisChoice = model.getKnownComponents().get(newValue).getRequiredInterfaces();
                    for (String requiredInterfaceId : requiredInterfacesOfThisChoice.keySet()) {
                        HASCOModelStatisticsComponentSelector.this.getChildren().add((Object)new HASCOModelStatisticsComponentSelector(rootView, HASCOModelStatisticsComponentSelector.this, requiredInterfaceId, model));
                    }
                }
                rootView.updateHistogram();
            }
        });
        this.update();
        this.setValue((Object)this);
        this.setExpanded(true);
    }

    public void update() {
        long start = System.currentTimeMillis();
        List<Pair<String, String>> selectionPath = this.getSelectionsOnPathToRoot();
        List<String> reqInterfacePath = selectionPath.stream().map(p -> (String)p.getX()).collect(Collectors.toList());
        reqInterfacePath.remove(0);
        ObservableList items = this.componentSelector.getItems();
        block0: for (ScoredSolutionCandidateInfo scoredSolutionCandidateInfo : this.model.getAllSeenSolutionCandidateFoundInfosUnordered()) {
            ComponentInstance ci = this.model.deserializeComponentInstance(scoredSolutionCandidateInfo.getSolutionCandidateRepresentation());
            if (!ci.matchesPathRestriction(selectionPath)) continue;
            UnparametrizedComponentInstance uci = new UnparametrizedComponentInstance(ci).getSubComposition(reqInterfacePath);
            if (this.componentSelector.getItems().contains((Object)uci.getComponentName())) continue;
            logger.trace("Relevant UCI of {} for path {} is {}", new Object[]{ci, reqInterfacePath, uci});
            int n = items.size();
            String nameOfNewComponent = uci.getComponentName();
            for (int i = 0; i <= n; ++i) {
                if (i != n && ((String)items.get(i)).compareTo(nameOfNewComponent) < 0) continue;
                items.add(i, (Object)nameOfNewComponent);
                continue block0;
            }
        }
        this.getChildren().forEach(ti -> ((HASCOModelStatisticsComponentSelector)((Object)((Object)ti.getValue()))).update());
        long duration = System.currentTimeMillis() - start;
        logger.debug("Update of {} took {}ms", (Object)this, (Object)duration);
    }

    public void clear() {
        this.componentSelector.getItems().removeIf(s -> !s.equals("*"));
        this.getChildren().clear();
    }

    public List<Pair<String, String>> getSelectionsOnPathToRoot() {
        List<Object> path = this.parent != null ? this.parent.getSelectionsOnPathToRoot() : new ArrayList();
        path.add(new Pair((Object)this.requiredInterface, this.componentSelector.getValue()));
        return path;
    }

    public Collection<List<Pair<String, String>>> getAllSelectionsOnPathToAnyLeaf() {
        ArrayList<List<Pair<String, String>>> subPaths = new ArrayList<List<Pair<String, String>>>();
        if (this.getChildren().isEmpty()) {
            ArrayList<Pair> leafRestriction = new ArrayList<Pair>();
            leafRestriction.add(new Pair((Object)this.requiredInterface, this.componentSelector.getValue()));
            subPaths.add(leafRestriction);
            return subPaths;
        }
        for (TreeItem child : this.getChildren()) {
            subPaths.addAll(((HASCOModelStatisticsComponentSelector)((Object)child.getValue())).getAllSelectionsOnPathToAnyLeaf());
        }
        return subPaths.stream().map(p -> {
            p.add(0, new Pair((Object)this.requiredInterface, this.componentSelector.getValue()));
            return p;
        }).collect(Collectors.toList());
    }

    public String getRequiredInterface() {
        return this.requiredInterface;
    }

    public ComboBox<String> getComponentSelector() {
        return this.componentSelector;
    }

    public String toString() {
        return "HASCOModelStatisticsComponentSelector";
    }
}

