/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.gui.statsplugin;

import ai.libs.hasco.gui.statsplugin.ComponentInstanceSerializer;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginController;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginView;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.UnparametrizedComponentInstance;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.ScoredSolutionCandidateInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HASCOModelStatisticsPluginModel
extends ASimpleMVCPluginModel<HASCOModelStatisticsPluginView, HASCOModelStatisticsPluginController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HASCOModelStatisticsPluginModel.class);
    private ComponentInstanceSerializer componentInstanceSerializer = new ComponentInstanceSerializer();
    private final Map<UnparametrizedComponentInstance, List<ScoredSolutionCandidateInfo>> observedSolutionsGroupedModuloParameters = new HashMap<UnparametrizedComponentInstance, List<ScoredSolutionCandidateInfo>>();
    private final Map<String, Component> knownComponents = new HashMap<String, Component>();

    public final void addEntry(ScoredSolutionCandidateInfo scoredSolutionCandidateInfo) {
        ComponentInstance ci = this.deserializeComponentInstance(scoredSolutionCandidateInfo.getSolutionCandidateRepresentation());
        if (ci == null) {
            return;
        }
        UnparametrizedComponentInstance uci = new UnparametrizedComponentInstance(ci);
        if (!this.observedSolutionsGroupedModuloParameters.containsKey(uci)) {
            this.observedSolutionsGroupedModuloParameters.put(uci, new ArrayList());
        }
        this.observedSolutionsGroupedModuloParameters.get(uci).add(scoredSolutionCandidateInfo);
        ci.getContainedComponents().forEach(c -> {
            if (!this.knownComponents.containsKey(c.getName())) {
                this.knownComponents.put(c.getName(), (Component)c);
            }
        });
        ((HASCOModelStatisticsPluginView)this.getView()).update();
    }

    public Collection<ScoredSolutionCandidateInfo> getAllSeenSolutionCandidateFoundInfosUnordered() {
        ArrayList<ScoredSolutionCandidateInfo> solutionEvents = new ArrayList<ScoredSolutionCandidateInfo>();
        this.observedSolutionsGroupedModuloParameters.values().forEach(l -> solutionEvents.addAll((Collection<ScoredSolutionCandidateInfo>)l));
        return solutionEvents;
    }

    public Map<String, Component> getKnownComponents() {
        return this.knownComponents;
    }

    public DescriptiveStatistics getPerformanceStatisticsForComposition(UnparametrizedComponentInstance composition) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        this.observedSolutionsGroupedModuloParameters.get(composition).forEach(e -> stats.addValue(this.parseScoreToDouble(e.getScore())));
        return stats;
    }

    public void clear() {
        this.observedSolutionsGroupedModuloParameters.clear();
        this.knownComponents.clear();
        ((HASCOModelStatisticsPluginView)this.getView()).clear();
    }

    public ComponentInstance deserializeComponentInstance(String serializedComponentInstance) {
        try {
            return this.componentInstanceSerializer.deserializeComponentInstance(serializedComponentInstance);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot deserialize component instance {}.", (Object)serializedComponentInstance, (Object)e);
            return null;
        }
    }

    public double parseScoreToDouble(String score) throws NumberFormatException {
        return Double.parseDouble(score);
    }
}

