/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.gui.statsplugin;

import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsComponentCell;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsComponentSelector;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginController;
import ai.libs.hasco.gui.statsplugin.HASCOModelStatisticsPluginModel;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.graphvisualizer.events.gui.Histogram;
import ai.libs.jaicore.graphvisualizer.plugin.ASimpleMVCPluginView;
import ai.libs.jaicore.graphvisualizer.plugin.IGUIPluginModel;
import ai.libs.jaicore.graphvisualizer.plugin.solutionperformanceplotter.ScoredSolutionCandidateInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class HASCOModelStatisticsPluginView
extends ASimpleMVCPluginView<HASCOModelStatisticsPluginModel, HASCOModelStatisticsPluginController, VBox> {
    private final HASCOModelStatisticsComponentSelector rootNode;
    private final Histogram histogram;

    public HASCOModelStatisticsPluginView(HASCOModelStatisticsPluginModel model) {
        this(model, 100);
    }

    public HASCOModelStatisticsPluginView(HASCOModelStatisticsPluginModel model, int n) {
        super((IGUIPluginModel)model, (Node)new VBox());
        this.rootNode = new HASCOModelStatisticsComponentSelector(this, model);
        TreeView treeView = new TreeView();
        treeView.setCellFactory(tv -> new HASCOModelStatisticsComponentCell((TreeView<HASCOModelStatisticsComponentSelector>)tv));
        treeView.setRoot((TreeItem)this.rootNode);
        ((VBox)this.getNode()).getChildren().add((Object)treeView);
        this.histogram = new Histogram(n);
        this.histogram.setTitle("Performances observed on the filtered solutions");
        ((VBox)this.getNode()).getChildren().add((Object)this.histogram);
    }

    public void update() {
        this.rootNode.update();
        this.updateHistogram();
    }

    public void updateHistogram() {
        Collection<List<Pair<String, String>>> activeFilters = this.rootNode.getAllSelectionsOnPathToAnyLeaf();
        List<ScoredSolutionCandidateInfo> activeSolutions = ((HASCOModelStatisticsPluginModel)this.getModel()).getAllSeenSolutionCandidateFoundInfosUnordered().stream().filter(i -> ((HASCOModelStatisticsPluginModel)this.getModel()).deserializeComponentInstance(i.getSolutionCandidateRepresentation()).matchesPathRestrictions(activeFilters)).collect(Collectors.toList());
        DescriptiveStatistics stats = new DescriptiveStatistics();
        activeSolutions.forEach(s -> stats.addValue(((HASCOModelStatisticsPluginModel)this.getModel()).parseScoreToDouble(s.getScore())));
        Platform.runLater(() -> this.histogram.update(stats));
    }

    public String getTitle() {
        return "HASCO Model Statistics";
    }

    public void clear() {
        this.rootNode.clear();
        this.histogram.clear();
    }
}

