/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.knowledgebase;

import ai.libs.hasco.knowledgebase.IParameterImportanceEstimator;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.Parameter;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FANOVAWarmstartComparator
implements Comparator<Parameter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FANOVAWarmstartComparator.class);
    private Map<String, Double> importanceValues;
    private IParameterImportanceEstimator importanceEstimator;

    public FANOVAWarmstartComparator(IParameterImportanceEstimator importanceEstimator, Component component) {
        this.importanceEstimator = importanceEstimator;
        this.importanceValues = this.importanceEstimator.computeImportanceForSingleComponent(component);
        LOGGER.debug("importance values: {}", this.importanceValues);
    }

    @Override
    public int compare(Parameter o1, Parameter o2) {
        if (this.importanceValues == null) {
            return 0;
        }
        LOGGER.debug("{} value: {}", (Object)o1, (Object)this.importanceValues.get(o1.toString()));
        if (this.importanceValues.get(o1.getName()) < this.importanceValues.get(o2.getName())) {
            return 1;
        }
        if (this.importanceValues.get(o1.getName()) > this.importanceValues.get(o2.getName())) {
            return -1;
        }
        return 0;
    }
}

