/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.knowledgebase;

import ai.libs.hasco.events.HASCOSolutionEvaluationEvent;
import ai.libs.jaicore.basic.SQLAdapter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.HashMap;

public class IntermediateResultHandler {
    public static final String TABLE_NAME = "performance_samples";
    private SQLAdapter adapter;
    private String benchmarkName;
    private String testEvalTechnique;
    private String testSplitTechnique;
    private String valEvalTechnique;
    private String valSplitTechnique;
    private int testSeed;
    private int valSeed;

    public IntermediateResultHandler(SQLAdapter adapter, String benchmarkName, String testEvalTechnique, String testSplitTechnique, int testSeed, String valEvalTechnique, String valSplitTechnique, int valSeed) {
        this.adapter = adapter;
        this.benchmarkName = benchmarkName;
        this.testEvalTechnique = testEvalTechnique;
        this.testSplitTechnique = testSplitTechnique;
        this.testSeed = testSeed;
        this.valEvalTechnique = valEvalTechnique;
        this.valSplitTechnique = valSplitTechnique;
        this.valSeed = valSeed;
    }

    @Subscribe
    public void receiveSolutionEvaluationEvent(HASCOSolutionEvaluationEvent<?, ?> solution) throws JsonProcessingException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        String composition = mapper.writeValueAsString((Object)solution.getComposition());
        map.put("composition", composition);
        map.put("test_evaluation_technique", this.testEvalTechnique);
        map.put("test_split_technique", this.testSplitTechnique);
        map.put("test_seed", Integer.toString(this.testSeed));
        map.put("val_evaluation_technique", this.valEvalTechnique);
        map.put("val_split_technique", this.valSplitTechnique);
        map.put("val_seed", Integer.toString(this.valSeed));
        map.put("error_rate", solution.getScore().toString());
        map.put("dataset", this.benchmarkName);
        if (this.adapter != null) {
            this.adapter.insert(TABLE_NAME, map);
        }
    }
}

