/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.knowledgebase;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.Dependency;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.serialization.ParameterDeserializer;
import ai.libs.hasco.serialization.ParameterDomainDeserializer;
import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.basic.StringUtil;
import ai.libs.jaicore.basic.kvstore.IKVStore;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ProtectedProperties;

public class PerformanceKnowledgeBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformanceKnowledgeBase.class);
    private static final String LABEL_PERFORMANCE_SAMPLES = "performance_samples";
    private SQLAdapter sqlAdapter;
    private Map<String, HashMap<ComponentInstance, Double>> performanceSamples;
    private Map<String, HashMap<String, List<Pair<ParameterConfiguration, Double>>>> performanceSamplesByIdentifier;
    private Map<String, HashMap<String, Instances>> performanceInstancesByIdentifier;
    private Map<String, HashMap<String, Instances>> performanceInstancesIndividualComponents;

    public PerformanceKnowledgeBase(SQLAdapter sqlAdapter) {
        this.sqlAdapter = sqlAdapter;
        this.performanceInstancesByIdentifier = new HashMap<String, HashMap<String, Instances>>();
        this.performanceInstancesIndividualComponents = new HashMap<String, HashMap<String, Instances>>();
    }

    public PerformanceKnowledgeBase() {
        this.performanceInstancesByIdentifier = new HashMap<String, HashMap<String, Instances>>();
        this.performanceInstancesIndividualComponents = new HashMap<String, HashMap<String, Instances>>();
    }

    private Attribute getAttribute(ComponentInstance ci, Parameter parameter) {
        IParameterDomain domain = parameter.getDefaultDomain();
        if (domain instanceof CategoricalParameterDomain) {
            CategoricalParameterDomain catDomain = (CategoricalParameterDomain)domain;
            return new Attribute(ci.getComponent().getName() + "::" + parameter.getName(), Arrays.asList(catDomain.getValues()));
        }
        if (domain instanceof NumericParameterDomain) {
            NumericParameterDomain numDomain = (NumericParameterDomain)domain;
            String range = "[" + numDomain.getMin() + "," + numDomain.getMax() + "]";
            Properties prop = new Properties();
            prop.setProperty("range", range);
            ProtectedProperties metaInfo = new ProtectedProperties(prop);
            return new Attribute(ci.getComponent().getName() + "::" + parameter.getName(), metaInfo);
        }
        return null;
    }

    public Instances getInstancesForCI(ComponentInstance ci) {
        Instances instances = null;
        List parameters = ci.getComponent().getParameters().getTotalOrder();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(parameters.size());
        for (Parameter parameter : parameters) {
            attributes.add(this.getAttribute(ci, parameter));
        }
        Attribute scoreAttr = new Attribute("performance_score");
        attributes.add(scoreAttr);
        instances = new Instances(LABEL_PERFORMANCE_SAMPLES, attributes, 16);
        instances.setClass(scoreAttr);
        return instances;
    }

    public Instances getInstancesForCIList(List<ComponentInstance> componentInstances) {
        Instances instances = null;
        ArrayList allAttributes = new ArrayList();
        for (ComponentInstance ci : componentInstances) {
            List parameters = ci.getComponent().getParameters().getTotalOrder();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(parameters.size());
            for (Parameter parameter : parameters) {
                attributes.add(this.getAttribute(ci, parameter));
            }
            allAttributes.addAll(attributes);
        }
        Attribute scoreAttr = new Attribute("performance_score");
        allAttributes.add(scoreAttr);
        instances = new Instances(LABEL_PERFORMANCE_SAMPLES, allAttributes, 16);
        instances.setClass(scoreAttr);
        return instances;
    }

    public void addPerformanceSample(String benchmarkName, ComponentInstance componentInstance, double score, boolean addToDB) {
        List<ComponentInstance> componentInstances;
        String identifier = Util.getComponentNamesOfComposition(componentInstance);
        if (this.performanceInstancesByIdentifier.get(benchmarkName) == null) {
            HashMap newMap = new HashMap();
            HashMap newMap2 = new HashMap();
            this.performanceInstancesByIdentifier.put(benchmarkName, newMap);
            this.performanceInstancesIndividualComponents.put(benchmarkName, newMap2);
        }
        if (!this.performanceInstancesByIdentifier.get(benchmarkName).containsKey(identifier)) {
            componentInstances = Util.getComponentInstancesOfComposition(componentInstance);
            this.performanceInstancesByIdentifier.get(benchmarkName).put(identifier, this.getInstancesForCIList(componentInstances));
        }
        componentInstances = Util.getComponentInstancesOfComposition(componentInstance);
        for (ComponentInstance ci : componentInstances) {
            if (this.performanceInstancesIndividualComponents.get(benchmarkName).containsKey(ci.getComponent().getName())) continue;
            this.performanceInstancesIndividualComponents.get(benchmarkName).put(ci.getComponent().getName(), this.getInstancesForCI(ci));
        }
        Instances instances = this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier);
        DenseInstance instance = new DenseInstance(instances.numAttributes());
        ParameterConfiguration config = new ParameterConfiguration(componentInstance);
        List<Pair<Parameter, String>> values = config.getValues();
        for (int i = 0; i < instances.numAttributes() - 1; ++i) {
            Attribute attr = instances.attribute(i);
            Parameter param = (Parameter)values.get(i).getLeft();
            if (values.get(i).getRight() == null) continue;
            if (param.isCategorical()) {
                String value = (String)values.get(i).getRight();
                boolean attrContainsValue = false;
                Enumeration possibleValues = attr.enumerateValues();
                while (possibleValues.hasMoreElements() && !attrContainsValue) {
                    Object o = possibleValues.nextElement();
                    if (!o.equals(value)) continue;
                    attrContainsValue = true;
                }
                if (attrContainsValue) {
                    instance.setValue(attr, value);
                    continue;
                }
                LOGGER.error("The value you're trying to insert is not in the attributes range!");
                continue;
            }
            if (!param.isNumeric()) continue;
            double finalValue = Double.parseDouble((String)values.get(i).getRight());
            instance.setValue(attr, finalValue);
        }
        Attribute scoreAttr = instances.classAttribute();
        instance.setValue(scoreAttr, score);
        this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier).add((Instance)instance);
        for (ComponentInstance ci : componentInstances) {
            this.performanceInstancesIndividualComponents.get(benchmarkName).get(ci.getComponent().getName()).add(this.getInstanceForIndividualCI(benchmarkName, ci, score));
        }
        if (addToDB) {
            this.addPerformanceSampleToDB(benchmarkName, componentInstance, score);
        }
    }

    public Instance getInstanceForIndividualCI(String benchmarkName, ComponentInstance ci, double score) {
        Instances instancesInd = this.performanceInstancesIndividualComponents.get(benchmarkName).get(ci.getComponent().getName());
        DenseInstance instanceInd = new DenseInstance(instancesInd.numAttributes());
        for (int i = 0; i < instancesInd.numAttributes() - 1; ++i) {
            Attribute attr = instancesInd.attribute(i);
            Parameter param = ci.getComponent().getParameterWithName(attr.name());
            String value = ci.getParametersThatHaveBeenSetExplicitly().contains(param) ? ci.getParameterValues().get(param.getName()) : param.getDefaultValue().toString();
            if (value == null) continue;
            if (param.isCategorical()) {
                boolean attrContainsValue = false;
                Enumeration possibleValues = attr.enumerateValues();
                while (possibleValues.hasMoreElements() && !attrContainsValue) {
                    Object o = possibleValues.nextElement();
                    if (!o.equals(value)) continue;
                    attrContainsValue = true;
                }
                if (!attrContainsValue) continue;
                instanceInd.setValue(attr, value);
                continue;
            }
            if (!param.isNumeric()) continue;
            double finalValue = Double.parseDouble(value);
            instanceInd.setValue(attr, finalValue);
        }
        Attribute scoreAttrInd = instancesInd.classAttribute();
        instanceInd.setValue(scoreAttrInd, score);
        return instanceInd;
    }

    public Map<String, HashMap<String, Instances>> getPerformanceInstancesIndividualComponents() {
        return this.performanceInstancesIndividualComponents;
    }

    public Map<String, HashMap<String, List<Pair<ParameterConfiguration, Double>>>> getPerformanceSamplesByIdentifier() {
        return this.performanceSamplesByIdentifier;
    }

    public String getStringOfMaps() {
        return this.performanceSamples.toString();
    }

    public void initializeDBTables() {
        try {
            List rs = this.sqlAdapter.getResultsOfQuery("SHOW TABLES");
            boolean havePerformanceTable = false;
            for (IKVStore store : rs) {
                String tableName = store.getAsString(StringUtil.firstElementWithPrefix((Collection)store.keySet(), (String)"Tables_in"));
                if (!tableName.equals("performance_samples_J48")) continue;
                havePerformanceTable = true;
            }
            if (!havePerformanceTable) {
                LOGGER.debug("Creating table for performance samples");
                this.sqlAdapter.update("CREATE TABLE `performance_samples_J48` (\r\n `sample_id` int(10) NOT NULL AUTO_INCREMENT,\r\n `dataset` varchar(200) COLLATE utf8_bin DEFAULT NULL,\r\n `composition` json NOT NULL,\r\n `error_rate` double NOT NULL,\r\n `test_evaluation_technique` varchar(20) ,\r\n `test_split_technique` varchar(20) ,\r\n `val_evaluation_technique` varchar(20) ,\r\n `val_split_technique` varchar(20) ,\r\n `test_seed` int(11) ,\r\n `val_seed` int(11) ,\r\n PRIMARY KEY (`sample_id`)\r\n) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin", new ArrayList());
            }
        }
        catch (SQLException e) {
            LOGGER.error("Could not create table for performance samples", (Throwable)e);
        }
    }

    public void addPerformanceSampleToDB(String benchmarkName, ComponentInstance componentInstance, double score) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("benchmark", benchmarkName);
            ObjectMapper mapper = new ObjectMapper();
            String composition = mapper.writeValueAsString((Object)componentInstance);
            map.put("composition", composition);
            map.put("score", "" + score);
            this.sqlAdapter.insert(LABEL_PERFORMANCE_SAMPLES, map);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while storing the performance sample in the database.", (Throwable)e);
        }
    }

    public int getNumSamples(String benchmarkName, String identifier) {
        if (!this.performanceInstancesByIdentifier.containsKey(benchmarkName)) {
            return 0;
        }
        if (!this.performanceInstancesByIdentifier.get(benchmarkName).containsKey(identifier)) {
            return 0;
        }
        return this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier).numInstances();
    }

    public int getNumSignificantSamples(String benchmarkName, String identifier) {
        if (!this.performanceInstancesByIdentifier.containsKey(benchmarkName)) {
            return 0;
        }
        if (!this.performanceInstancesByIdentifier.get(benchmarkName).containsKey(identifier)) {
            return 0;
        }
        Instances instances = this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier);
        int numDistinctValues = 1;
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < i; ++j) {
                boolean allValuesDistinct = true;
                for (int k = 0; k < instances.numAttributes(); ++k) {
                    if (instances.get(i).value(k) != instances.get(j).value(k)) continue;
                    allValuesDistinct = false;
                }
                if (!allValuesDistinct) continue;
                ++numDistinctValues;
            }
        }
        return numDistinctValues;
    }

    public void loadPerformanceSamplesFromDB() {
        if (this.sqlAdapter == null) {
            LOGGER.error("SQLAdapter is not set.");
            throw new IllegalArgumentException("No SQLAdapter set.");
        }
        try {
            List rslist = this.sqlAdapter.getResultsOfQuery("SELECT dataset, composition, error_rate FROM performance_samples_J48");
            ObjectMapper mapper = new ObjectMapper();
            for (IKVStore rs : rslist) {
                String benchmarkName = rs.getAsString("dataset");
                String ciString = rs.getAsString("composition");
                if (benchmarkName.equals("test")) continue;
                SimpleModule parameterModule = new SimpleModule();
                ParameterDeserializer des = new ParameterDeserializer();
                parameterModule.addDeserializer(Parameter.class, (JsonDeserializer)des);
                SimpleModule parameterDomainModule = new SimpleModule();
                ParameterDomainDeserializer parameterDomainDes = new ParameterDomainDeserializer();
                parameterDomainModule.addDeserializer(Dependency.class, (JsonDeserializer)parameterDomainDes);
                ComponentInstance composition = (ComponentInstance)mapper.readValue(ciString, ComponentInstance.class);
                double score = rs.getAsDouble("error_rate");
                this.addPerformanceSample(benchmarkName, composition, score, false);
            }
        }
        catch (SQLException e) {
            LOGGER.error("An error occurred while trying to access the database", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Could not parse json representation.", (Throwable)e);
        }
    }

    public boolean kDistinctAttributeValuesAvailable(String benchmarkName, ComponentInstance composition, int minNum) {
        if (!this.performanceInstancesByIdentifier.containsKey(benchmarkName)) {
            return false;
        }
        String identifier = Util.getComponentNamesOfComposition(composition);
        if (!this.performanceInstancesByIdentifier.get(benchmarkName).containsKey(identifier)) {
            return false;
        }
        Instances instances = this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier);
        if (instances.numInstances() < minNum) {
            return false;
        }
        for (int i = 0; i < instances.numAttributes() - 1; ++i) {
            if (!(instances.attribute(i).numValues() > 0 && instances.attribute(i).numValues() < minNum ? instances.numDistinctValues(i) < instances.attribute(i).numValues() : !(instances.attribute(i).getUpperNumericBound() <= instances.attribute(i).getLowerNumericBound()) && instances.numDistinctValues(i) < minNum)) continue;
            return false;
        }
        return true;
    }

    public boolean kCompletelyDistinctSamplesAvailable(String benchmarkName, ComponentInstance composition, int minNum) {
        if (!this.performanceInstancesByIdentifier.containsKey(benchmarkName)) {
            return false;
        }
        String identifier = Util.getComponentNamesOfComposition(composition);
        if (!this.performanceInstancesByIdentifier.get(benchmarkName).containsKey(identifier)) {
            return false;
        }
        Instances instances = this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier);
        if (instances.numInstances() == 0) {
            return false;
        }
        if (minNum == 1 && instances.numInstances() > 0) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            boolean distinctFromAll = true;
            for (int j = 0; j < i; ++j) {
                Instance instance1 = instances.get(i);
                Instance instance2 = instances.get(j);
                for (int k = 0; k < instances.numAttributes() - 1; ++k) {
                    if ((instances.attribute(k).isNominal() || instances.attribute(k).isString()) && instances.attribute(k).numValues() < minNum || instances.attribute(k).getUpperNumericBound() <= instances.attribute(k).getLowerNumericBound() || instance1.value(k) != instance2.value(k)) continue;
                    distinctFromAll = false;
                }
            }
            if (distinctFromAll) {
                ++count;
            }
            if (count < minNum) continue;
            return true;
        }
        return false;
    }

    public Instances getPerformanceSamples(String benchmarkName, ComponentInstance composition) {
        String identifier = Util.getComponentNamesOfComposition(composition);
        return this.performanceInstancesByIdentifier.get(benchmarkName).get(identifier);
    }

    public Instances createInstancesForPerformanceSamples(String benchmarkName, ComponentInstance composition) {
        return this.getPerformanceSamples(benchmarkName, composition);
    }

    public Instances getPerformanceSamplesForIndividualComponent(String benchmarkName, Component component) {
        if (this.performanceInstancesIndividualComponents.get(benchmarkName) != null && this.performanceInstancesIndividualComponents.get(benchmarkName).get(component.getName()) != null) {
            return this.performanceInstancesIndividualComponents.get(benchmarkName).get(component.getName());
        }
        return null;
    }

    public int getNumSamplesForComponent(String benchmarkName, Component component) {
        if (this.performanceInstancesIndividualComponents.get(benchmarkName) != null && this.performanceInstancesIndividualComponents.get(benchmarkName).get(component.getName()) != null) {
            return this.performanceInstancesIndividualComponents.get(benchmarkName).get(component.getName()).size();
        }
        return 0;
    }

    public void setPerformanceSamples(Instances instances, ComponentInstance composition, String benchmarkName) {
        String identifier = Util.getComponentNamesOfComposition(composition);
        if (!this.performanceInstancesByIdentifier.containsKey(benchmarkName)) {
            HashMap newMap = new HashMap();
            HashMap newMap2 = new HashMap();
            this.performanceInstancesByIdentifier.put(benchmarkName, newMap);
            this.performanceInstancesIndividualComponents.put(benchmarkName, newMap2);
        }
        this.performanceInstancesByIdentifier.get(benchmarkName).put(identifier, instances);
    }

    private class ParameterConfiguration {
        private final List<Pair<Parameter, String>> values;

        public ParameterConfiguration(ComponentInstance composition) {
            ArrayList<Pair> temp = new ArrayList<Pair>();
            List<ComponentInstance> componentInstances = Util.getComponentInstancesOfComposition(composition);
            for (ComponentInstance compInst : componentInstances) {
                List parameters = compInst.getComponent().getParameters().getTotalOrder();
                for (Parameter parameter : parameters) {
                    String value = compInst.getParametersThatHaveBeenSetExplicitly().contains(parameter) ? compInst.getParameterValues().get(parameter.getName()) : parameter.getDefaultValue().toString();
                    temp.add(Pair.of((Object)parameter, (Object)value));
                }
            }
            this.values = Collections.unmodifiableList(temp);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.values).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterConfiguration)) {
                return false;
            }
            ParameterConfiguration other = (ParameterConfiguration)obj;
            return new EqualsBuilder().append(this.values, other.values).isEquals();
        }

        public List<Pair<Parameter, String>> getValues() {
            return this.values;
        }
    }
}

