/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.knowledgebase;

import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.events.HASCOSolutionEvent;
import ai.libs.hasco.knowledgebase.PerformanceKnowledgeBase;
import ai.libs.hasco.model.ComponentInstance;
import com.google.common.eventbus.Subscribe;

public class PerformanceSampleListener {
    private PerformanceKnowledgeBase performanceKnowledgeBase;
    private String benchmarkName;

    public PerformanceSampleListener(PerformanceKnowledgeBase perfromanceKnowledgeBase, String benchmarkName) {
        this.performanceKnowledgeBase = perfromanceKnowledgeBase;
        this.benchmarkName = benchmarkName;
    }

    @Subscribe
    public void handleEvent(HASCOSolutionEvent<Double> event) {
        if (event.getSolutionCandidate() instanceof HASCOSolutionCandidate) {
            HASCOSolutionCandidate solutionCandidate = (HASCOSolutionCandidate)event.getSolutionCandidate();
            ComponentInstance ci = solutionCandidate.getComponentInstance();
            double score = (Double)solutionCandidate.getScore();
            this.performanceKnowledgeBase.addPerformanceSample(this.benchmarkName, ci, score, false);
        }
    }

    public PerformanceKnowledgeBase getPerformanceKnowledgeBase() {
        return this.performanceKnowledgeBase;
    }

    public void setPerformanceKnowledgeBase(PerformanceKnowledgeBase performanceKnowledgeBase) {
        this.performanceKnowledgeBase = performanceKnowledgeBase;
    }

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }
}

