/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.IParameterDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;

public class CategoricalParameterDomain
implements IParameterDomain {
    private final String[] values;

    private CategoricalParameterDomain() {
        this.values = null;
    }

    @JsonCreator
    public CategoricalParameterDomain(@JsonProperty(value="values") String[] values) {
        this.values = values;
    }

    @JsonCreator
    public CategoricalParameterDomain(@JsonProperty(value="values") Collection<String> values) {
        this(values.toArray(new String[0]));
    }

    public String[] getValues() {
        return this.values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoricalParameterDomain other = (CategoricalParameterDomain)obj;
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public boolean contains(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot request membership of NULL in a categorical parameter domain.");
        }
        String itemAsString = item.toString();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(itemAsString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean subsumes(IParameterDomain otherDomain) {
        if (!(otherDomain instanceof CategoricalParameterDomain)) {
            return false;
        }
        CategoricalParameterDomain otherCategoricalDomain = (CategoricalParameterDomain)otherDomain;
        return Arrays.asList(this.values).containsAll(Arrays.asList(otherCategoricalDomain.getValues()));
    }

    public String toString() {
        return "CategoricalParameterDomain [values=" + Arrays.toString(this.values) + "]";
    }
}

