/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.Dependency;
import ai.libs.hasco.model.Parameter;
import ai.libs.jaicore.basic.sets.PartialOrderedSet;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "parameters", "dependencies", "providedInterfaces", "requiredInterfaces"})
public class Component {
    private static final Logger L = LoggerFactory.getLogger(Component.class);
    private final String name;
    private Collection<String> providedInterfaces = new ArrayList<String>();
    private Map<String, String> requiredInterfaces = new LinkedHashMap<String, String>();
    private PartialOrderedSet<Parameter> parameters = new PartialOrderedSet();
    private Collection<Dependency> dependencies = new ArrayList<Dependency>();

    public Component(String name) {
        this.name = name;
        this.getProvidedInterfaces().add(this.name);
    }

    @JsonCreator
    public Component(@JsonProperty(value="name") String name, @JsonProperty(value="providedInterfaces") Collection<String> providedInterfaces, @JsonProperty(value="requiredInterfaces") Map<String, String> requiredInterfaces, @JsonProperty(value="parameters") PartialOrderedSet<Parameter> parameters, @JsonProperty(value="dependencies") Collection<Dependency> dependencies) {
        this(name);
        this.providedInterfaces = providedInterfaces;
        this.requiredInterfaces = new LinkedHashMap<String, String>(requiredInterfaces);
        this.parameters = parameters;
        this.dependencies = new ArrayList<Dependency>(dependencies);
    }

    public Component(String name, Collection<String> providedInterfaces, List<Map<String, String>> requiredInterfaces, PartialOrderedSet<Parameter> parameters, List<Dependency> dependencies) {
        this(name);
        this.providedInterfaces = providedInterfaces;
        this.requiredInterfaces = new LinkedHashMap<String, String>();
        requiredInterfaces.stream().forEach(this.requiredInterfaces::putAll);
        this.parameters = parameters;
        this.dependencies = dependencies;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getRequiredInterfaces() {
        return this.requiredInterfaces;
    }

    public Collection<String> getProvidedInterfaces() {
        return this.providedInterfaces;
    }

    public PartialOrderedSet<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameterWithName(String paramName) {
        Optional<Parameter> param = this.parameters.stream().filter(p -> p.getName().equals(paramName)).findFirst();
        if (!param.isPresent()) {
            throw new IllegalArgumentException("Component " + this.name + " has no parameter with name \"" + paramName + "\"");
        }
        return param.get();
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public boolean addProvidedInterface(String interfaceName) {
        if (!this.providedInterfaces.contains(interfaceName)) {
            return this.providedInterfaces.add(interfaceName);
        }
        return false;
    }

    public void addRequiredInterface(String interfaceID, String interfaceName) {
        this.requiredInterfaces.put(interfaceID, interfaceName);
    }

    public void addParameter(Parameter param) {
        if (this.parameters.stream().anyMatch(p -> p.getName().equals(param.getName()))) {
            throw new IllegalArgumentException("Component " + this.name + " already has a parameter with name " + param.getName());
        }
        this.parameters.add((Object)param);
    }

    public void addDependency(Dependency dependency) {
        HashSet paramsInPremise = new HashSet();
        dependency.getPremise().forEach(c -> c.forEach(i -> paramsInPremise.add(i.getX())));
        HashSet paramsInConclusion = new HashSet();
        dependency.getConclusion().forEach(i -> paramsInConclusion.add(i.getX()));
        for (Parameter before : paramsInPremise) {
            for (Parameter after : paramsInConclusion) {
                this.parameters.requireABeforeB((Object)before, (Object)after);
            }
        }
        this.dependencies.add(dependency);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.providedInterfaces == null ? 0 : this.providedInterfaces.hashCode());
        result = 31 * result + (this.requiredInterfaces == null ? 0 : this.requiredInterfaces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.providedInterfaces == null ? other.providedInterfaces != null : !this.providedInterfaces.equals(other.providedInterfaces)) {
            return false;
        }
        return !(this.requiredInterfaces == null ? other.requiredInterfaces != null : !this.requiredInterfaces.equals(other.requiredInterfaces));
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            L.warn("Could not directly serialize Component to JSON: ", (Throwable)e);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", this.name);
            fields.put("providedInterfaces", this.providedInterfaces);
            fields.put("requiredInterfaces", this.requiredInterfaces);
            fields.put("parameters", this.parameters);
            return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
        }
    }
}

