/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.Parameter;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(alphabetic=true)
public class ComponentInstance {
    private static final Logger L = LoggerFactory.getLogger(ComponentInstance.class);
    private final Component component;
    private final Map<String, String> parameterValues;
    private final Map<String, ComponentInstance> satisfactionOfRequiredInterfaces;

    private ComponentInstance() {
        this.component = null;
        this.parameterValues = null;
        this.satisfactionOfRequiredInterfaces = null;
    }

    public ComponentInstance(@JsonProperty(value="component") Component component, @JsonProperty(value="parameterValues") Map<String, String> parameterValues, @JsonProperty(value="satisfactionOfRequiredInterfaces") Map<String, ComponentInstance> satisfactionOfRequiredInterfaces) {
        this.component = component;
        this.parameterValues = parameterValues;
        this.satisfactionOfRequiredInterfaces = satisfactionOfRequiredInterfaces;
    }

    public Component getComponent() {
        return this.component;
    }

    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public Collection<Parameter> getParametersThatHaveBeenSetExplicitly() {
        if (this.parameterValues == null) {
            return new ArrayList<Parameter>();
        }
        return this.getComponent().getParameters().stream().filter(p -> this.parameterValues.containsKey(p.getName())).collect(Collectors.toList());
    }

    public Collection<Parameter> getParametersThatHaveNotBeenSetExplicitly() {
        return SetUtil.difference(this.component.getParameters(), this.getParametersThatHaveBeenSetExplicitly());
    }

    public String getParameterValue(Parameter param) {
        return this.getParameterValue(param.getName());
    }

    public String getParameterValue(String paramName) {
        return this.parameterValues.get(paramName);
    }

    public Map<String, ComponentInstance> getSatisfactionOfRequiredInterfaces() {
        return this.satisfactionOfRequiredInterfaces;
    }

    public Collection<Component> getContainedComponents() {
        HashSet<Component> components = new HashSet<Component>();
        components.add(this.getComponent());
        for (ComponentInstance ci : this.satisfactionOfRequiredInterfaces.values()) {
            components.addAll(ci.getContainedComponents());
        }
        return components;
    }

    public boolean matchesPathRestrictions(Collection<List<Pair<String, String>>> paths) {
        for (List<Pair<String, String>> path : paths) {
            if (this.matchesPathRestriction(path)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPathRestriction(List<Pair<String, String>> path) {
        if (path.isEmpty()) {
            return true;
        }
        int i = 0;
        if (path.get(0).getX() == null) {
            String requiredComponent = (String)path.get(0).getY();
            if (!requiredComponent.equals("*") && !this.component.getName().equals(requiredComponent)) {
                return false;
            }
            i = 1;
        }
        ComponentInstance current = this;
        int n = path.size();
        while (i < n) {
            Pair<String, String> selection = path.get(i);
            if (!current.getComponent().getRequiredInterfaces().containsKey(selection.getX())) {
                throw new IllegalArgumentException("Invalid path restriction " + path + ": " + (String)selection.getX() + " is not a required interface of " + current.getComponent().getName());
            }
            ComponentInstance instanceChosenForRequiredInterface = current.getSatisfactionOfRequiredInterfaces().get(selection.getX());
            if (!((String)selection.getY()).equals("*") && !instanceChosenForRequiredInterface.getComponent().getName().equals(selection.getY())) {
                return false;
            }
            current = instanceChosenForRequiredInterface;
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.satisfactionOfRequiredInterfaces == null ? 0 : this.satisfactionOfRequiredInterfaces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInstance other = (ComponentInstance)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        return !(this.satisfactionOfRequiredInterfaces == null ? other.satisfactionOfRequiredInterfaces != null : !this.satisfactionOfRequiredInterfaces.equals(other.satisfactionOfRequiredInterfaces));
    }

    public String toComponentNameString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getComponent().getName());
        if (!this.satisfactionOfRequiredInterfaces.isEmpty()) {
            sb.append(this.satisfactionOfRequiredInterfaces.entrySet().stream().map(x -> ((ComponentInstance)x.getValue()).toComponentNameString()).collect(Collectors.toList()).toString());
        }
        return sb.toString();
    }

    @JsonIgnore
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            L.warn("Could not directly serialize ComponentInstance to JSON:", (Throwable)e);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("component", this.component);
            fields.put("parameterValues", this.parameterValues);
            fields.put("satisfactionOfRequiredInterfaces", this.satisfactionOfRequiredInterfaces);
            return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
        }
    }

    @JsonIgnore
    public String getPrettyPrint() throws IOException {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)this);
    }

    public String getNestedComponentDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getComponent().getName());
        this.satisfactionOfRequiredInterfaces.values().stream().map(x -> " - " + x.getNestedComponentDescription()).forEach(sb::append);
        return sb.toString();
    }
}

