/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.core.Util;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.Dependency;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import java.util.Arrays;
import java.util.HashMap;

public class ComponentInstanceUtil {
    private ComponentInstanceUtil() {
    }

    public static boolean isValidComponentInstantiation(ComponentInstance ci) {
        HashMap<Parameter, IParameterDomain> refinedDomainMap = new HashMap<Parameter, IParameterDomain>();
        for (Parameter param : ci.getComponent().getParameters()) {
            if (param.getDefaultDomain() instanceof NumericParameterDomain) {
                double parameterValue = Double.parseDouble(ci.getParameterValue(param));
                refinedDomainMap.put(param, new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), parameterValue, parameterValue));
                continue;
            }
            if (!(param.getDefaultDomain() instanceof CategoricalParameterDomain)) continue;
            refinedDomainMap.put(param, new CategoricalParameterDomain(Arrays.asList(ci.getParameterValue(param))));
        }
        for (Dependency dependency : ci.getComponent().getDependencies()) {
            if (!Util.isDependencyPremiseSatisfied(dependency, refinedDomainMap) || Util.isDependencyConditionSatisfied(dependency.getConclusion(), refinedDomainMap)) continue;
            return false;
        }
        return true;
    }
}

