/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.IParameterDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class NumericParameterDomain
implements IParameterDomain {
    private final boolean isInteger;
    private final double min;
    private final double max;

    private NumericParameterDomain() {
        this.isInteger = true;
        this.min = 0.0;
        this.max = 0.0;
    }

    @JsonCreator
    public NumericParameterDomain(@JsonProperty(value="integer") boolean isInteger, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max) {
        this.isInteger = isInteger;
        this.min = min;
        this.max = max;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String toString() {
        return "NumericParameterDomain [isInteger=" + this.isInteger + ", min=" + this.min + ", max=" + this.max + "]";
    }

    @Override
    public boolean contains(Object item) {
        if (!(item instanceof Number)) {
            return false;
        }
        Double n = (Double)item;
        return n >= this.min && n <= this.max;
    }

    @Override
    public boolean subsumes(IParameterDomain otherDomain) {
        if (!(otherDomain instanceof NumericParameterDomain)) {
            return false;
        }
        NumericParameterDomain otherNumericDomain = (NumericParameterDomain)otherDomain;
        if (this.isInteger && !otherNumericDomain.isInteger) {
            return false;
        }
        return this.min <= otherNumericDomain.getMin() && this.max >= otherNumericDomain.getMax();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isInteger ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericParameterDomain other = (NumericParameterDomain)obj;
        if (this.isInteger != other.isInteger) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
    }
}

