/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder(value={"name", "defaultDomain", "defaultValue"})
public class Parameter {
    private final String name;
    private final IParameterDomain defaultDomain;
    private final Object defaultValue;

    private Parameter() {
        this.name = null;
        this.defaultDomain = null;
        this.defaultValue = null;
    }

    @JsonCreator
    public Parameter(@JsonProperty(value="name") String name, @JsonProperty(value="defaultDomain") IParameterDomain defaultDomain, @JsonProperty(value="defaultValue") Object defaultValue) {
        this.name = name;
        this.defaultDomain = defaultDomain;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public IParameterDomain getDefaultDomain() {
        return this.defaultDomain;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNumeric() {
        return this.defaultDomain instanceof NumericParameterDomain;
    }

    public boolean isCategorical() {
        return this.defaultDomain instanceof CategoricalParameterDomain;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultDomain == null ? 0 : this.defaultDomain.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.defaultDomain == null ? other.defaultDomain != null : !this.defaultDomain.equals(other.defaultDomain)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

