/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.model;

import ai.libs.hasco.model.ComponentInstance;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnparametrizedComponentInstance {
    private final String componentName;
    private final Map<String, UnparametrizedComponentInstance> satisfactionOfRequiredInterfaces;

    public UnparametrizedComponentInstance(String componentName, Map<String, UnparametrizedComponentInstance> satisfactionOfRequiredInterfaces) {
        this.componentName = componentName;
        this.satisfactionOfRequiredInterfaces = satisfactionOfRequiredInterfaces;
    }

    public UnparametrizedComponentInstance(ComponentInstance composition) {
        Map<String, ComponentInstance> resolvedRequiredInterfaces = composition.getSatisfactionOfRequiredInterfaces();
        this.satisfactionOfRequiredInterfaces = new HashMap<String, UnparametrizedComponentInstance>();
        resolvedRequiredInterfaces.keySet().forEach(r -> this.satisfactionOfRequiredInterfaces.put((String)r, new UnparametrizedComponentInstance((ComponentInstance)resolvedRequiredInterfaces.get(r))));
        this.componentName = composition.getComponent().getName();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Map<String, UnparametrizedComponentInstance> getSatisfactionOfRequiredInterfaces() {
        return this.satisfactionOfRequiredInterfaces;
    }

    public UnparametrizedComponentInstance getSubComposition(List<String> path) {
        UnparametrizedComponentInstance current = this;
        for (String requiredInterface : path) {
            if (!current.getSatisfactionOfRequiredInterfaces().containsKey(requiredInterface)) {
                throw new IllegalArgumentException("Invalid path " + path + " (size " + path.size() + "). The component " + current.getComponentName() + " does not have a required interface with id \"" + requiredInterface + "\"");
            }
            current = current.getSatisfactionOfRequiredInterfaces().get(requiredInterface);
        }
        return current;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
        result = 31 * result + (this.satisfactionOfRequiredInterfaces == null ? 0 : this.satisfactionOfRequiredInterfaces.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnparametrizedComponentInstance other = (UnparametrizedComponentInstance)obj;
        if (this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName)) {
            return false;
        }
        return !(this.satisfactionOfRequiredInterfaces == null ? other.satisfactionOfRequiredInterfaces != null : !this.satisfactionOfRequiredInterfaces.equals(other.satisfactionOfRequiredInterfaces));
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("componentName", this.componentName);
        fields.put("satisfactionOfRequiredInterfaces", this.satisfactionOfRequiredInterfaces);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

