/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.optimizingfactory;

import ai.libs.hasco.core.SoftwareConfigurationProblem;
import ai.libs.hasco.exceptions.ComponentInstantiationFailedException;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.EvaluatedSoftwareConfigurationSolution;
import ai.libs.hasco.optimizingfactory.OptimizingFactoryProblem;
import ai.libs.hasco.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.hasco.optimizingfactory.SoftwareConfigurationAlgorithmFactory;
import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizingFactory<P extends SoftwareConfigurationProblem<V>, T, C extends EvaluatedSoftwareConfigurationSolution<V>, V extends Comparable<V>>
extends AAlgorithm<OptimizingFactoryProblem<P, T, V>, T> {
    private Logger logger = LoggerFactory.getLogger(OptimizingFactory.class);
    private String loggerName;
    private final SoftwareConfigurationAlgorithmFactory<P, C, V> factoryForOptimizationAlgorithm;
    private T constructedObject;
    private V performanceOfObject;
    private ComponentInstance componentInstanceOfObject;
    private final SoftwareConfigurationAlgorithm<P, C, V> optimizer;

    public OptimizingFactory(OptimizingFactoryProblem<P, T, V> problem, SoftwareConfigurationAlgorithmFactory<P, C, V> factoryForOptimizationAlgorithm) {
        super(problem);
        this.factoryForOptimizationAlgorithm = factoryForOptimizationAlgorithm;
        this.optimizer = this.factoryForOptimizationAlgorithm.getAlgorithm(((OptimizingFactoryProblem)this.getInput()).getConfigurationProblem());
        this.optimizer.registerListener(new Object(){

            @Subscribe
            public void receiveAlgorithmEvent(AlgorithmEvent event) {
                if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                    OptimizingFactory.this.post(event);
                }
            }
        });
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case CREATED: {
                if (this.loggerName != null) {
                    this.logger.info("Setting logger of optimizer {} to {}.optAlgo", (Object)((Object)this.optimizer).getClass().getName(), (Object)this.loggerName);
                    this.optimizer.setLoggerName(this.loggerName + ".optAlgo");
                }
                AlgorithmEvent initEvent = this.optimizer.next();
                assert (initEvent instanceof AlgorithmInitializedEvent) : "The first event emitted by the optimizer has not been its AlgorithmInitializationEvent";
                return this.activate();
            }
            case ACTIVE: {
                EvaluatedSoftwareConfigurationSolution solutionModel = (EvaluatedSoftwareConfigurationSolution)this.optimizer.call();
                try {
                    this.constructedObject = ((OptimizingFactoryProblem)this.getInput()).getBaseFactory().getComponentInstantiation(solutionModel.getComponentInstance());
                    this.performanceOfObject = solutionModel.getScore();
                    this.componentInstanceOfObject = solutionModel.getComponentInstance();
                    return this.terminate();
                }
                catch (ComponentInstantiationFailedException e) {
                    throw new AlgorithmException((Throwable)e, "Could not conduct next step in OptimizingFactory due to an exception in the component instantiation.");
                }
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    public T call() throws AlgorithmException, InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.constructedObject;
    }

    public SoftwareConfigurationAlgorithm<P, C, V> getOptimizer() {
        return this.optimizer;
    }

    public AlgorithmInitializedEvent init() {
        AlgorithmEvent e = null;
        while (this.hasNext()) {
            e = this.next();
            if (!(e instanceof AlgorithmInitializedEvent)) continue;
            return (AlgorithmInitializedEvent)e;
        }
        throw new IllegalStateException("Could not complete initialization");
    }

    public V getPerformanceOfObject() {
        return this.performanceOfObject;
    }

    public ComponentInstance getComponentInstanceOfObject() {
        return this.componentInstanceOfObject;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("factoryForOptimizationAlgorithm", this.factoryForOptimizationAlgorithm);
        fields.put("constructedObject", this.constructedObject);
        fields.put("performanceOfObject", this.performanceOfObject);
        fields.put("optimizer", this.optimizer);
        return ToJSONStringUtil.toJSONString(fields);
    }

    public void cancel() {
        this.logger.info("Received cancel. First canceling the optimizer {}, then my own routine!", (Object)this.optimizer.getId());
        this.optimizer.cancel();
        this.logger.debug("Now canceling the OptimizingFactory itself.");
        super.cancel();
        assert (this.isCanceled()) : "Cancel-flag must be true at end of cancel routine!";
    }
}

