/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.reduction;

import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.core.IHASCOPlanningReduction;
import ai.libs.hasco.core.IsRefinementCompletedPredicate;
import ai.libs.hasco.core.IsValidParameterRangeRefinementPredicate;
import ai.libs.hasco.core.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.hasco.core.Util;
import ai.libs.hasco.core.isNotRefinable;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.jaicore.basic.IInformedObjectEvaluatorExtension;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.logic.fol.structure.CNFFormula;
import ai.libs.jaicore.logic.fol.structure.ConstantParam;
import ai.libs.jaicore.logic.fol.structure.Literal;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.logic.fol.structure.VariableParam;
import ai.libs.jaicore.planning.classical.problems.ceoc.CEOCOperation;
import ai.libs.jaicore.planning.core.interfaces.IEvaluatedPlan;
import ai.libs.jaicore.planning.core.interfaces.IPlan;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningDomain;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.CEOCIPSTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.ceocipstn.OCIPMethod;
import ai.libs.jaicore.planning.hierarchical.problems.htn.CostSensitiveHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.htn.IHTNPlanningProblem;
import ai.libs.jaicore.planning.hierarchical.problems.stn.TaskNetwork;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.probleminputs.GraphSearchInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HASCOReduction<V extends Comparable<V>>
implements AlgorithmicProblemReduction<RefinementConfiguredSoftwareConfigurationProblem<V>, ComponentInstance, CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V>, IEvaluatedPlan<V>> {
    private static final boolean CONFIGURE_PARAMS = true;
    private static final String RESOLVE_COMPONENT_IFACE_PREFIX = "1_tResolve";
    private static final String SATISFY_PREFIX = "1_satisfy";
    private static final String REFINE_PARAMETERS_PREFIX = "2_tRefineParamsOf";
    private static final String REFINE_PARAMETER_PREFIX = "2_tRefineParam";
    private static final String DECLARE_CLOSED_PREFIX = "2_declareClosed";
    private static final String REDEF_VALUE_PREFIX = "2_redefValue";
    private static final String COMPONENT_OF_C1 = "component(c1)";
    private RefinementConfiguredSoftwareConfigurationProblem<V> originalProblem;
    private Collection<Component> components;
    private Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramRefinementConfig;
    private Supplier<HASCOSolutionCandidate<V>> bestSolutionSupplier;

    public HASCOReduction(Supplier<HASCOSolutionCandidate<V>> bestSolutionSupplier) {
        this.bestSolutionSupplier = bestSolutionSupplier;
    }

    public Monom getInitState() {
        if (this.originalProblem == null) {
            throw new IllegalStateException("Cannot compute init state before transformation has been invoked.");
        }
        Monom init = new Monom();
        this.getExistingInterfaces().forEach(s -> init.add((Object)new Literal("iface('" + s + "')")));
        init.add((Object)new Literal("component('request')"));
        return init;
    }

    public Collection<String> getExistingInterfaces() {
        if (this.originalProblem == null) {
            throw new IllegalStateException("Cannot compute existing interfaces before transformation has been invoked.");
        }
        HashSet<String> ifaces = new HashSet<String>();
        for (Component c : this.components) {
            ifaces.addAll(c.getProvidedInterfaces());
            ifaces.addAll(c.getRequiredInterfaces().values());
        }
        return ifaces;
    }

    public CEOCIPSTNPlanningDomain getPlanningDomain() {
        ArrayList<CEOCOperation> operations = new ArrayList<CEOCOperation>();
        for (Component c : this.components) {
            for (String i : c.getProvidedInterfaces()) {
                Object p2;
                ArrayList<VariableParam> params = new ArrayList<VariableParam>();
                params.add(new VariableParam("c1"));
                params.add(new VariableParam("c2"));
                int j = 0;
                HashMap<CNFFormula, Monom> addList = new HashMap<CNFFormula, Monom>();
                Monom standardKnowledgeAboutNewComponent = new Monom("component(c2) & resolves(c1, '" + i + "', '" + c.getName() + "', c2)");
                for (Object p2 : c.getParameters()) {
                    String paramIdentifier = "p" + ++j;
                    params.add(new VariableParam(paramIdentifier));
                    ArrayList<Object> literalParams = new ArrayList<Object>();
                    literalParams.clear();
                    literalParams.add(new ConstantParam(c.getName()));
                    literalParams.add(new ConstantParam(((Parameter)p2).getName()));
                    literalParams.add(new VariableParam("c2"));
                    literalParams.add(new VariableParam(paramIdentifier));
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("parameterContainer", literalParams));
                    ArrayList<Object> valParams = new ArrayList<Object>();
                    valParams.add(new VariableParam(paramIdentifier));
                    if (((Parameter)p2).isNumeric()) {
                        standardKnowledgeAboutNewComponent.add((Object)new Literal("parameterFocus(c2, '" + ((Parameter)p2).getName() + "', '" + this.paramRefinementConfig.get(c).get(p2).getFocusPoint() + "')"));
                        NumericParameterDomain np = (NumericParameterDomain)((Parameter)p2).getDefaultDomain();
                        valParams.add(new ConstantParam("[" + np.getMin() + "," + np.getMax() + "]"));
                    } else {
                        valParams.add(new ConstantParam(((Parameter)p2).getDefaultValue().toString()));
                    }
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("val", valParams));
                }
                int k = 0;
                p2 = c.getRequiredInterfaces().keySet().iterator();
                while (p2.hasNext()) {
                    String requiredInterfaceID = (String)p2.next();
                    String reqIntIdentifier = "sc" + ++k;
                    params.add(new VariableParam(reqIntIdentifier));
                    ArrayList<Object> literalParams = new ArrayList<Object>();
                    literalParams.clear();
                    literalParams.add(new ConstantParam(c.getName()));
                    literalParams.add(new ConstantParam(requiredInterfaceID));
                    literalParams.add(new VariableParam("c2"));
                    literalParams.add(new VariableParam(reqIntIdentifier));
                    standardKnowledgeAboutNewComponent.add((Object)new Literal("interfaceIdentifier", literalParams));
                }
                addList.put(new CNFFormula(), standardKnowledgeAboutNewComponent);
                CEOCOperation newOp = new CEOCOperation(SATISFY_PREFIX + i + "With" + c.getName(), params, new Monom(COMPONENT_OF_C1), addList, new HashMap(), new ArrayList());
                operations.add(newOp);
            }
        }
        HashMap<CNFFormula, Monom> addList = new HashMap<CNFFormula, Monom>();
        addList.put(new CNFFormula(), new Monom("val(container,newValue) & overwritten(container)"));
        HashMap<CNFFormula, Monom> deleteList = new HashMap<CNFFormula, Monom>();
        deleteList.put(new CNFFormula(), new Monom("val(container,previousValue)"));
        operations.add(new CEOCOperation(REDEF_VALUE_PREFIX, "container,previousValue,newValue", new Monom("val(container,previousValue)"), addList, deleteList, ""));
        addList = new HashMap();
        addList.put(new CNFFormula(), new Monom("closed(container)"));
        deleteList = new HashMap();
        operations.add(new CEOCOperation(DECLARE_CLOSED_PREFIX, "container", new Monom(), addList, deleteList, ""));
        ArrayList<OCIPMethod> methods = new ArrayList<OCIPMethod>();
        for (Component c : this.components) {
            for (String i : c.getProvidedInterfaces()) {
                ArrayList<VariableParam> params = new ArrayList<VariableParam>();
                VariableParam inputParam = new VariableParam("c1");
                params.add(inputParam);
                params.add(new VariableParam("c2"));
                Map<String, String> requiredInterfaces = c.getRequiredInterfaces();
                ArrayList<Literal> network = new ArrayList<Literal>();
                StringBuilder refinementArgumentsSB = new StringBuilder();
                int j = 0;
                for (j = 1; j <= c.getParameters().size(); ++j) {
                    String paramIdentifier = "p" + j;
                    refinementArgumentsSB.append(", " + paramIdentifier);
                }
                for (int k = 1; k <= requiredInterfaces.entrySet().size(); ++k) {
                    refinementArgumentsSB.append(",sc" + k);
                }
                int sc = 0;
                network.add(new Literal(SATISFY_PREFIX + i + "With" + c.getName() + "(c1,c2" + refinementArgumentsSB.toString() + ")"));
                for (Map.Entry<String, String> requiredInterface : requiredInterfaces.entrySet()) {
                    String paramName = "sc" + ++sc;
                    params.add(new VariableParam(paramName));
                    network.add(new Literal(RESOLVE_COMPONENT_IFACE_PREFIX + requiredInterface.getValue() + "(c2," + paramName + ")"));
                }
                refinementArgumentsSB = new StringBuilder();
                for (j = 1; j <= c.getParameters().size(); ++j) {
                    String paramIdentifier = "p" + j;
                    params.add(new VariableParam(paramIdentifier));
                    refinementArgumentsSB.append(", " + paramIdentifier);
                }
                network.add(new Literal(REFINE_PARAMETERS_PREFIX + c.getName() + "(c1,c2" + refinementArgumentsSB.toString() + ")"));
                ArrayList outputs = new ArrayList(params);
                outputs.remove(inputParam);
                methods.add(new OCIPMethod("resolve" + i + "With" + c.getName(), params, new Literal(RESOLVE_COMPONENT_IFACE_PREFIX + i + "(c1,c2)"), new Monom(COMPONENT_OF_C1), new TaskNetwork(network), false, outputs, new Monom()));
            }
            ArrayList<VariableParam> params = new ArrayList<VariableParam>();
            params.add(new VariableParam("c1"));
            ArrayList<Literal> initNetwork = new ArrayList<Literal>();
            StringBuilder refinementArgumentsSB = new StringBuilder();
            int j = 0;
            for (Parameter p : c.getParameters()) {
                String paramName = "p" + ++j;
                refinementArgumentsSB.append(", " + paramName);
                params.add(new VariableParam(paramName));
                initNetwork.add(new Literal(REFINE_PARAMETER_PREFIX + p.getName() + "Of" + c.getName() + "(c2, " + paramName + ")"));
                methods.add(new OCIPMethod("ignoreParamRefinementFor" + p.getName() + "Of" + c.getName(), "object, container, curval", new Literal(REFINE_PARAMETER_PREFIX + p.getName() + "Of" + c.getName() + "(object,container)"), new Monom("parameterContainer('" + c.getName() + "', '" + p.getName() + "', object, container) & val(container,curval) & overwritten(container)"), new TaskNetwork("2_declareClosed(container)"), false, "", new Monom("notRefinable('" + c.getName() + "', object, '" + p.getName() + "', container, curval)")));
                methods.add(new OCIPMethod("refineParam" + p.getName() + "Of" + c.getName(), "object, container, curval, newval", new Literal(REFINE_PARAMETER_PREFIX + p.getName() + "Of" + c.getName() + "(object,container)"), new Monom("parameterContainer('" + c.getName() + "', '" + p.getName() + "', object, container) & val(container,curval)"), new TaskNetwork("2_redefValue(container,curval,newval)"), false, "", new Monom("isValidParameterRangeRefinement('" + c.getName() + "', object, '" + p.getName() + "', container, curval, newval)")));
            }
            initNetwork.add(new Literal(REFINE_PARAMETERS_PREFIX + c.getName() + "(c1,c2" + refinementArgumentsSB.toString() + ")"));
            params = new ArrayList(params);
            params.add(1, new VariableParam("c2"));
            methods.add(new OCIPMethod("refineParamsOf" + c.getName(), params, new Literal(REFINE_PARAMETERS_PREFIX + c.getName() + "(c1,c2" + refinementArgumentsSB.toString() + ")"), new Monom(COMPONENT_OF_C1), new TaskNetwork(initNetwork), false, new ArrayList(), new Monom("!refinementCompleted('" + c.getName() + "', c2)")));
            methods.add(new OCIPMethod("closeRefinementOfParamsOf" + c.getName(), params, new Literal(REFINE_PARAMETERS_PREFIX + c.getName() + "(c1,c2" + refinementArgumentsSB.toString() + ")"), new Monom(COMPONENT_OF_C1), new TaskNetwork(), false, new ArrayList(), new Monom("refinementCompleted('" + c.getName() + "', c2)")));
        }
        return new CEOCIPSTNPlanningDomain(operations, methods);
    }

    public CEOCIPSTNPlanningProblem getPlanningProblem(CEOCIPSTNPlanningDomain domain, CNFFormula knowledge, Monom init) {
        HashMap<String, Object> evaluablePredicates = new HashMap<String, Object>();
        evaluablePredicates.put("isValidParameterRangeRefinement", new IsValidParameterRangeRefinementPredicate(this.components, this.paramRefinementConfig));
        evaluablePredicates.put("notRefinable", new isNotRefinable(this.components, this.paramRefinementConfig));
        evaluablePredicates.put("refinementCompleted", new IsRefinementCompletedPredicate(this.components, this.paramRefinementConfig));
        return new CEOCIPSTNPlanningProblem(domain, knowledge, init, new TaskNetwork(RESOLVE_COMPONENT_IFACE_PREFIX + this.originalProblem.getRequiredInterface() + "('request', 'solution')"), evaluablePredicates, new HashMap());
    }

    public CEOCIPSTNPlanningProblem getPlanningProblem() {
        return this.getPlanningProblem(this.getPlanningDomain(), new CNFFormula(), this.getInitState());
    }

    public <T, A> GraphGenerator<T, A> getGraphGeneratorUsedByHASCOForSpecificPlanner(IHASCOPlanningReduction<T, A> transformer) {
        return ((GraphSearchInput)transformer.encodeProblem(this.getPlanningProblem())).getGraphGenerator();
    }

    public CostSensitiveHTNPlanningProblem<CEOCIPSTNPlanningProblem, V> encodeProblem(final RefinementConfiguredSoftwareConfigurationProblem<V> problem) {
        this.originalProblem = problem;
        this.components = this.originalProblem.getComponents();
        this.paramRefinementConfig = this.originalProblem.getParamRefinementConfig();
        CEOCIPSTNPlanningProblem planningProblem = this.getPlanningProblem();
        IObjectEvaluator planEvaluator = new IObjectEvaluator<IPlan, V>(){

            public V evaluate(IPlan plan) throws InterruptedException, ObjectEvaluationFailedException {
                ComponentInstance solution = HASCOReduction.this.decodeSolution(plan);
                if (solution == null) {
                    throw new IllegalArgumentException("The following plan yields a null solution: \n\t" + plan.getActions().stream().map(a -> a.getEncoding()).collect(Collectors.joining("\n\t")));
                }
                IObjectEvaluator evaluator = problem.getCompositionEvaluator();
                if (evaluator instanceof IInformedObjectEvaluatorExtension && HASCOReduction.this.bestSolutionSupplier.get() != null) {
                    ((IInformedObjectEvaluatorExtension)evaluator).updateBestScore(((HASCOSolutionCandidate)HASCOReduction.this.bestSolutionSupplier.get()).getScore());
                }
                return evaluator.evaluate((Object)solution);
            }

            public String toString() {
                HashMap<String, RefinementConfiguredSoftwareConfigurationProblem> fields = new HashMap<String, RefinementConfiguredSoftwareConfigurationProblem>();
                fields.put("problem", problem);
                return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
            }
        };
        return new CostSensitiveHTNPlanningProblem((IHTNPlanningProblem)planningProblem, planEvaluator);
    }

    public ComponentInstance decodeSolution(IEvaluatedPlan<V> solution) {
        return this.decodeSolution((IPlan)solution);
    }

    public ComponentInstance decodeSolution(IPlan plan) {
        return Util.getSolutionCompositionForPlan(this.components, this.getInitState(), plan, true);
    }
}

