/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.serialization;

import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.ComponentInstance;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ComponentInstanceDeserializer
extends StdDeserializer<ComponentInstance> {
    private static final long serialVersionUID = 4216559441244072999L;
    private transient Collection<Component> possibleComponents;

    public ComponentInstanceDeserializer(Collection<Component> possibleComponents) {
        super(ComponentInstance.class);
        this.possibleComponents = possibleComponents;
    }

    public ComponentInstance readFromJson(String json) throws IOException {
        return this.readAsTree((TreeNode)new ObjectMapper().readTree(json));
    }

    public ComponentInstance readAsTree(TreeNode p) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map parameterValues = (Map)mapper.treeToValue(p.get("params"), HashMap.class);
        String componentName = p.get("component").toString().replaceAll("\"", "");
        Component component = this.possibleComponents.stream().filter(c -> c.getName().equals(componentName)).findFirst().orElseThrow(NoSuchElementException::new);
        HashMap<String, ComponentInstance> satisfactionOfRequiredInterfaces = new HashMap<String, ComponentInstance>();
        TreeNode n = p.get("requiredInterfaces");
        Iterator fields = n.fieldNames();
        while (fields.hasNext()) {
            String key = (String)fields.next();
            satisfactionOfRequiredInterfaces.put(key, this.readAsTree(n.get(key)));
        }
        return new ComponentInstance(component, parameterValues, satisfactionOfRequiredInterfaces);
    }

    public ComponentInstance deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.readAsTree(p.readValueAsTree());
    }
}

