/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.serialization;

import ai.libs.hasco.model.BooleanParameterDomain;
import ai.libs.hasco.model.CategoricalParameterDomain;
import ai.libs.hasco.model.Component;
import ai.libs.hasco.model.Dependency;
import ai.libs.hasco.model.IParameterDomain;
import ai.libs.hasco.model.NumericParameterDomain;
import ai.libs.hasco.model.Parameter;
import ai.libs.hasco.model.ParameterRefinementConfiguration;
import ai.libs.hasco.serialization.UnresolvableRequiredInterfaceException;
import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.ResourceFile;
import ai.libs.jaicore.basic.ResourceUtil;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.geometry.euclidean.oned.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLoader {
    private static final Logger L = LoggerFactory.getLogger(ComponentLoader.class);
    private final Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramConfigs = new HashMap<Component, Map<Parameter, ParameterRefinementConfiguration>>();
    private final Collection<Component> components = new ArrayList<Component>();
    private final Set<String> parsedFiles = new HashSet<String>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, JsonNode> parameterMap = new HashMap<String, JsonNode>();
    private final Set<String> uniqueComponentNames = new HashSet<String>();
    private final Set<String> requiredInterfaces = new HashSet<String>();
    private final Set<String> providedInterfaces = new HashSet<String>();
    private final Map<String, JsonNode> componentMap = new HashMap<String, JsonNode>();
    private final boolean checkRequiredInterfacesResolvable;

    public ComponentLoader() {
        this(false);
    }

    public ComponentLoader(boolean checkRequiredInterfacesResolvable) {
        this.checkRequiredInterfacesResolvable = checkRequiredInterfacesResolvable;
    }

    public ComponentLoader(File jsonFile) throws IOException {
        this();
        this.loadComponents(jsonFile);
    }

    public ComponentLoader(File jsonFile, boolean checkRequiredInterfacesResolvable) throws IOException {
        this(checkRequiredInterfacesResolvable);
        this.loadComponents(jsonFile);
    }

    private void parseFile(File jsonFile) throws IOException {
        L.debug("Parse file {}...", (Object)jsonFile.getAbsolutePath());
        String jsonDescription = jsonFile instanceof ResourceFile ? ResourceUtil.readResourceFileToString((String)((ResourceFile)jsonFile).getPathName()) : FileUtil.readFileAsString((File)jsonFile);
        jsonDescription = jsonDescription.replaceAll("/\\*(.*)\\*/", "");
        JsonNode rootNode = this.objectMapper.readTree(jsonDescription);
        for (JsonNode elem : rootNode.path("parameters")) {
            this.parameterMap.put(elem.get("name").asText(), elem);
        }
        JsonNode includes = rootNode.path("include");
        File baseFolder = jsonFile.getParentFile();
        for (JsonNode includePathNode : includes) {
            String path = includePathNode.asText();
            File subFile = baseFolder instanceof ResourceFile ? new ResourceFile((ResourceFile)baseFolder, path) : new File(baseFolder, path);
            if (this.parsedFiles.contains(subFile.getCanonicalPath())) continue;
            this.parsedFiles.add(subFile.getCanonicalPath());
            this.parseFile(subFile);
        }
        this.readFromJson(rootNode);
    }

    public void readFromString(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        this.readFromJson(mapper.readTree(json));
    }

    private void readFromJson(JsonNode rootNode) throws IOException {
        JsonNode components = rootNode.path("components");
        if (components != null) {
            for (JsonNode component : components) {
                Component c = new Component(component.get("name").asText());
                this.componentMap.put(c.getName(), component);
                if (!this.uniqueComponentNames.add(c.getName())) {
                    throw new IllegalArgumentException("Noticed a component with duplicative component name: " + c.getName());
                }
                for (JsonNode providedInterface : component.path("providedInterface")) {
                    c.addProvidedInterface(providedInterface.asText());
                }
                for (JsonNode requiredInterface : component.path("requiredInterface")) {
                    if (!requiredInterface.has("id")) {
                        throw new IOException("No id has been specified for a required interface of " + c.getName());
                    }
                    if (!requiredInterface.has("name")) {
                        throw new IOException("No name has been specified for a required interface of " + c.getName());
                    }
                    c.addRequiredInterface(requiredInterface.get("id").asText(), requiredInterface.get("name").asText());
                }
                HashMap<Object, ParameterRefinementConfiguration> paramConfig = new HashMap<Object, ParameterRefinementConfiguration>();
                for (JsonNode parameter : component.path("parameter")) {
                    String type;
                    int i;
                    String name = parameter.get("name").asText();
                    String[] stringParams = new String[]{"type", "values", "default"};
                    String[] stringParamValues = new String[stringParams.length];
                    String[] boolParams = new String[]{"default", "includeExtremals"};
                    boolean[] boolParamValues = new boolean[boolParams.length];
                    String[] doubleParams = new String[]{"default", "min", "max", "refineSplits", "minInterval"};
                    double[] doubleParamValues = new double[doubleParams.length];
                    if (this.parameterMap.containsKey(name)) {
                        int i2;
                        JsonNode commonParameter = this.parameterMap.get(name);
                        for (i2 = 0; i2 < stringParams.length; ++i2) {
                            if (commonParameter.get(stringParams[i2]) == null) continue;
                            stringParamValues[i2] = commonParameter.get(stringParams[i2]).asText();
                        }
                        for (i2 = 0; i2 < doubleParams.length; ++i2) {
                            if (commonParameter.get(doubleParams[i2]) == null) continue;
                            doubleParamValues[i2] = commonParameter.get(doubleParams[i2]).asDouble();
                        }
                        for (i2 = 0; i2 < boolParams.length; ++i2) {
                            if (commonParameter.get(boolParams[i2]) == null) continue;
                            boolParamValues[i2] = commonParameter.get(boolParams[i2]).asBoolean();
                        }
                    }
                    for (i = 0; i < stringParams.length; ++i) {
                        if (parameter.get(stringParams[i]) == null) continue;
                        stringParamValues[i] = parameter.get(stringParams[i]).asText();
                    }
                    for (i = 0; i < doubleParams.length; ++i) {
                        if (parameter.get(doubleParams[i]) == null) continue;
                        doubleParamValues[i] = parameter.get(doubleParams[i]).asDouble();
                    }
                    for (i = 0; i < boolParams.length; ++i) {
                        if (parameter.get(boolParams[i]) == null) continue;
                        boolParamValues[i] = parameter.get(boolParams[i]).asBoolean();
                    }
                    Object p = null;
                    switch (type = stringParamValues[Arrays.stream(stringParams).collect(Collectors.toList()).indexOf("type")]) {
                        case "int": 
                        case "int-log": 
                        case "double": 
                        case "double-log": {
                            p = new Parameter(name, new NumericParameterDomain(type.equals("int") || type.equals("int-log"), doubleParamValues[1], doubleParamValues[2]), doubleParamValues[0]);
                            if (doubleParamValues[3] == 0.0) {
                                throw new IllegalArgumentException("Please specify the parameter \"refineSplits\" for the parameter \"" + ((Parameter)p).getName() + "\" in component \"" + c.getName() + "\"");
                            }
                            if (doubleParamValues[4] <= 0.0) {
                                throw new IllegalArgumentException("Please specify a strictly positive parameter value for \"minInterval\" for the parameter \"" + ((Parameter)p).getName() + "\" in component \"" + c.getName() + "\"");
                            }
                            if (type.endsWith("-log")) {
                                paramConfig.put(p, new ParameterRefinementConfiguration(parameter.get("focus").asDouble(), parameter.get("basis").asDouble(), boolParamValues[1], (int)doubleParamValues[3], doubleParamValues[4]));
                                break;
                            }
                            paramConfig.put(p, new ParameterRefinementConfiguration(boolParamValues[1], (int)doubleParamValues[3], doubleParamValues[4]));
                            break;
                        }
                        case "bool": 
                        case "boolean": {
                            p = new Parameter(name, new BooleanParameterDomain(), boolParamValues[0]);
                            break;
                        }
                        case "cat": {
                            if (parameter.get("values") != null && parameter.get("values").isTextual()) {
                                p = new Parameter(name, new CategoricalParameterDomain(Arrays.stream(stringParamValues[1].split(",")).collect(Collectors.toList())), stringParamValues[2]);
                                break;
                            }
                            LinkedList<String> values = new LinkedList<String>();
                            if (parameter.get("values") != null) {
                                for (JsonNode value : parameter.get("values")) {
                                    values.add(value.asText());
                                }
                            } else if (this.parameterMap.containsKey(name)) {
                                for (JsonNode value : this.parameterMap.get(name).get("values")) {
                                    values.add(value.asText());
                                }
                            } else {
                                L.error("Warning: Categorical parameter {} in component {} without value list.", (Object)name, (Object)c.getName());
                            }
                            p = new Parameter(name, new CategoricalParameterDomain(values), stringParamValues[2]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported parameter type " + type);
                        }
                    }
                    if (p == null) continue;
                    c.addParameter((Parameter)p);
                }
                for (JsonNode dependency : component.path("dependencies")) {
                    List<String> literals;
                    String pre = dependency.get("pre").asText();
                    ArrayList<Collection<Pair<Parameter, IParameterDomain>>> premise = new ArrayList<Collection<Pair<Parameter, IParameterDomain>>>();
                    List<String> monoms = Arrays.asList(pre.split("\\|"));
                    for (String monom : monoms) {
                        literals = Arrays.asList(monom.split("&"));
                        ArrayList<Pair> monomInPremise = new ArrayList<Pair>();
                        block44: for (String literal : literals) {
                            String[] parts = literal.trim().split(" ");
                            if (parts.length != 3) {
                                throw new IllegalArgumentException("Cannot parse literal " + literal + ". Literals must be of the form \"<a> P <b>\".");
                            }
                            Parameter param = c.getParameterWithName(parts[0]);
                            String target = parts[2];
                            switch (parts[1]) {
                                case "=": {
                                    Pair conditionItem;
                                    if (param.isNumeric()) {
                                        double val = Double.valueOf(target);
                                        conditionItem = new Pair((Object)param, (Object)new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), val, val));
                                    } else if (param.isCategorical()) {
                                        conditionItem = new Pair((Object)param, (Object)new CategoricalParameterDomain(new String[]{target}));
                                    } else {
                                        throw new IllegalArgumentException("Currently no support for parameters with domain \"" + param.getDefaultDomain().getClass().getName() + "\"");
                                    }
                                    monomInPremise.add(conditionItem);
                                    continue block44;
                                }
                                case "in": {
                                    Pair conditionItem;
                                    if (param.isNumeric()) {
                                        Interval interval = SetUtil.unserializeInterval((String)("[" + target.substring(1, target.length() - 1) + "]"));
                                        conditionItem = new Pair((Object)param, (Object)new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), interval.getInf(), interval.getSup()));
                                    } else if (param.isCategorical()) {
                                        if (!target.startsWith("[") && !target.startsWith("{")) {
                                            throw new IllegalArgumentException("Illegal literal \"" + literal + "\" in the postcondition of dependency. This should be a set, but the target is not described by [...] or {...}");
                                        }
                                        Collection values = target.startsWith("[") ? SetUtil.unserializeList((String)target) : SetUtil.unserializeSet((String)target);
                                        conditionItem = new Pair((Object)param, (Object)new CategoricalParameterDomain(values));
                                    } else {
                                        throw new IllegalArgumentException("Currently no support for parameters with domain \"" + param.getDefaultDomain().getClass().getName() + "\"");
                                    }
                                    monomInPremise.add(conditionItem);
                                    continue block44;
                                }
                            }
                            throw new IllegalArgumentException("Cannot parse literal " + literal + ". Currently no support for predicate \"" + parts[1] + "\".");
                        }
                        premise.add(monomInPremise);
                    }
                    ArrayList<Pair<Parameter, IParameterDomain>> conclusion = new ArrayList<Pair<Parameter, IParameterDomain>>();
                    String post = dependency.get("post").asText();
                    literals = Arrays.asList(post.split("&"));
                    block45: for (String literal : literals) {
                        String[] parts = literal.trim().split(" ");
                        if (parts.length < 3) {
                            throw new IllegalArgumentException("Cannot parse literal " + literal + ". Literals must be of the form \"<a> P <b>\".");
                        }
                        if (parts.length > 3) {
                            for (int i = 3; i < parts.length; ++i) {
                                parts[2] = parts[2] + " " + parts[i];
                            }
                        }
                        Parameter param = c.getParameterWithName(parts[0]);
                        String target = parts[2];
                        switch (parts[1]) {
                            case "=": {
                                Pair conditionItem;
                                if (param.isNumeric()) {
                                    double val = Double.valueOf(target);
                                    conditionItem = new Pair((Object)param, (Object)new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), val, val));
                                } else if (param.isCategorical()) {
                                    conditionItem = new Pair((Object)param, (Object)new CategoricalParameterDomain(new String[]{target}));
                                } else {
                                    throw new IllegalArgumentException("Currently no support for parameters with domain \"" + param.getDefaultDomain().getClass().getName() + "\"");
                                }
                                conclusion.add((Pair<Parameter, IParameterDomain>)conditionItem);
                                continue block45;
                            }
                            case "in": {
                                Pair conditionItem;
                                if (param.isNumeric()) {
                                    Interval interval = SetUtil.unserializeInterval((String)("[" + target.substring(1, target.length() - 1) + "]"));
                                    conditionItem = new Pair((Object)param, (Object)new NumericParameterDomain(((NumericParameterDomain)param.getDefaultDomain()).isInteger(), interval.getInf(), interval.getSup()));
                                } else if (param.isCategorical()) {
                                    if (!target.startsWith("[") && !target.startsWith("{")) {
                                        throw new IllegalArgumentException("Illegal literal \"" + literal + "\" in the postcondition of dependency. This should be a set, but the target is not described by [...] or {...}");
                                    }
                                    Collection values = target.startsWith("[") ? SetUtil.unserializeList((String)target) : SetUtil.unserializeSet((String)target);
                                    conditionItem = new Pair((Object)param, (Object)new CategoricalParameterDomain(values));
                                } else {
                                    throw new IllegalArgumentException("Currently no support for parameters with domain \"" + param.getDefaultDomain().getClass().getName() + "\"");
                                }
                                conclusion.add((Pair<Parameter, IParameterDomain>)conditionItem);
                                continue block45;
                            }
                        }
                        throw new IllegalArgumentException("Cannot parse literal " + literal + ". Currently no support for predicate \"" + parts[1] + "\".");
                    }
                    c.addDependency(new Dependency(premise, conclusion));
                }
                this.paramConfigs.put(c, paramConfig);
                this.components.add(c);
                this.requiredInterfaces.addAll(c.getRequiredInterfaces().values());
                this.providedInterfaces.addAll(c.getProvidedInterfaces());
            }
        }
    }

    public ComponentLoader loadComponents(File componentDescriptionFile) throws IOException, UnresolvableRequiredInterfaceException {
        this.paramConfigs.clear();
        this.components.clear();
        this.uniqueComponentNames.clear();
        this.requiredInterfaces.clear();
        this.providedInterfaces.clear();
        this.parseFile(componentDescriptionFile);
        if (this.checkRequiredInterfacesResolvable && !this.getUnresolvableRequiredInterfaces().isEmpty()) {
            throw new UnresolvableRequiredInterfaceException();
        }
        return this;
    }

    public Collection<String> getUnresolvableRequiredInterfaces() {
        return SetUtil.difference(this.requiredInterfaces, this.providedInterfaces);
    }

    public JsonNode getComponentAsJsonNode(String componentName) {
        return this.componentMap.get(componentName);
    }

    public Map<Component, Map<Parameter, ParameterRefinementConfiguration>> getParamConfigs() {
        return this.paramConfigs;
    }

    public Collection<Component> getComponents() {
        return this.components;
    }

    public Component getComponentWithName(String name) {
        for (Component component : this.getComponents()) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        throw new NoSuchElementException("There is no component with the requested name");
    }

    public static void main(String[] args) throws IOException, UnresolvableRequiredInterfaceException {
        ComponentLoader cl = new ComponentLoader();
        cl.loadComponents(new File("complexMLComponents.json"));
    }

    public Map<String, JsonNode> getJsonNodeComponents() {
        return this.componentMap;
    }
}

