/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.hasco.variants.forwarddecomposition.twophase;

import ai.libs.hasco.core.HASCO;
import ai.libs.hasco.core.HASCOSolutionCandidate;
import ai.libs.hasco.events.HASCOSolutionEvent;
import ai.libs.hasco.model.ComponentInstance;
import ai.libs.hasco.optimizingfactory.SoftwareConfigurationAlgorithm;
import ai.libs.hasco.variants.forwarddecomposition.DefaultPathPriorizingPredicate;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseHASCOConfig;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseHASCOReport;
import ai.libs.hasco.variants.forwarddecomposition.twophase.TwoPhaseSoftwareConfigurationProblem;
import ai.libs.jaicore.basic.IInformedObjectEvaluatorExtension;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.concurrent.NamedTimerTask;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.search.core.interfaces.GraphGenerator;
import ai.libs.jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import ai.libs.jaicore.timing.TimedComputation;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseHASCO<S extends GraphSearchWithPathEvaluationsInput<N, A, Double>, N, A>
extends SoftwareConfigurationAlgorithm<TwoPhaseSoftwareConfigurationProblem, HASCOSolutionCandidate<Double>, Double> {
    private Logger logger = LoggerFactory.getLogger(TwoPhaseHASCO.class);
    private String loggerName;
    private HASCO<S, N, A, Double> hasco;
    private NamedTimerTask phase1CancellationTask;
    private final Queue<HASCOSolutionCandidate<Double>> phase1ResultQueue = new LinkedBlockingQueue<HASCOSolutionCandidate<Double>>();
    private final Map<HASCOSolutionCandidate<Double>, Double> selectionScoresOfCandidates = new HashMap<HASCOSolutionCandidate<Double>, Double>();
    private HASCOSolutionCandidate<Double> selectedHASCOSolution;
    private long timeOfStart = -1L;
    private int secondsSpentInPhase1;
    private static final double MAX_MARGIN_FROM_BEST = 0.03;

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("hasco", this.hasco);
        fields.put("phase1ResultQueue", this.phase1ResultQueue);
        fields.put("selectedHASCOSolution", this.selectedHASCOSolution);
        fields.put("timeOfStart", this.timeOfStart);
        fields.put("secondsSpentInPhase1", this.secondsSpentInPhase1);
        return ToJSONStringUtil.toJSONString(fields);
    }

    public TwoPhaseHASCO(TwoPhaseSoftwareConfigurationProblem problem, TwoPhaseHASCOConfig config) {
        super(config != null ? config : (IAlgorithmConfig)ConfigFactory.create(TwoPhaseHASCOConfig.class, (Map[])new Map[0]), problem);
        this.logger.info("Created TwoPhaseHASCO object.");
    }

    public TwoPhaseHASCO(TwoPhaseSoftwareConfigurationProblem problem, TwoPhaseHASCOConfig config, HASCO<S, N, A, Double> hasco) {
        this(problem, config);
        this.setHasco(hasco);
    }

    public void setHasco(HASCO<S, N, A, Double> hasco) {
        this.hasco = hasco;
        if (this.getLoggerName() != null) {
            this.hasco.setLoggerName(this.getLoggerName() + ".hasco");
        }
        this.hasco.setConfig(this.getConfig());
        this.hasco.registerListener(new Object(){

            @Subscribe
            public void receiveHASCOEvent(AlgorithmEvent event) {
                if (!(event instanceof AlgorithmInitializedEvent) && !(event instanceof AlgorithmFinishedEvent)) {
                    TwoPhaseHASCO.this.post(event);
                }
                if (event instanceof HASCOSolutionEvent) {
                    HASCOSolutionCandidate solution = (HASCOSolutionCandidate)((HASCOSolutionEvent)event).getSolutionCandidate();
                    TwoPhaseHASCO.this.updateBestSeenSolution(solution);
                    TwoPhaseHASCO.this.logger.info("Received new solution {} with score {} and evaluation time {}ms", new Object[]{solution.getComponentInstance(), solution.getScore(), solution.getTimeToEvaluateCandidate()});
                    TwoPhaseHASCO.this.phase1ResultQueue.add(solution);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmTimeoutedException, AlgorithmException, AlgorithmExecutionCanceledException {
        this.logger.info("Stepping 2phase HASCO. Current state: {}", (Object)this.getState());
        switch (this.getState()) {
            case CREATED: {
                if (this.hasco == null) {
                    throw new IllegalStateException("Cannot start algorithm before HASCO has been set. Please set HASCO either in constructor or via the setter.");
                }
                this.timeOfStart = System.currentTimeMillis();
                AlgorithmInitializedEvent event = this.activate();
                this.logger.info("Starting 2-Phase HASCO with the following setup:\n\tCPUs:{},\n\tTimeout: {}s\n\tTimeout per node evaluation: {}ms\n\tTimeout per candidate: {}ms\n\tNumber of Random Completions: {}\n\tExpected blow-ups are {} (selection) and {} (post-processing).\nThe search factory is: {}", new Object[]{this.getNumCPUs(), this.getTimeout().seconds(), this.getConfig().timeoutForNodeEvaluation(), this.getConfig().timeoutForCandidateEvaluation(), this.getConfig().numberOfRandomCompletions(), this.getConfig().expectedBlowupInSelection(), this.getConfig().expectedBlowupInPostprocessing(), this.hasco.getSearchFactory()});
                DefaultPathPriorizingPredicate<N, A> prioritizingPredicate = new DefaultPathPriorizingPredicate<N, A>();
                prioritizingPredicate.setHasco(this.hasco);
                this.setHASCOLoggerNameIfPossible();
                this.logger.info("Initialized HASCO with start time {}.", (Object)this.timeOfStart);
                return event;
            }
            case ACTIVE: {
                if (this.hasco.getTimeout().milliseconds() >= 0L) {
                    GlobalTimer timer = GlobalTimer.getInstance();
                    this.phase1CancellationTask = new NamedTimerTask(){

                        public void run() {
                            try {
                                if (TwoPhaseHASCO.this.isShutdownInitialized()) {
                                    this.cancel();
                                    return;
                                }
                                int timeElapsed = (int)(System.currentTimeMillis() - TwoPhaseHASCO.this.timeOfStart);
                                int timeRemaining = (int)TwoPhaseHASCO.this.hasco.getTimeout().milliseconds() - timeElapsed;
                                if (timeRemaining < 2000 || TwoPhaseHASCO.this.shouldSearchTerminate(timeRemaining)) {
                                    TwoPhaseHASCO.this.logger.info("Canceling HASCO (first phase). {}ms remaining.", (Object)timeRemaining);
                                    TwoPhaseHASCO.this.hasco.cancel();
                                    TwoPhaseHASCO.this.logger.info("HASCO canceled successfully after {}ms", (Object)(System.currentTimeMillis() - TwoPhaseHASCO.this.timeOfStart - (long)timeElapsed));
                                    this.cancel();
                                }
                            }
                            catch (Throwable e) {
                                TwoPhaseHASCO.this.logger.error("Observed {} while checking termination of phase 1. Stack trace is: {}", (Object)e.getClass().getName(), (Object)Arrays.stream(e.getStackTrace()).map(se -> "\n\t" + se.toString()).collect(Collectors.joining()));
                            }
                        }
                    };
                    this.phase1CancellationTask.setDescriptor("TwoPhaseHASCO task to check termination of phase 1");
                    timer.scheduleAtFixedRate((TimerTask)this.phase1CancellationTask, 1000L, 1000L);
                }
                this.logger.info("Entering phase 1. Calling HASCO with timeout {}.", (Object)this.hasco.getTimeout());
                try {
                    this.hasco.call();
                }
                catch (AlgorithmExecutionCanceledException e2) {
                    this.logger.info("HASCO has terminated due to a cancel.");
                    if (this.isCanceled()) {
                        throw new AlgorithmExecutionCanceledException(e2.getDelay());
                    }
                }
                catch (AlgorithmTimeoutedException e3) {
                    this.logger.warn("HASCO has timeouted. In fact, time to deadline is {}ms", (Object)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart)));
                }
                finally {
                    this.phase1CancellationTask.cancel();
                }
                this.secondsSpentInPhase1 = (int)Math.round((double)System.currentTimeMillis() - (double)this.timeOfStart / 1000.0);
                this.logger.info("HASCO has finished. {} solutions were found.", (Object)this.phase1ResultQueue.size());
                if (this.phase1ResultQueue.isEmpty() && this.getRemainingTimeToDeadline().seconds() < 10L) {
                    this.logger.info("No solution found within phase 1. Throwing an AlgorithmTimeoutedException (This is conventional behavior for when an algorithm has not identified its solution when the timeout bound is hit.)");
                    this.terminate();
                    throw new AlgorithmTimeoutedException(this.getRemainingTimeToDeadline().milliseconds() * -1L);
                }
                IObjectEvaluator<ComponentInstance, Double> selectionBenchmark = ((TwoPhaseSoftwareConfigurationProblem)this.getInput()).getSelectionBenchmark();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Entering phase 2. Solutions seen so far had an (internal) error of {}", (Object)this.phase1ResultQueue.stream().map(e -> "\n\t" + e.getScore() + "(" + e.getComponentInstance() + ")").collect(Collectors.joining()));
                }
                if (selectionBenchmark instanceof IInformedObjectEvaluatorExtension) {
                    this.logger.debug("Setting best score for selection phase node evaluator to {}", (Object)this.phase1ResultQueue.peek().getScore());
                    ((IInformedObjectEvaluatorExtension)selectionBenchmark).updateBestScore((Comparable)this.phase1ResultQueue.peek().getScore());
                }
                this.checkAndConductTermination();
                this.selectedHASCOSolution = this.selectModel();
                this.setBestSeenSolution(this.selectedHASCOSolution);
                assert (((HASCOSolutionCandidate)this.getBestSeenSolution()).equals(this.selectedHASCOSolution));
                return this.terminate();
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    protected boolean shouldSearchTerminate(long timeRemaining) {
        List<HASCOSolutionCandidate<Double>> currentSelection = this.getSelectionForPhase2();
        int estimateForRemainingRuntime = this.getExpectedTotalRemainingRuntimeForAGivenPool(currentSelection, true);
        boolean terminatePhase1 = (long)(estimateForRemainingRuntime + 5000) > timeRemaining;
        this.logger.debug("{}ms of the available time remaining in total, and we estimate a remaining runtime of {}ms. Terminate phase 1: {}", new Object[]{timeRemaining, estimateForRemainingRuntime, terminatePhase1});
        return terminatePhase1;
    }

    public synchronized List<HASCOSolutionCandidate<Double>> getSelectionForPhase2() {
        return this.getSelectionForPhase2(Integer.MAX_VALUE);
    }

    private synchronized List<HASCOSolutionCandidate<Double>> getSelectionForPhase2(int remainingTime) {
        int budget;
        if (this.getNumberOfConsideredSolutions() < 1) {
            throw new UnsupportedOperationException("Cannot determine candidates for phase 2 if their number is set to a value less than 1. Here, it has been set to " + this.getNumberOfConsideredSolutions());
        }
        if (remainingTime < 0) {
            throw new IllegalArgumentException("Cannot do anything in negative time (" + remainingTime + "ms)");
        }
        HASCOSolutionCandidate internallyOptimalSolution = (HASCOSolutionCandidate)this.getBestSeenSolution();
        if (internallyOptimalSolution == null) {
            return new ArrayList<HASCOSolutionCandidate<Double>>();
        }
        double optimalInternalScore = (Double)internallyOptimalSolution.getScore();
        int bestK = (int)Math.ceil((double)this.getNumberOfConsideredSolutions() / 2.0);
        int randomK = this.getNumberOfConsideredSolutions() - bestK;
        Collection potentialCandidates = new ArrayList<HASCOSolutionCandidate<Double>>(this.phase1ResultQueue).stream().filter(solution -> (Double)solution.getScore() <= optimalInternalScore + 0.03).collect(Collectors.toList());
        this.logger.debug("Computing {} best and {} random solutions for a max runtime of {}. Number of candidates that are at most {} worse than optimum {} is: {}/{}", new Object[]{bestK, randomK, remainingTime, 0.03, optimalInternalScore, potentialCandidates.size(), this.phase1ResultQueue.size()});
        List<HASCOSolutionCandidate<Double>> selectionCandidates = potentialCandidates.stream().limit(bestK).collect(Collectors.toList());
        ArrayList remainingCandidates = new ArrayList(SetUtil.difference((Collection)potentialCandidates, selectionCandidates));
        Collections.shuffle(remainingCandidates, new Random(this.getConfig().randomSeed()));
        selectionCandidates.addAll(remainingCandidates.stream().limit(randomK).collect(Collectors.toList()));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Determined the following candidates for selection phase (in this order): {}", (Object)selectionCandidates.stream().map(c -> "\n\t" + c.getScore() + ": " + c.getComponentInstance()).collect(Collectors.joining()));
        }
        if ((budget = this.getExpectedTotalRemainingRuntimeForAGivenPool(selectionCandidates, true)) < remainingTime) {
            return selectionCandidates;
        }
        ArrayList<HASCOSolutionCandidate<Double>> actuallySelectedSolutions = new ArrayList<HASCOSolutionCandidate<Double>>();
        for (HASCOSolutionCandidate<Double> pl : selectionCandidates) {
            actuallySelectedSolutions.add(pl);
            int expectedRuntime = this.getExpectedTotalRemainingRuntimeForAGivenPool(actuallySelectedSolutions, true);
            if (expectedRuntime <= remainingTime || actuallySelectedSolutions.size() <= 1) continue;
            this.logger.info("Not considering solution {} for phase 2, because the expected runtime of the whole thing would be {}/{}", new Object[]{pl, expectedRuntime, remainingTime});
            actuallySelectedSolutions.remove(pl);
        }
        return actuallySelectedSolutions;
    }

    private int getInSearchEvaluationTimeOfSolutionSet(Collection<HASCOSolutionCandidate<Double>> solutions) {
        return solutions.stream().map(HASCOSolutionCandidate::getTimeToEvaluateCandidate).mapToInt(x -> x).sum();
    }

    public int getExpectedTotalRemainingRuntimeForAGivenPool(Collection<HASCOSolutionCandidate<Double>> solutions, boolean assumeCurrentlyBestCandidateToBeSelected) {
        int timeForPhase2 = this.getExpectedRuntimeForPhase2ForAGivenPool(solutions);
        int timeForPostprocessing = 0;
        timeForPostprocessing = assumeCurrentlyBestCandidateToBeSelected && this.getBestSeenSolution() != null ? this.getPostprocessingTimeOfCurrentlyBest() : this.getMaximumPostprocessingTimeOfAnyPoolMember(solutions);
        return timeForPhase2 + timeForPostprocessing;
    }

    public int getPostprocessingTimeOfCurrentlyBest() {
        return (int)Math.round((double)((HASCOSolutionCandidate)this.getBestSeenSolution()).getTimeToEvaluateCandidate() * this.getConfig().expectedBlowupInSelection() * this.getConfig().expectedBlowupInPostprocessing());
    }

    public int getMaximumPostprocessingTimeOfAnyPoolMember(Collection<HASCOSolutionCandidate<Double>> solutions) {
        int max = 0;
        for (HASCOSolutionCandidate<Double> candidate : solutions) {
            int expectedPostProcessingTime = (int)Math.ceil((double)candidate.getTimeToEvaluateCandidate() * this.getConfig().expectedBlowupInSelection() * this.getConfig().expectedBlowupInPostprocessing());
            max = Math.max(max, expectedPostProcessingTime);
        }
        return max;
    }

    public int getExpectedRuntimeForPhase2ForAGivenPool(Collection<HASCOSolutionCandidate<Double>> solutions) {
        int inSearchMCEvalTime = this.getInSearchEvaluationTimeOfSolutionSet(solutions);
        int estimateEvaluationTimeForSelectionPhase = (int)((double)inSearchMCEvalTime * this.getConfig().expectedBlowupInSelection());
        int usableCPUs = Math.min(this.getConfig().cpus(), solutions.size());
        int runtime = estimateEvaluationTimeForSelectionPhase / Math.max(1, usableCPUs);
        this.logger.debug("Expected runtime is {} = {} * {} / {} for a pool of size {}", new Object[]{runtime, inSearchMCEvalTime, this.getConfig().expectedBlowupInSelection(), usableCPUs, solutions.size()});
        return runtime;
    }

    protected HASCOSolutionCandidate<Double> selectModel() throws InterruptedException {
        List<HASCOSolutionCandidate<Double>> ensembleToSelectFrom;
        IObjectEvaluator<ComponentInstance, Double> evaluator = ((TwoPhaseSoftwareConfigurationProblem)this.getInput()).getSelectionBenchmark();
        Optional bestSolutionOptional = this.phase1ResultQueue.stream().min((s1, s2) -> ((Double)s1.getScore()).compareTo((Double)s2.getScore()));
        if (!bestSolutionOptional.isPresent()) {
            throw new IllegalStateException("Cannot select a model since phase 1 has not returned any result.");
        }
        HASCOSolutionCandidate<Double> bestSolution = (HASCOSolutionCandidate<Double>)bestSolutionOptional.get();
        double scoreOfBestSolution = (Double)bestSolution.getScore();
        this.logger.info("Starting with phase 2: Selection of final model among the {} solutions that were identified.", (Object)this.phase1ResultQueue.size());
        long startOfPhase2 = System.currentTimeMillis();
        if (this.getTimeout().seconds() > 0L) {
            int expectedPostprocessingTime;
            int remainingTime = (int)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart));
            if (remainingTime < 0) {
                this.logger.info("Timelimit is already exhausted, just returning a greedy solution that had internal error {}.", (Object)scoreOfBestSolution);
                return bestSolution;
            }
            ensembleToSelectFrom = this.getSelectionForPhase2(remainingTime);
            int expectedTimeForPhase2 = this.getExpectedRuntimeForPhase2ForAGivenPool(ensembleToSelectFrom);
            int expectedMaximumRemainingRuntime = expectedTimeForPhase2 + (expectedPostprocessingTime = this.getPostprocessingTimeOfCurrentlyBest());
            if (expectedMaximumRemainingRuntime > (remainingTime = (int)(this.getTimeout().milliseconds() - (System.currentTimeMillis() - this.timeOfStart)))) {
                this.logger.warn("Only {}ms remaining. We probably cannot make it in time.", (Object)remainingTime);
            }
            this.logger.info("We expect phase 2 to consume {}ms for {} candidates, and post-processing is assumed to take at most {}ms, which is a total remaining runtime of {}ms. {}ms are permitted by timeout. The following pipelines are considered: ", new Object[]{expectedTimeForPhase2, ensembleToSelectFrom.size(), expectedPostprocessingTime, expectedMaximumRemainingRuntime, remainingTime});
        } else {
            ensembleToSelectFrom = this.getSelectionForPhase2();
        }
        AtomicInteger evaluatorCounter = new AtomicInteger(0);
        int threadsForPool = this.getConfig().threads() < 1 ? this.getConfig().cpus() : this.getConfig().threads() - 1;
        this.logger.info("Create a thread pool for phase 2 of size {}.", (Object)threadsForPool);
        ExecutorService pool = Executors.newFixedThreadPool(threadsForPool, r -> {
            Thread t = new Thread(r);
            t.setName("final-evaluator-" + evaluatorCounter.incrementAndGet());
            return t;
        });
        HASCOSolutionCandidate<Double> selectedModel = bestSolution;
        Semaphore sem = new Semaphore(0);
        long timestampOfDeadline = this.timeOfStart + this.getTimeout().milliseconds() - 2000L;
        ArrayList<Double> stats = new ArrayList<Double>();
        ensembleToSelectFrom.forEach(c -> stats.add((Double)Double.MAX_VALUE));
        int n = ensembleToSelectFrom.size();
        AtomicInteger evaluatedModels = new AtomicInteger();
        int i = 0;
        while (i < n) {
            HASCOSolutionCandidate<Double> c2 = ensembleToSelectFrom.get(i);
            int run = i++;
            pool.submit(() -> {
                int remainingTime;
                long timestampStart = System.currentTimeMillis();
                int inSearchSolutionEvaluationTime = c2.getTimeToEvaluateCandidate();
                int estimatedInSelectionSingleIterationEvaluationTime = (int)Math.round((double)inSearchSolutionEvaluationTime * this.getConfig().expectedBlowupInSelection());
                int estimatedPostProcessingTime = (int)Math.round((double)estimatedInSelectionSingleIterationEvaluationTime * this.getConfig().expectedBlowupInPostprocessing());
                int estimatedTotalEffortInCaseOfSelection = estimatedInSelectionSingleIterationEvaluationTime + Math.max(estimatedPostProcessingTime, this.getPostprocessingTimeOfCurrentlyBest());
                this.logger.info("Estimating {}ms re-evaluation time and {}ms build time for candidate {} in case of selection (evaluation time during search was {}ms).", new Object[]{estimatedInSelectionSingleIterationEvaluationTime, estimatedPostProcessingTime, c2.getComponentInstance(), inSearchSolutionEvaluationTime});
                if (this.getTimeout().seconds() > 0L && estimatedTotalEffortInCaseOfSelection >= (remainingTime = (int)(timestampOfDeadline - System.currentTimeMillis()))) {
                    this.logger.info("Not evaluating solution {} anymore, because its insearch evaluation time was {}, expected evaluation time for selection is {}, and expected post-processing time is {}. This adds up to {}, which exceeds the remaining time of {}!", new Object[]{c2.getComponentInstance(), c2.getTimeToEvaluateCandidate(), estimatedInSelectionSingleIterationEvaluationTime, estimatedPostProcessingTime, estimatedTotalEffortInCaseOfSelection, remainingTime});
                    sem.release();
                    return;
                }
                int timeoutForEvaluation = (int)Math.max(50.0, (double)estimatedInSelectionSingleIterationEvaluationTime * (1.0 + this.getConfig().selectionPhaseTimeoutTolerance()));
                try {
                    this.logger.debug("Starting selection performance computation with timeout {}", (Object)timeoutForEvaluation);
                    TimedComputation.compute(() -> {
                        double selectionScore = (Double)evaluator.evaluate((Object)c2.getComponentInstance());
                        evaluatedModels.incrementAndGet();
                        long trueEvaluationTime = System.currentTimeMillis() - timestampStart;
                        stats.set(run, selectionScore);
                        this.selectionScoresOfCandidates.put(c2, selectionScore);
                        this.logger.info("Obtained evaluation score of {} after {}ms for candidate {} (score assigned by HASCO was {}).", new Object[]{selectionScore, trueEvaluationTime, c2.getComponentInstance(), c2.getScore()});
                        return true;
                    }, (long)timeoutForEvaluation, (String)("Timeout for evaluation of ensemble candidate " + c2.getComponentInstance()));
                }
                catch (InterruptedException e) {
                    assert (!Thread.currentThread().isInterrupted()) : "The interrupted-flag should not be true when an InterruptedException is thrown!";
                    this.logger.info("Selection eval of {} got interrupted after {}ms. Defined timeout was: {}ms", new Object[]{c2.getComponentInstance(), System.currentTimeMillis() - timestampStart, timeoutForEvaluation});
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    this.logger.error("Observed an exeption when trying to evaluate a candidate in the selection phase.\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e.getCause()));
                }
                catch (AlgorithmTimeoutedException e) {
                    this.logger.info("Evaluation of candidate has timed out: {}", (Object)c2);
                }
                finally {
                    sem.release();
                    this.logger.debug("Released. Sem state: {}", (Object)sem.availablePermits());
                }
            });
        }
        this.logger.info("Waiting for termination of {} computations running on {} threads.", (Object)n, (Object)this.getConfig().cpus());
        sem.acquire(n);
        long endOfPhase2 = System.currentTimeMillis();
        this.logger.info("Finished phase 2 within {}ms net. Total runtime was {}ms. Evaluated solutions {}/{}", new Object[]{endOfPhase2 - startOfPhase2, endOfPhase2 - this.timeOfStart, evaluatedModels.get(), n});
        this.logger.debug("Shutting down thread pool");
        pool.shutdownNow();
        pool.awaitTermination(5L, TimeUnit.SECONDS);
        if (!pool.isShutdown()) {
            this.logger.warn("Thread pool is not shut down yet!");
        }
        if (ensembleToSelectFrom.isEmpty()) {
            this.logger.warn("No solution contained in ensemble.");
        } else {
            int selectedModelIndex = this.getCandidateThatWouldCurrentlyBeSelectedWithinPhase2(ensembleToSelectFrom, stats);
            if (selectedModelIndex >= 0) {
                selectedModel = ensembleToSelectFrom.get(selectedModelIndex);
                this.logger.info("Selected a configuration: {}. Its internal score was {}. Selection score was {}", new Object[]{selectedModel.getComponentInstance(), selectedModel.getScore(), stats.get(selectedModelIndex)});
            } else {
                this.logger.warn("Could not select any real solution in selection phase, just returning the best we have seen in HASCO.");
                return bestSolution;
            }
        }
        return selectedModel;
    }

    private synchronized int getCandidateThatWouldCurrentlyBeSelectedWithinPhase2(List<HASCOSolutionCandidate<Double>> ensembleToSelectFrom, List<Double> stats) {
        int selectedModel = -1;
        double best = Double.MAX_VALUE;
        for (int i = 0; i < ensembleToSelectFrom.size(); ++i) {
            double score = stats.get(i);
            if (!(score < best)) continue;
            best = score;
            selectedModel = i;
        }
        return selectedModel;
    }

    public HASCO<S, N, A, Double> getHasco() {
        return this.hasco;
    }

    public Queue<HASCOSolutionCandidate<Double>> getPhase1ResultQueue() {
        return this.phase1ResultQueue;
    }

    public int getSecondsSpentInPhase1() {
        return this.secondsSpentInPhase1;
    }

    public Map<HASCOSolutionCandidate<Double>, Double> getSelectionScoresOfCandidates() {
        return this.selectionScoresOfCandidates;
    }

    public void shutdown() {
        this.logger.info("Received shutdown signal. Cancelling phase 1 timer and invoking shutdown on parent.");
        if (this.phase1CancellationTask != null) {
            this.phase1CancellationTask.cancel();
        }
        super.shutdown();
    }

    public void cancel() {
        this.logger.info("Received cancel signal.");
        super.cancel();
        this.logger.debug("Cancelling HASCO");
        if (this.hasco != null) {
            this.hasco.cancel();
        }
        assert (this.isCanceled()) : "Cancel-flag is not true at the end of the cancel procedure!";
    }

    public HASCOSolutionCandidate<Double> getSelectedSolutionCandidate() {
        return this.selectedHASCOSolution;
    }

    public TwoPhaseHASCOConfig getConfig() {
        return (TwoPhaseHASCOConfig)super.getConfig();
    }

    public int getNumberOfConsideredSolutions() {
        return this.getConfig().selectionNumConsideredSolutions();
    }

    public void setNumberOfConsideredSolutions(int numberOfConsideredSolutions) {
        this.getConfig().setProperty("hasco.selection.num_considered_solutions", numberOfConsideredSolutions + "");
    }

    public GraphGenerator<N, A> getGraphGenerator() {
        if (this.hasco == null) {
            throw new IllegalStateException("Cannot retrieve GraphGenerator prior to algorithm initialization.");
        }
        return this.hasco.getGraphGenerator();
    }

    public TwoPhaseHASCOReport getReort() {
        return new TwoPhaseHASCOReport(this.phase1ResultQueue.size(), this.secondsSpentInPhase1, this.selectedHASCOSolution);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        this.setHASCOLoggerNameIfPossible();
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    private void setHASCOLoggerNameIfPossible() {
        if (this.hasco == null) {
            this.logger.info("HASCO object is null, so not setting a logger.");
            return;
        }
        if (this.hasco.getLoggerName() != null && this.hasco.getLoggerName().equals(this.loggerName + ".hasco")) {
            this.logger.info("HASCO logger has already been customized correctly, not customizing again.");
            return;
        }
        this.logger.info("Setting logger of {} to {}", (Object)this.hasco.getId(), (Object)(this.getLoggerName() + ".hasco"));
        this.hasco.setLoggerName(this.getLoggerName() + ".hasco");
    }
}

