/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static String readResourceFileToString(String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(ResourceUtil.getResourceAsFile(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        return sb.toString();
    }

    public static List<String> readResourceFileToStringList(String path) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(ResourceUtil.getResourceAsFile(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    public static File getResourceAsFile(String path) {
        return new File(ResourceUtil.class.getClassLoader().getResource(path).getFile());
    }
}

