/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.PropertiesLoadFailedException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Mutable;

public interface IAlgorithmConfig
extends Mutable {
    public static final String K_CPUS = "cpus";
    public static final String K_THREADS = "threads";
    public static final String K_MEMORY = "memory";
    public static final String K_TIMEOUT = "timeout";

    @Config.Key(value="cpus")
    @Config.DefaultValue(value="8")
    public int cpus();

    @Config.Key(value="threads")
    @Config.DefaultValue(value="-1")
    public int threads();

    @Config.Key(value="memory")
    @Config.DefaultValue(value="256")
    public int memory();

    @Config.Key(value="timeout")
    @Config.DefaultValue(value="-1")
    public long timeout();

    default public IAlgorithmConfig loadPropertiesFromFile(File file) {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File (" + file.getAbsolutePath() + ") to load properties from does not exist or is not a file.");
        }
        try {
            return this.loadPropertiesFromList(FileUtil.readFileAsList(file));
        }
        catch (IOException e) {
            throw new PropertiesLoadFailedException("Could not load properties from the given file.", e);
        }
    }

    default public IAlgorithmConfig loadPropertiesFromResource(String resourcePath) throws IOException {
        ClassLoader classLoader = FileUtil.class.getClassLoader();
        String content = null;
        try (InputStream inputStream = classLoader.getResourceAsStream(resourcePath);){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            content = result.toString(StandardCharsets.UTF_8.name());
        }
        if (content != null) {
            return this.loadPropertiesFromList(Arrays.asList(content.split("\n")));
        }
        return this;
    }

    default public IAlgorithmConfig loadPropertiesFromList(List<String> propertiesList) {
        for (String line : propertiesList) {
            if (!line.contains("=") || line.startsWith("#")) continue;
            String[] split = line.split("=");
            this.setProperty(split[0].trim(), split[1].trim());
        }
        return this;
    }
}

