/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.AlgorithmState;
import ai.libs.jaicore.basic.algorithm.ExceptionInAlgorithmIterationException;
import ai.libs.jaicore.basic.algorithm.IAlgorithm;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.concurrent.GlobalTimer;
import ai.libs.jaicore.interrupt.Interrupter;
import ai.libs.jaicore.timing.TimedComputation;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAlgorithm<I, O>
implements IAlgorithm<I, O>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(AAlgorithm.class);
    private String loggerName;
    private IAlgorithmConfig config;
    private final I input;
    private long shutdownInitialized = -1L;
    private long activationTime = -1L;
    private String id;
    private long deadline = -1L;
    private long timeOfTimeoutDetection = -1L;
    private long canceled = -1L;
    private final Set<Thread> activeThreads = new HashSet<Thread>();
    private AlgorithmState state = AlgorithmState.created;
    private final EventBus eventBus = new EventBus();
    private int timeoutPrecautionOffset = 100;
    private static final int MIN_RUNTIME_FOR_OBSERVED_TASK = 50;
    private static final String INTERRUPT_NAME_SUFFIX = "-shutdown";

    protected AAlgorithm(I input) {
        this.input = input;
        this.config = (IAlgorithmConfig)ConfigFactory.create(IAlgorithmConfig.class, (Map[])new Map[0]);
    }

    protected AAlgorithm(IAlgorithmConfig config, I input) {
        this.config = config;
        this.input = input;
        if (this.config == null) {
            throw new IllegalArgumentException("Algorithm configuration must not be null!");
        }
    }

    @Override
    public Iterator<AlgorithmEvent> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.state != AlgorithmState.inactive;
    }

    @Override
    public AlgorithmEvent next() {
        try {
            return this.nextWithException();
        }
        catch (Exception e) {
            this.unregisterThreadAndShutdown();
            throw new ExceptionInAlgorithmIterationException(e);
        }
    }

    @Override
    public I getInput() {
        return this.input;
    }

    @Override
    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    @Override
    public int getNumCPUs() {
        return this.getConfig().cpus();
    }

    @Override
    public void setNumCPUs(int numberOfCPUs) {
        this.getConfig().setProperty("cpus", numberOfCPUs + "");
    }

    @Override
    public void setMaxNumThreads(int maxNumberOfThreads) {
        this.getConfig().setProperty("threads", maxNumberOfThreads + "");
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.setTimeout(new TimeOut(timeout, timeUnit));
    }

    @Override
    public void setTimeout(TimeOut timeout) {
        this.logger.info("Setting timeout to {}ms", (Object)timeout.milliseconds());
        this.getConfig().setProperty("timeout", timeout.milliseconds() + "");
    }

    public int getTimeoutPrecautionOffset() {
        return this.timeoutPrecautionOffset;
    }

    public void setTimeoutPrecautionOffset(int timeoutPrecautionOffset) {
        this.timeoutPrecautionOffset = timeoutPrecautionOffset;
    }

    @Override
    public TimeOut getTimeout() {
        return new TimeOut(this.getConfig().timeout(), TimeUnit.MILLISECONDS);
    }

    public boolean isTimeouted() {
        if (this.timeOfTimeoutDetection > 0L) {
            return true;
        }
        if (this.deadline > 0L && System.currentTimeMillis() >= this.deadline) {
            this.timeOfTimeoutDetection = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected TimeOut getRemainingTimeToDeadline() {
        if (this.deadline < 0L) {
            return new TimeOut(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        return new TimeOut(this.deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean isStopCriterionSatisfied() {
        return this.isCanceled() || this.isTimeouted() || Thread.currentThread().isInterrupted();
    }

    public boolean isCanceled() {
        return this.canceled > 0L;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getName() + "-" + System.currentTimeMillis();
        }
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTermination(boolean shutdownOnStoppingCriterion) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.debug("Checking Termination");
        Thread t = Thread.currentThread();
        Interrupter interrupter = Interrupter.get();
        if (t.isInterrupted()) {
            boolean isIntentionalInterrupt;
            Interrupter interrupter2 = interrupter;
            synchronized (interrupter2) {
                this.logger.info("Interruption detected for {}. Resetting interrupted-flag. Now checking whether this was due to a shutdown.", (Object)this.getId());
                Thread.interrupted();
                isIntentionalInterrupt = this.hasThreadBeenInterruptedDuringShutdown(t);
                if (!isIntentionalInterrupt) {
                    this.avoidReinterruptionOnShutdownOnCurrentThread();
                }
            }
            if (isIntentionalInterrupt) {
                this.logger.debug("Thread has been interrupted during shutdown (so we will not throw an InterruptedException). Resolving this interruption cause now.");
                this.resolveShutdownInterruptOnCurrentThread();
                this.logger.debug("Interrupt reason resolved. Now proceeding with termination check, which should end with a timeout or cancellation.");
                assert (this.isTimeouted() || this.isCanceled()) : "If a thread is interrupted during the shutdown, this should be caused by a timeout or a cancel!";
            } else {
                this.logger.debug("The interrupt has not been caused by a shutdown. Will throw an InterruptedException (and maybe previously shutdown if configured so).");
                if (shutdownOnStoppingCriterion) {
                    this.logger.debug("Invoking shutdown");
                    this.unregisterThreadAndShutdown();
                } else {
                    this.logger.debug("Not shutting down, because shutdown-on-stop-criterion has been set to false");
                }
                this.logger.debug("Throwing InterruptedException to communicate the interrupt to the invoker.");
                throw new InterruptedException();
            }
        }
        if (this.isTimeouted()) {
            this.logger.info("Timeout detected for {}", (Object)this.getId());
            if (shutdownOnStoppingCriterion) {
                this.logger.debug("Invoking shutdown");
                this.unregisterThreadAndShutdown();
            } else {
                this.logger.debug("Not shutting down, because shutdown-on-stop-criterion has been set to false");
            }
            this.logger.debug("Throwing TimeoutException");
            throw new AlgorithmTimeoutedException(this.timeOfTimeoutDetection - this.deadline);
        }
        if (this.isCanceled()) {
            this.logger.info("Cancel detected for {}.", (Object)this.getId());
            if (Thread.interrupted()) {
                this.logger.debug("Thread has been interrupted during shutdown. Resetting the flag and not invoking shutdown again.");
            }
            this.logger.debug("Throwing AlgorithmExecutionCanceledException.");
            throw new AlgorithmExecutionCanceledException(System.currentTimeMillis() - this.canceled);
        }
        this.logger.debug("No termination condition observed.");
    }

    protected void checkAndConductTermination() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.checkTermination(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Iterator<AlgorithmEvent> iterator = this;
        synchronized (iterator) {
            if (this.shutdownInitialized > 0L) {
                this.logger.info("Tried to enter shutdown for {}, but the shutdown has already been initialized in the past, so exiting the shutdown block.", (Object)this);
                return;
            }
            this.shutdownInitialized = System.currentTimeMillis();
            this.logger.info("Entering shutdown procedure for {}. Interrupting {} active threads.", (Object)this.getId(), (Object)this.activeThreads.size());
        }
        for (Thread t : this.activeThreads) {
            this.logger.debug("Triggering interrupt on {} as part of shutdown of {}", (Object)t, (Object)this.getId());
            this.interruptThreadAsPartOfShutdown(t);
        }
        this.logger.info("Shutdown of {} completed.", (Object)this.getId());
    }

    protected void interruptThreadAsPartOfShutdown(Thread t) {
        Interrupter.get().interruptThread(t, this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    public boolean hasThreadBeenInterruptedDuringShutdown(Thread t) {
        return Interrupter.get().hasThreadBeenInterruptedWithReason(t, this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    protected void resolveShutdownInterruptOnCurrentThread() throws InterruptedException {
        Interrupter.get().markInterruptOnCurrentThreadAsResolved(this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    protected void avoidReinterruptionOnShutdownOnCurrentThread() {
        Interrupter.get().avoidInterrupt(Thread.currentThread(), this.getId() + INTERRUPT_NAME_SUFFIX);
    }

    public boolean isShutdownInitialized() {
        return this.shutdownInitialized > 0L;
    }

    protected void unregisterThreadAndShutdown() {
        this.unregisterActiveThread();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerActiveThread() {
        if (this.shutdownInitialized > 0L) {
            this.logger.warn("Ignoring registration of thread, because the algorithm has been shutdown already");
            return;
        }
        AAlgorithm aAlgorithm = this;
        synchronized (aAlgorithm) {
            if (this.shutdownInitialized > 0L) {
                this.logger.warn("Ignoring registration of thread, because the algorithm has been shutdown already");
                return;
            }
            this.activeThreads.add(Thread.currentThread());
        }
    }

    protected void unregisterActiveThread() {
        this.logger.trace("Unregistering current thread {}", (Object)Thread.currentThread());
        this.activeThreads.remove(Thread.currentThread());
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public AlgorithmState getState() {
        return this.state;
    }

    protected void setState(AlgorithmState state) {
        if (state == AlgorithmState.active) {
            throw new IllegalArgumentException("Cannot switch state to active. Use \"activate\" instead, which will set the state to active and provide the AlgorithmInitializedEvent.");
        }
        if (state == AlgorithmState.inactive) {
            throw new IllegalArgumentException("Cannot switch state to inactive. Use \"terminate\" instead, which will set the state to inactive and provide the AlgorithmFinishedEvent.");
        }
        this.state = state;
    }

    @Override
    public void cancel() {
        this.logger.info("Received cancel for algorithm {}.", (Object)this.getId());
        if (this.isCanceled()) {
            this.logger.debug("Ignoring cancel command since the algorithm has been canceled before.");
            return;
        }
        this.canceled = System.currentTimeMillis();
        this.logger.info("Cancel flag for {} is set to {}. Now invoke shutdown procedure.", (Object)this.getId(), (Object)this.canceled);
        this.shutdown();
    }

    protected AlgorithmInitializedEvent activate() {
        assert (this.state == AlgorithmState.created) : "Can only activate an algorithm as long as its state has not been changed from CREATED to something else. It is currently " + (Object)((Object)this.state);
        this.activationTime = System.currentTimeMillis();
        if (this.getTimeout().milliseconds() > 0L) {
            this.deadline = this.activationTime + this.getTimeout().milliseconds();
        }
        this.state = AlgorithmState.active;
        AlgorithmInitializedEvent event = new AlgorithmInitializedEvent(this.getId());
        this.eventBus.post((Object)event);
        this.logger.trace("Starting algorithm {} with problem {} and config {}", new Object[]{this.getId(), this.input, this.config});
        return event;
    }

    protected AlgorithmFinishedEvent terminate() {
        this.logger.info("Terminating algorithm {}.", (Object)this.getId());
        this.state = AlgorithmState.inactive;
        AlgorithmFinishedEvent finishedEvent = new AlgorithmFinishedEvent(this.getId());
        this.unregisterThreadAndShutdown();
        this.eventBus.post((Object)finishedEvent);
        return finishedEvent;
    }

    protected void post(Object e) {
        this.eventBus.post(e);
    }

    @Override
    public IAlgorithmConfig getConfig() {
        return this.config;
    }

    public void setConfig(IAlgorithmConfig config) {
        this.config = config;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    protected void announceTimeoutDetected() {
        this.timeOfTimeoutDetection = System.currentTimeMillis();
    }

    protected <T> T computeTimeoutAware(Callable<T> r, String reasonToLogOnTimeout, boolean shutdownOnStoppingCriterionSatisfied) throws InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.debug("Received request to execute {} with awareness of timeout {}. Currently active threads: {}. Currently active tasks in global timer: {}", new Object[]{r, this.getTimeout(), this.activeThreads, GlobalTimer.getInstance().getActiveTasks()});
        if (this.getTimeout().milliseconds() < 0L) {
            try {
                return r.call();
            }
            catch (InterruptedException e) {
                boolean interruptedDueToShutdown = this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread());
                this.logger.info("Received interrupt. Cancel flag is {}. Thread contained in interrupted by shutdown: {}", (Object)this.isCanceled(), (Object)interruptedDueToShutdown);
                if (!interruptedDueToShutdown) {
                    throw e;
                }
                this.checkTermination(shutdownOnStoppingCriterionSatisfied);
                throw new IllegalStateException("Received an interrupt and checked termination, thus, termination routine should have thrown an exception which it apparently did not!");
            }
            catch (AlgorithmExecutionCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AlgorithmException(e, "The algorithm has failed due to an exception of a Callable.");
            }
        }
        long remainingTime = this.getRemainingTimeToDeadline().milliseconds();
        if (remainingTime < (long)(this.timeoutPrecautionOffset + 50)) {
            this.logger.debug("Only {}ms left, which is not enough to reliably continue computation. Terminating algorithm at this point, throwing an AlgorithmTimeoutedException.", (Object)remainingTime);
            this.announceTimeoutDetected();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
        }
        try {
            return TimedComputation.compute(r, remainingTime - (long)this.timeoutPrecautionOffset, reasonToLogOnTimeout);
        }
        catch (AlgorithmTimeoutedException e) {
            this.logger.debug("TimedComputation has been timeouted. Setting the TimeoutDetection flag to now. Remaining time is {}ms.", (Object)this.getRemainingTimeToDeadline().milliseconds());
            this.timeOfTimeoutDetection = System.currentTimeMillis();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
            throw new IllegalStateException("The flag for timeout detection has been set, but checkTermination did not throw an exception!");
        }
        catch (InterruptedException e) {
            this.logger.info("Received interrupt for {} during timed computation. Cancel flag is {}", (Object)this.getId(), (Object)this.isCanceled());
            assert (!Thread.currentThread().isInterrupted()) : "By java convention, the thread should not be interrupted when an InterruptedException is thrown.";
            boolean interruptedDueToShutdown = this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread());
            if (!interruptedDueToShutdown) {
                throw e;
            }
            this.resolveShutdownInterruptOnCurrentThread();
            this.checkTermination(shutdownOnStoppingCriterionSatisfied);
            throw new IllegalStateException("A stopping criterion must have been true (probably cancel), but checkTermination did not throw an exception!");
        }
        catch (ExecutionException e) {
            throw new AlgorithmException(e, "The algorithm has failed due to an exception of Callable " + r + " with timeout log message " + reasonToLogOnTimeout);
        }
    }
}

