/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.basic.kvstore.ESignificanceTestResult;
import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.basic.kvstore.KVStoreCollectionPartition;
import ai.libs.jaicore.basic.kvstore.TwoLayerKVStoreCollectionPartition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStoreStatisticsUtil {
    private static final Logger logger = LoggerFactory.getLogger(KVStoreStatisticsUtil.class);
    private static final String DEFAULT_OUTPUT_BEST = "best";
    private static final String DEFAULT_OUTPUT_RANK = "rank";

    private KVStoreStatisticsUtil() {
    }

    public static void best(KVStoreCollection collection, String setting, String sampleID, String sampledValues) {
        KVStoreStatisticsUtil.best(collection, setting, sampleID, sampledValues, DEFAULT_OUTPUT_BEST);
    }

    public static void rank(KVStoreCollection collection, String setting, String sampleID, String sampledValues) {
        KVStoreStatisticsUtil.rank(collection, setting, sampleID, sampledValues, DEFAULT_OUTPUT_RANK);
    }

    public static void rank(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output) {
        KVStoreStatisticsUtil.rank(collection, setting, sampleID, sampledValues, output, true);
    }

    public static void rank(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output, boolean minimize) {
        KVStoreCollection grouped = new KVStoreCollection(collection);
        grouped.group(setting, sampleID);
        TwoLayerKVStoreCollectionPartition partition = new TwoLayerKVStoreCollectionPartition(setting, sampleID, grouped);
        for (Map.Entry<String, Map<String, KVStoreCollection>> partitionEntry : partition) {
            LinkedList competitorList = new LinkedList();
            partitionEntry.getValue().values().stream().map(x -> (KVStore)x.get(0)).forEach(competitorList::add);
            Collections.sort(competitorList, (o1, o2) -> minimize ? Double.compare(StatisticsUtil.mean(o1.getAsDoubleList(sampledValues)), StatisticsUtil.mean(o2.getAsDoubleList(sampledValues))) : Double.compare(StatisticsUtil.mean(o2.getAsDoubleList(sampledValues)), StatisticsUtil.mean(o1.getAsDoubleList(sampledValues))));
            for (int i = 0; i < competitorList.size(); ++i) {
                ((KVStore)competitorList.get(i)).put(output, i + 1);
            }
        }
    }

    public static void best(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output, boolean minimize) {
        Set<String> availableSampleIDs = collection.stream().map(x -> x.getAsString(sampleID)).collect(Collectors.toSet());
        KVStoreStatisticsUtil.best(collection, setting, sampleID, sampledValues, availableSampleIDs, output, minimize);
    }

    public static void best(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output) {
        KVStoreStatisticsUtil.best(collection, setting, sampleID, sampledValues, output, true);
    }

    public static void best(KVStoreCollection collection, String setting, String sampleID, String sampledValues, Set<String> sampleIDsToConsider, String output, boolean minimize) {
        KVStoreCollection grouped = new KVStoreCollection(collection);
        grouped.group(setting, sampleID);
        KVStoreCollectionPartition partition = new KVStoreCollectionPartition(setting, collection);
        for (Map.Entry<String, KVStoreCollection> entry : partition) {
            OptionalDouble bestValue = minimize ? entry.getValue().stream().filter(x -> sampleIDsToConsider.contains(x.getAsString(sampleID))).mapToDouble(x -> x.get(sampledValues) != null ? StatisticsUtil.mean(x.getAsDoubleList(sampledValues)) : Double.MAX_VALUE).min() : entry.getValue().stream().filter(x -> sampleIDsToConsider.contains(x.getAsString(sampleID))).mapToDouble(x -> x.get(sampledValues) != null ? StatisticsUtil.mean(x.getAsDoubleList(sampledValues)) : Double.MIN_VALUE).max();
            if (!bestValue.isPresent()) continue;
            double best = bestValue.getAsDouble();
            for (KVStore store : entry.getValue()) {
                if (store.get(sampledValues) != null) {
                    store.put(output, StatisticsUtil.mean(store.getAsDoubleList(sampledValues)) == best);
                    continue;
                }
                Double surrogateValue = Double.MIN_VALUE;
                if (minimize) {
                    surrogateValue = Double.MAX_VALUE;
                }
                store.put(output, surrogateValue == best);
            }
        }
    }

    public static KVStoreCollection wilcoxonSignedRankTest(KVStoreCollection collection, String setting, String sampleIDs, String pairingIndex, String sampledValues, String nameOfTestPopulation, String output) {
        KVStoreCollection groupedCollection = new KVStoreCollection(collection);
        groupedCollection.group(setting, sampleIDs);
        TwoLayerKVStoreCollectionPartition settingAndSampleWisePartition = new TwoLayerKVStoreCollectionPartition(setting, sampleIDs, groupedCollection);
        for (Map.Entry<String, Map<String, KVStoreCollection>> settingToSampleWisePartition : settingAndSampleWisePartition) {
            KVStore onesStore = (KVStore)settingToSampleWisePartition.getValue().get(nameOfTestPopulation).get(0);
            if (onesStore == null) continue;
            onesStore.put(output, ESignificanceTestResult.TIE);
            Map<String, Double> sampleMapOfOne = KVStoreStatisticsUtil.toSampleMap(onesStore.getAsStringList(pairingIndex, ","), onesStore.getAsDoubleList(sampledValues, ","));
            for (Map.Entry<String, KVStoreCollection> sampleData : settingToSampleWisePartition.getValue().entrySet()) {
                if (sampleData.getKey().equals(nameOfTestPopulation)) continue;
                KVStore otherStore = (KVStore)sampleData.getValue().get(0);
                Map<String, Double> sampleMapOfOther = KVStoreStatisticsUtil.toSampleMap(otherStore.getAsStringList(pairingIndex, ","), otherStore.getAsDoubleList(sampledValues, ","));
                HashSet<String> mergedSampleIDs = new HashSet<String>(sampleMapOfOne.keySet());
                mergedSampleIDs.addAll(sampleMapOfOther.keySet());
                double[] one = new double[mergedSampleIDs.size()];
                double[] other = new double[mergedSampleIDs.size()];
                double meanOne = 0.0;
                double meanOther = 0.0;
                int counter = 0;
                for (String sampleID : mergedSampleIDs) {
                    if (sampleMapOfOne.containsKey(sampleID)) {
                        one[counter] = sampleMapOfOne.get(sampleID);
                        meanOne += one[counter] / (double)sampleMapOfOne.size();
                    } else {
                        one[counter] = Double.NaN;
                    }
                    if (sampleMapOfOther.containsKey(sampleID)) {
                        other[counter] = sampleMapOfOther.get(sampleID);
                        meanOther += other[counter] / (double)sampleMapOfOther.size();
                    } else {
                        other[counter] = Double.NaN;
                    }
                    ++counter;
                }
                if (StatisticsUtil.wilcoxonSignedRankSumTestTwoSided(one, other)) {
                    if (meanOne < meanOther) {
                        otherStore.put(output, ESignificanceTestResult.INFERIOR);
                        continue;
                    }
                    otherStore.put(output, ESignificanceTestResult.SUPERIOR);
                    continue;
                }
                otherStore.put(output, ESignificanceTestResult.TIE);
            }
        }
        return groupedCollection;
    }

    public static void mannWhitneyU(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String nameOfTestPopulation, String output) {
        for (Map.Entry<String, Map<String, KVStoreCollection>> settingWiseEntry : KVStoreStatisticsUtil.prepareGroupedTwoLayerPartition(collection, setting, sampleID)) {
            KVStoreCollection testPopulation = settingWiseEntry.getValue().get(nameOfTestPopulation);
            if (testPopulation == null || testPopulation.isEmpty()) continue;
            ((KVStore)testPopulation.get(0)).put(output, ESignificanceTestResult.TIE);
            List<Double> testValues = ((KVStore)testPopulation.get(0)).getAsDoubleList(sampledValues);
            for (Map.Entry<String, KVStoreCollection> otherEntry : settingWiseEntry.getValue().entrySet()) {
                if (otherEntry.getKey().equals(nameOfTestPopulation)) continue;
                KVStore otherStore = (KVStore)otherEntry.getValue().get(0);
                List<Double> otherValues = otherStore.getAsDoubleList(sampledValues);
                KVStoreStatisticsUtil.annotateSigTestResult(otherStore, output, StatisticsUtil.mannWhitneyTwoSidedSignificance(testValues, otherValues), StatisticsUtil.mean(otherValues), StatisticsUtil.mean(testValues));
            }
        }
    }

    public static void bestTTest(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output) {
        String bestOutput = output + "_best";
        KVStoreStatisticsUtil.best(collection, setting, sampleID, sampledValues, bestOutput);
        TwoLayerKVStoreCollectionPartition partition = new TwoLayerKVStoreCollectionPartition(setting, sampleID, collection);
        for (Map.Entry<String, Map<String, KVStoreCollection>> partitionEntry : partition) {
            Optional<Map.Entry> best = partitionEntry.getValue().entrySet().stream().filter(x -> ((KVStore)((KVStoreCollection)x.getValue()).get(0)).getAsBoolean(bestOutput)).findFirst();
            if (best.isPresent()) {
                KVStoreCollection merged = new KVStoreCollection();
                partitionEntry.getValue().values().forEach(merged::addAll);
                KVStoreStatisticsUtil.tTest(merged, setting, sampleID, sampledValues, ((KVStore)((KVStoreCollection)best.get().getValue()).get(0)).getAsString(sampleID), output);
                continue;
            }
            logger.warn("No best population available for setting {}", (Object)partitionEntry.getKey());
        }
    }

    public static void tTest(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String nameOfTestPopulation, String output) {
        KVStoreCollection grouped = new KVStoreCollection(collection);
        grouped.group(setting, sampleID);
        TwoLayerKVStoreCollectionPartition partition = new TwoLayerKVStoreCollectionPartition(setting, sampleID, grouped);
        for (Map.Entry<String, Map<String, KVStoreCollection>> partitionEntry : partition) {
            KVStoreCollection testCollection = partitionEntry.getValue().get(nameOfTestPopulation);
            if (testCollection == null || testCollection.isEmpty()) continue;
            KVStore testStore = (KVStore)testCollection.get(0);
            double testMean = StatisticsUtil.mean(testStore.getAsDoubleList(sampledValues));
            KVStoreStatisticsUtil.annotateSigTestResult(testStore, output, false, 0.0, 0.0);
            for (Map.Entry<String, KVStoreCollection> comparedEntry : partitionEntry.getValue().entrySet()) {
                if (comparedEntry.getKey().equals(nameOfTestPopulation) || comparedEntry.getValue().isEmpty()) continue;
                KVStore otherStore = (KVStore)comparedEntry.getValue().get(0);
                KVStoreStatisticsUtil.annotateSigTestResult(otherStore, output, StatisticsUtil.twoSampleTTestSignificance(testStore.getAsDoubleList(sampledValues), otherStore.getAsDoubleList(sampledValues)), StatisticsUtil.mean(otherStore.getAsDoubleList(sampledValues)), testMean);
            }
        }
    }

    public static void bestFilter(KVStoreCollection collection, String setting, String sampleID, String sampledValues) {
        KVStoreStatisticsUtil.bestFilter(collection, setting, sampleID, sampledValues, DEFAULT_OUTPUT_BEST);
    }

    public static void bestFilter(KVStoreCollection collection, String setting, String sampleID, String sampledValues, String output) {
        KVStoreStatisticsUtil.best(collection, setting, sampleID, sampledValues, output);
        ArrayList distinctTasks = new ArrayList();
        HashSet consideredKeys = new HashSet();
        collection.forEach(t -> {
            String keyValue = t.getAsString(setting);
            if (!consideredKeys.contains(keyValue) && t.getAsBoolean(output).booleanValue()) {
                consideredKeys.add(keyValue);
                distinctTasks.add(t);
            }
        });
        collection.clear();
        collection.addAll(distinctTasks);
    }

    private static TwoLayerKVStoreCollectionPartition prepareGroupedTwoLayerPartition(KVStoreCollection collection, String firstLayerKey, String secondLayerKey) {
        KVStoreCollection copy = new KVStoreCollection(collection);
        copy.group(firstLayerKey, secondLayerKey);
        return new TwoLayerKVStoreCollectionPartition(firstLayerKey, secondLayerKey, copy);
    }

    private static void annotateSigTestResult(KVStore storeToAnnotate, String output, boolean sig, double meanOfStore, double meanOfCompared) {
        if (sig) {
            if (meanOfStore < meanOfCompared) {
                storeToAnnotate.put(output, ESignificanceTestResult.SUPERIOR);
            } else {
                storeToAnnotate.put(output, ESignificanceTestResult.INFERIOR);
            }
        } else {
            storeToAnnotate.put(output, ESignificanceTestResult.TIE);
        }
    }

    private static Map<String, Double> toSampleMap(List<String> pairingIndices, List<Double> sampledValues) {
        if (pairingIndices.size() != sampledValues.size()) {
            throw new IllegalArgumentException("Number of sample ids deviates from number of sampled values");
        }
        HashMap<String, Double> sampleMap = new HashMap<String, Double>();
        for (int i = 0; i < pairingIndices.size(); ++i) {
            sampleMap.put(pairingIndices.get(i), sampledValues.get(i));
        }
        return sampleMap;
    }

    public static Map<String, DescriptiveStatistics> averageRank(KVStoreCollection groupedAll, String sampleIDs, String rank) {
        HashMap<String, DescriptiveStatistics> averageRanks = new HashMap<String, DescriptiveStatistics>();
        for (KVStore s : groupedAll) {
            DescriptiveStatistics stats = (DescriptiveStatistics)averageRanks.get(s.getAsString(sampleIDs));
            if (stats == null) {
                stats = new DescriptiveStatistics();
                averageRanks.put(s.getAsString(sampleIDs), stats);
            }
            stats.addValue(s.getAsDouble(rank).doubleValue());
        }
        return averageRanks;
    }
}

