/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.SQLAdapter;
import ai.libs.jaicore.basic.ValueUtil;
import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.basic.kvstore.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KVStoreUtil {
    public static String kvStoreCollectionToLaTeXTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex) {
        StringBuilder sb = new StringBuilder();
        Table<String> table = new Table<String>();
        for (KVStore store : kvStoreCollection) {
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            String tableEntry = ValueUtil.valueToString(store.getAsDouble("meanAccuracy"), 2) + "+-" + ValueUtil.valueToString(store.getAsDouble("stdAccuracy"), 2);
            table.add(columnValue, rowValue, tableEntry);
        }
        sb.append(table.toLaTeX());
        return sb.toString();
    }

    public static String kvStoreCollectionToLaTeXTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting) {
        StringBuilder sb = new StringBuilder();
        Table<String> table = new Table<String>();
        for (KVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey(cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        sb.append(table.toLaTeX());
        return sb.toString();
    }

    public static String kvStoreCollectionToLaTeXTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String missingEntry) {
        StringBuilder sb = new StringBuilder();
        Table<String> table = new Table<String>();
        for (KVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey(cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        sb.append(table.toLaTeX(missingEntry));
        return sb.toString();
    }

    public static String kvStoreCollectionToCSVTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String standardValue) {
        StringBuilder sb = new StringBuilder();
        Table<String> table = new Table<String>();
        for (KVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey(cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        sb.append(table.toCSV(standardValue));
        return sb.toString();
    }

    public static Table<String> kvStoreCollectionToTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String standardValue) {
        Table<String> table = new Table<String>();
        for (KVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey(cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        return table;
    }

    public static KVStoreCollection readFromCSVWithHeader(File csvFile, Map<String, String> commonFields) throws IOException {
        return KVStoreUtil.readFromCSVWithHeader(csvFile, commonFields, ";");
    }

    public static KVStoreCollection readFromCSVWithHeader(File csvFile, Map<String, String> commonFields, String separator) throws IOException {
        KVStoreCollection kvStoreCollection = new KVStoreCollection();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            boolean first = true;
            String[] columns = new String[]{};
            while ((line = br.readLine()) != null) {
                if (KVStoreUtil.skipLine(line)) continue;
                if (first) {
                    first = false;
                    columns = line.split(separator);
                    continue;
                }
                KVStore t = KVStoreUtil.readLine(columns, line, separator);
                for (Map.Entry<String, String> commonEntry : commonFields.entrySet()) {
                    t.put(commonEntry.getKey(), commonEntry.getValue());
                }
                t.setCollection(kvStoreCollection);
                kvStoreCollection.add(t);
            }
        }
        return kvStoreCollection;
    }

    public static KVStoreCollection readFromCSV(String[] columns, File csvFile, Map<String, String> commonFields) throws IOException {
        return KVStoreUtil.readFromCSV(columns, csvFile, commonFields, ";");
    }

    public static KVStoreCollection readFromCSV(String[] columns, File csvFile, Map<String, String> commonFields, String separator) throws IOException {
        KVStoreCollection kvStoreCollection = new KVStoreCollection();
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (KVStoreUtil.skipLine(line)) continue;
                KVStore t = KVStoreUtil.readLine(columns, line, separator);
                for (Map.Entry<String, String> commonEntry : commonFields.entrySet()) {
                    t.put(commonEntry.getKey(), commonEntry.getValue());
                }
                t.setCollection(kvStoreCollection);
                kvStoreCollection.add(t);
            }
        }
        return kvStoreCollection;
    }

    private static KVStore readLine(String[] columns, String line, String separator) {
        String[] lineSplit = line.split(separator);
        if (lineSplit.length != columns.length) {
            throw new IllegalArgumentException("Malformed line in csv file: Number of column heads " + columns.length + " Number of columns in line: " + lineSplit.length + " " + line);
        }
        KVStore t = new KVStore();
        for (int i = 0; i < columns.length; ++i) {
            t.put(columns[i], lineSplit[i]);
        }
        return t;
    }

    private static boolean skipLine(String line) {
        return line.trim().equals("") || line.trim().startsWith("#");
    }

    public static KVStoreCollection readFromMySQLResultSet(ResultSet rs, Map<String, String> commonFields) throws Exception {
        KVStoreCollection kvStoreCollection = new KVStoreCollection();
        int n = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            KVStore t = new KVStore();
            t.setCollection(kvStoreCollection);
            for (int i = 1; i <= n; ++i) {
                t.put(rs.getMetaData().getColumnLabel(i), rs.getString(i));
                for (Map.Entry<String, String> commonEntry : commonFields.entrySet()) {
                    t.put(commonEntry.getKey(), commonEntry.getValue());
                }
            }
            kvStoreCollection.add(t);
        }
        return kvStoreCollection;
    }

    public static KVStoreCollection readFromMySQLTable(SQLAdapter adapter, String table, Map<String, String> commonFields) throws Exception {
        return KVStoreUtil.readFromMySQLResultSet(adapter.getRowsOfTable(table), commonFields);
    }
}

