/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.RelationComputationProblem;
import ai.libs.jaicore.basic.sets.TupleOfCartesianProductFoundEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Predicate;

public class LDSRelationComputer<T>
extends AAlgorithm<RelationComputationProblem<T>, List<List<T>>> {
    private final List<List<T>> sets;
    private final int numSets;
    private final Predicate<List<T>> prefixFilter;
    private int computedTuples = 0;
    private final List<T> currentTuple;
    private Queue<Node> open = new PriorityQueue<Node>((n1, n2) -> n1.defficiency - n2.defficiency);
    private List<Node> recycledNodes = new ArrayList<Node>();
    private int numRecycledNodes;
    private int numCreatedNodes;

    public LDSRelationComputer(List<Collection<T>> sets) {
        this(new RelationComputationProblem<T>(sets));
    }

    public LDSRelationComputer(RelationComputationProblem<T> problem) {
        super(problem);
        this.sets = new ArrayList<List<T>>();
        for (Collection<T> set : problem.getSets()) {
            this.sets.add(set instanceof List ? (List<Object>)set : new ArrayList<T>(set));
        }
        this.numSets = this.sets.size();
        this.prefixFilter = problem.getPrefixFilter();
        this.currentTuple = new ArrayList<T>();
    }

    @Override
    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case created: {
                this.open.add(new Node(null, -1, 0, 0));
                ++this.numCreatedNodes;
                return this.activate();
            }
            case active: {
                this.checkAndConductTermination();
                if (this.open.isEmpty()) {
                    return this.terminate();
                }
                Node next = null;
                while (!this.open.isEmpty()) {
                    next = this.open.poll();
                    if (next.indexOfSet >= this.numSets - 1) break;
                    int i = 0;
                    int setIndex = next.indexOfSet + 1;
                    List<T> set = this.sets.get(setIndex);
                    int n = set.size();
                    next.fillTupleArrayWithValues(this.currentTuple);
                    for (int j = 0; j < n; ++j) {
                        this.checkAndConductTermination();
                        long innerTimePoint = System.currentTimeMillis();
                        this.currentTuple.add(set.get(j));
                        assert (System.currentTimeMillis() - innerTimePoint < 5L) : "Copying the " + next.indexOfSet + "-tuple " + this.currentTuple + " took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!";
                        innerTimePoint = System.currentTimeMillis();
                        boolean adopt = this.prefixFilter.test(this.currentTuple);
                        assert (System.currentTimeMillis() - innerTimePoint < 1000L) : "Testing the " + next.indexOfSet + "-tuple " + this.currentTuple + " took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!";
                        if (adopt) {
                            Node newNode;
                            innerTimePoint = System.currentTimeMillis();
                            if (this.recycledNodes.isEmpty()) {
                                newNode = new Node();
                                ++this.numCreatedNodes;
                                assert (System.currentTimeMillis() - innerTimePoint < 5000L) : "Creating a new node took " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!\n" + this.computedTuples + " tuples have been computed already.\nRecycling list contains " + this.recycledNodes.size() + "\nOPEN contains " + this.open.size();
                            } else {
                                newNode = this.recycledNodes.remove(0);
                                assert (System.currentTimeMillis() - innerTimePoint < 10L) : "Retrieving node from recycle list " + (System.currentTimeMillis() - innerTimePoint) + "ms, which is way too much!\n" + this.computedTuples + " tuples have been computed already.\nRecycling list contains " + this.recycledNodes.size() + "\nOPEN contains " + this.open.size();
                            }
                            newNode.parent = next;
                            newNode.indexOfSet = next.indexOfSet + 1;
                            newNode.defficiency = next.defficiency + i++;
                            newNode.indexOfValue = j;
                            this.open.add(newNode);
                        }
                        this.currentTuple.remove(setIndex);
                    }
                }
                if (next == null || next.indexOfSet < this.sets.size() - 1) {
                    return this.terminate();
                }
                ++this.computedTuples;
                next.fillTupleArrayWithValues(this.currentTuple);
                next.recycle();
                ++this.numRecycledNodes;
                ArrayList<T> tuple = new ArrayList<T>(this.currentTuple);
                assert (this.currentTuple.size() == this.numSets) : "Tuple " + this.currentTuple + " should contain " + this.numSets + " elements but has " + this.currentTuple.size();
                return new TupleOfCartesianProductFoundEvent<T>(this.getId(), tuple);
            }
        }
        throw new IllegalStateException();
    }

    public List<T> nextTuple() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        while (this.hasNext()) {
            AlgorithmEvent e = this.nextWithException();
            if (e instanceof AlgorithmFinishedEvent) {
                return null;
            }
            if (e instanceof TupleOfCartesianProductFoundEvent) {
                return ((TupleOfCartesianProductFoundEvent)e).getTuple();
            }
            if (e instanceof AlgorithmInitializedEvent) continue;
            throw new IllegalStateException("Cannot handle event of type " + e.getClass());
        }
        throw new IllegalStateException("No more elements but no AlgorithmFinishedEvent was generated!");
    }

    @Override
    public List<List<T>> call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        List<T> nextTuple;
        ArrayList<List<T>> product = new ArrayList<List<T>>();
        while ((nextTuple = this.nextTuple()) != null) {
            product.add(nextTuple);
        }
        return product;
    }

    public int getNumRecycledNodes() {
        return this.numRecycledNodes;
    }

    public int getNumCreatedNodes() {
        return this.numCreatedNodes;
    }

    private class Node {
        Node parent;
        int defficiency;
        int indexOfSet;
        int indexOfValue;

        public Node() {
        }

        public Node(Node parent, int indexOfSet, int defficiency, int indexInSet) {
            long start = System.currentTimeMillis();
            this.parent = parent;
            this.indexOfSet = indexOfSet;
            this.defficiency = defficiency;
            this.indexOfValue = indexInSet;
            assert (System.currentTimeMillis() - start <= 1L) : "Constructor execution took more than 1ms: " + (System.currentTimeMillis() - start) + "ms";
        }

        public void fillTupleArrayWithValues(List<T> tupleArray) {
            tupleArray.clear();
            this.fillTupleArrayWithValuesRec(tupleArray);
        }

        private void fillTupleArrayWithValuesRec(List<T> tupleArray) {
            if (this.parent == null) {
                return;
            }
            tupleArray.add(0, this.getObject());
            this.parent.fillTupleArrayWithValuesRec(tupleArray);
        }

        T getObject() {
            return ((List)LDSRelationComputer.this.sets.get(this.indexOfSet)).get(this.indexOfValue);
        }

        public void recycle() {
            if (this.indexOfSet >= LDSRelationComputer.this.numSets) {
                LDSRelationComputer.this.recycledNodes.add(this);
            }
        }
    }
}

