/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.sets.ElementDecorator;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListDecorator<L extends List<E>, E, D extends ElementDecorator<E>>
implements List<D> {
    private final L list;
    private final Class<E> typeOfDecoratedItems = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    private final Class<D> typeOfDecoratingItems = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
    private final Constructor<D> constructorForDecoratedItems;

    public ListDecorator(L list) {
        this.list = list;
        Constructor<D> constructorForDecoratedItems = null;
        try {
            constructorForDecoratedItems = this.typeOfDecoratingItems.getConstructor(this.typeOfDecoratedItems);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.constructorForDecoratedItems = constructorForDecoratedItems;
    }

    private D getDecorationForElement(E element) {
        try {
            return (D)((ElementDecorator)this.constructorForDecoratedItems.newInstance(element));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean add(D e) {
        return this.list.add(((ElementDecorator)e).getElement());
    }

    @Override
    public void add(int index, D element) {
        this.list.add(index, ((ElementDecorator)element).getElement());
    }

    @Override
    public boolean addAll(Collection<? extends D> c) {
        if (c == null) {
            throw new IllegalArgumentException("Cannot add NULL collection to list.");
        }
        boolean allSuccessfull = true;
        for (ElementDecorator e : c) {
            if (this.list.add(e.getElement())) continue;
            allSuccessfull = false;
        }
        return allSuccessfull;
    }

    @Override
    public boolean addAll(int index, Collection<? extends D> c) {
        int sizeBefore = this.list.size();
        for (ElementDecorator e : c) {
            this.list.add(index++, e.getElement());
        }
        return sizeBefore + c.size() == this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.typeOfDecoratingItems.isInstance(o) && this.list.contains(((ElementDecorator)o).getElement());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public D get(int index) {
        return this.getDecorationForElement(this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.typeOfDecoratingItems.isInstance(o) ? this.list.indexOf(((ElementDecorator)o).getElement()) : -1;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<D> iterator() {
        return new Iterator<D>(){
            Iterator<E> internalIterator;
            {
                this.internalIterator = ListDecorator.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public D next() {
                return ListDecorator.this.getDecorationForElement(this.internalIterator.next());
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.typeOfDecoratingItems.isInstance(o) ? this.list.lastIndexOf(((ElementDecorator)o).getElement()) : -1;
    }

    @Override
    public ListIterator<D> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<D> listIterator(final int index) {
        return new ListIterator<D>(){
            ListIterator<E> internalIterator;
            {
                this.internalIterator = ListDecorator.this.list.listIterator(index);
            }

            @Override
            public void add(D arg0) {
                this.internalIterator.add(((ElementDecorator)arg0).getElement());
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.internalIterator.hasPrevious();
            }

            @Override
            public D next() {
                return ListDecorator.this.getDecorationForElement(this.internalIterator.next());
            }

            @Override
            public int nextIndex() {
                return this.internalIterator.nextIndex();
            }

            @Override
            public D previous() {
                return ListDecorator.this.getDecorationForElement(this.internalIterator.previous());
            }

            @Override
            public int previousIndex() {
                return this.internalIterator.previousIndex();
            }

            @Override
            public void remove() {
                this.internalIterator.remove();
            }

            @Override
            public void set(D arg0) {
                this.internalIterator.set(((ElementDecorator)arg0).getElement());
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.typeOfDecoratingItems.isInstance(o) ? this.list.remove(((ElementDecorator)o).getElement()) : false;
    }

    @Override
    public D remove(int index) {
        return this.getDecorationForElement(this.list.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.list.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (int i = 0; i < this.list.size(); ++i) {
            D construct = this.getDecorationForElement(this.list.get(i));
            if (c.contains(construct)) continue;
            this.list.remove(i);
            --i;
            changed = true;
        }
        return changed;
    }

    @Override
    public D set(int index, D element) {
        return this.getDecorationForElement(this.list.set(index, ((ElementDecorator)element).getElement()));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<D> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] arrayOfInternals = this.list.toArray();
        Object[] array = new Object[arrayOfInternals.length];
        for (int i = 0; i < arrayOfInternals.length; ++i) {
            array[i] = this.getDecorationForElement(arrayOfInternals[i]);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] arrayOfInternals = this.list.toArray();
        Object[] array = (Object[])Array.newInstance(a.getClass().getComponentType(), arrayOfInternals.length);
        for (int i = 0; i < arrayOfInternals.length; ++i) {
            array[i] = this.getDecorationForElement(arrayOfInternals[i]);
        }
        return array;
    }

    public L getList() {
        return this.list;
    }
}

