/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PartialOrderedSet<E>
extends HashSet<E> {
    private final Map<E, Set<E>> order = new HashMap<E, Set<E>>();

    public PartialOrderedSet(PartialOrderedSet<E> original) {
        super(original);
        original.order.forEach((? super K k, ? super V v) -> {
            Set cfr_ignored_0 = this.order.put(k, new HashSet(v));
        });
    }

    public PartialOrderedSet() {
    }

    public void addABeforeB(E a, E b) {
        Set<E> directlyAfterA;
        if (!this.allowsABeforeB(a, b)) {
            throw new IllegalStateException("By transitivity " + a + " before " + b + "isn't allowed.");
        }
        if (!this.contains(a)) {
            this.add(a);
        }
        if (!this.contains(b)) {
            this.add(b);
        }
        if ((directlyAfterA = this.order.get(a)) == null) {
            directlyAfterA = new HashSet();
            this.order.put(a, directlyAfterA);
        }
        directlyAfterA.add(b);
    }

    public void requireABeforeB(E a, E b) {
        if (!this.allowsABeforeB(a, b)) {
            throw new IllegalStateException("By transitivity " + a + " before " + b + "isn't allowed.");
        }
        Set<E> directlyAfterA = this.order.get(a);
        if (directlyAfterA == null) {
            directlyAfterA = new HashSet();
            this.order.put(a, directlyAfterA);
        }
        directlyAfterA.add(b);
    }

    public boolean allowsABeforeB(E a, E b) {
        Set<E> transitiveClosure = this.getTransitiveClosure(b);
        return !transitiveClosure.contains(a);
    }

    public boolean isADirectlyBeforeB(E a, E b) {
        Set<E> directlyAfterA = this.order.get(a);
        if (directlyAfterA != null) {
            return directlyAfterA.contains(b);
        }
        return false;
    }

    public Set<E> getTransitiveClosure(E e) {
        if (e == null) {
            throw new NullPointerException("'e' mustn't be null.");
        }
        HashSet<E> set = new HashSet<E>();
        set.add(e);
        return this.getTransitiveClosure(set);
    }

    public Set<E> getTransitiveClosure(Set<E> subSet) {
        if (subSet == null) {
            throw new NullPointerException("subSet mustn't be null.");
        }
        HashSet<E> transitiveClosure = new HashSet<E>(subSet);
        for (E e : subSet) {
            Set<E> directlyAfterE = this.order.get(e);
            if (directlyAfterE == null) continue;
            transitiveClosure.addAll(directlyAfterE);
        }
        if (subSet.containsAll(transitiveClosure)) {
            return transitiveClosure;
        }
        return this.getTransitiveClosure(transitiveClosure);
    }

    public boolean isReflexive() {
        for (E e : this) {
            if (!this.order.containsKey(e)) {
                return false;
            }
            if (this.order.get(e).contains(e)) continue;
            return false;
        }
        return true;
    }

    public List<E> getTotalOrder() {
        LinkedList<E> list = new LinkedList<E>();
        for (E element : this) {
            Set<E> followingElements = this.order.get(element);
            int index = list.size();
            if (followingElements != null) {
                for (E followingElement : followingElements) {
                    int followingIndex = list.indexOf(followingElement);
                    if (followingIndex == -1 || followingIndex >= index) continue;
                    index = followingIndex;
                }
            }
            list.add(index, element);
        }
        return list;
    }

    public void merge(PartialOrderedSet<? extends E> set) {
        super.addAll(set);
        PartialOrderedSet<? extends E> tmpSet = set;
        tmpSet.order.forEach((? super K k, ? super V vSet) -> vSet.forEach(v -> this.addABeforeB(k, v)));
    }

    public void addAll(PartialOrderedSet<? extends E> set) {
        this.merge(set);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("} with order ");
        it = this.order.keySet().iterator();
        while (it.hasNext()) {
            E e = it.next();
            Set<E> diretclyAfterE = this.order.get(e);
            Iterator<E> innerIt = diretclyAfterE.iterator();
            while (innerIt.hasNext()) {
                sb.append(e.toString());
                sb.append(" < ");
                sb.append(innerIt.next().toString());
                if (!innerIt.hasNext()) continue;
                sb.append(", ");
            }
            if (!it.hasNext()) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public List<E> getLinearization() {
        ArrayList elements = new ArrayList();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        ArrayList linearization = new ArrayList();
        HashMap<E, Set<E>> workingCopyOfOrder = new HashMap<E, Set<E>>(this.order);
        HashSet itemsWithoutSuccessor = new HashSet(SetUtil.difference(elements, workingCopyOfOrder.keySet()));
        HashSet uninsertedItems = new HashSet(elements);
        while (!itemsWithoutSuccessor.isEmpty()) {
            ArrayList itemsToInsert = new ArrayList(itemsWithoutSuccessor);
            itemsWithoutSuccessor.clear();
            for (Object itemToInsert : itemsToInsert) {
                if (linearization.contains(itemToInsert)) continue;
                assert (!linearization.contains(itemToInsert)) : "The object " + itemToInsert + " is already contained in the linearization " + linearization;
                linearization.add(0, itemToInsert);
                uninsertedItems.remove(itemToInsert);
                for (Object uninsertedItem : uninsertedItems) {
                    if (!workingCopyOfOrder.containsKey(uninsertedItem)) continue;
                    ((Set)workingCopyOfOrder.get(uninsertedItem)).remove(itemToInsert);
                    if (!((Set)workingCopyOfOrder.get(uninsertedItem)).isEmpty()) continue;
                    itemsWithoutSuccessor.add(uninsertedItem);
                }
            }
        }
        assert (linearization.size() == super.size()) : "The linearization of " + elements + " has produced another number of elements: " + ((Object)linearization).toString();
        return linearization;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getLinearization().iterator();
    }

    @Override
    public void clear() {
        super.clear();
        this.order.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.order.remove(o);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<E> it = this.order.keySet().iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            it.remove();
        }
        return super.retainAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        for (E next : this.order.keySet()) {
            if (!filter.test(next)) continue;
            this.remove(next);
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean remove(Object e) {
        this.order.remove(e);
        return super.remove(e);
    }
}

