/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.IDatabaseConfig;
import ai.libs.jaicore.basic.sets.Pair;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLAdapter
implements Serializable,
AutoCloseable {
    private transient Logger logger = LoggerFactory.getLogger(SQLAdapter.class);
    private static final String DB_DRIVER = "mysql";
    private static final String KEY_EQUALS_VALUE_TO_BE_SET = " = (?)";
    private final String driver;
    private final String host;
    private final String user;
    private final String password;
    private final String database;
    private final boolean ssl;
    private final Properties connectionProperties;
    private transient Connection connect;
    private long timestampOfLastAction = Long.MIN_VALUE;

    public SQLAdapter(IDatabaseConfig config) {
        this(DB_DRIVER, config.getDBHost(), config.getDBUsername(), config.getDBPassword(), config.getDBDatabaseName(), new Properties(), config.getDBSSL());
    }

    public SQLAdapter(String host, String user, String password, String database, boolean ssl) {
        this(DB_DRIVER, host, user, password, database, new Properties(), ssl);
    }

    public SQLAdapter(String host, String user, String password, String database) {
        this(DB_DRIVER, host, user, password, database, new Properties());
    }

    public SQLAdapter(String driver, String host, String user, String password, String database, Properties connectionProperties) {
        this(driver, host, user, password, database, connectionProperties, true);
    }

    public SQLAdapter(String driver, String host, String user, String password, String database, Properties connectionProperties, boolean ssl) {
        this.ssl = ssl;
        this.driver = driver;
        this.host = host;
        this.user = user;
        this.password = password;
        this.database = database;
        this.connectionProperties = connectionProperties;
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
    }

    private void connect() throws SQLException {
        int tries = 0;
        while (true) {
            try {
                Properties connectionProps = new Properties(this.connectionProperties);
                connectionProps.put("user", this.user);
                connectionProps.put("password", this.password);
                String connectionString = "jdbc:" + this.driver + "://" + this.host + "/" + this.database + (this.ssl ? "?verifyServerCertificate=false&requireSSL=true&useSSL=true" : "");
                this.connect = DriverManager.getConnection(connectionString, connectionProps);
                return;
            }
            catch (SQLException e) {
                block5: {
                    this.logger.error("Connection to server {} failed with JDBC driver {} (attempt {} of 3), waiting 3 seconds before trying again.", new Object[]{this.host, this.driver, ++tries, e});
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        this.logger.error("SQLAdapter got interrupted while trying to establish a connection to the database. NOTE: This will trigger an immediate shutdown as no sql connection could be established. Reason for the interrupt was:", (Throwable)e1);
                        break block5;
                    }
                    if (tries < 3) continue;
                }
                this.logger.error("Quitting execution as no database connection could be established");
                System.exit(1);
                return;
            }
            break;
        }
    }

    public PreparedStatement getPreparedStatement(String query) throws SQLException {
        this.checkConnection();
        return this.connect.prepareStatement(query);
    }

    public synchronized void checkConnection() throws SQLException {
        int renewAfterSeconds = 300;
        if (this.timestampOfLastAction + (long)(renewAfterSeconds * 1000) < System.currentTimeMillis()) {
            this.close();
            this.connect();
        }
        this.timestampOfLastAction = System.currentTimeMillis();
    }

    public ResultSet getRowsOfTable(String table) throws SQLException {
        return this.getRowsOfTable(table, new HashMap<String, String>());
    }

    public ResultSet getRowsOfTable(String table, Map<String, String> conditions) throws SQLException {
        StringBuilder conditionSB = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : conditions.entrySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(" AND ");
            } else {
                conditionSB.append(" WHERE ");
            }
            conditionSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        return this.getResultsOfQuery("SELECT * FROM `" + table + "`" + conditionSB.toString(), values);
    }

    public ResultSet getResultsOfQuery(String query) throws SQLException {
        return this.getResultsOfQuery(query, new ArrayList<String>());
    }

    public ResultSet getResultsOfQuery(String query, String[] values) throws SQLException {
        return this.getResultsOfQuery(query, Arrays.asList(values));
    }

    public ResultSet getResultsOfQuery(String query, List<String> values) throws SQLException {
        this.checkConnection();
        try (PreparedStatement statement = this.connect.prepareStatement(query);){
            for (int i = 1; i <= values.size(); ++i) {
                statement.setString(i, values.get(i - 1));
            }
            ResultSet resultSet = statement.executeQuery();
            return resultSet;
        }
    }

    public int insert(String sql, String[] values) throws SQLException {
        return this.insert(sql, Arrays.asList(values));
    }

    /*
     * Exception decompiling
     */
    public int insert(String sql, List<? extends Object> values) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int insert(String table, Map<String, ? extends Object> map) throws SQLException {
        Pair<String, List<Object>> insertStatement = this.buildInsertStatement(table, map);
        return this.insert(insertStatement.getX(), insertStatement.getY());
    }

    public void insertNoNewValues(String sql, List<? extends Object> values) throws SQLException {
        this.checkConnection();
        try (PreparedStatement stmt = this.connect.prepareStatement(sql, 1);){
            for (int i = 1; i <= values.size(); ++i) {
                this.setValue(stmt, i, values.get(i - 1));
            }
            stmt.executeUpdate();
        }
    }

    private Pair<String, List<Object>> buildInsertStatement(String table, Map<String, ? extends Object> map) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (sb1.length() != 0) {
                sb1.append(", ");
                sb2.append(", ");
            }
            sb1.append(entry.getKey());
            sb2.append("?");
            values.add(entry.getValue());
        }
        String statement = "INSERT INTO " + table + " (" + sb1.toString() + ") VALUES (" + sb2.toString() + ")";
        return new Pair<String, List<Object>>(statement, values);
    }

    public void insertNoNewValues(String table, Map<String, ? extends Object> map) throws SQLException {
        Pair<String, List<Object>> insertStatement = this.buildInsertStatement(table, map);
        this.insertNoNewValues(insertStatement.getX(), insertStatement.getY());
    }

    public void update(String sql) throws SQLException {
        this.update(sql, new ArrayList());
    }

    public void update(String sql, String[] values) throws SQLException {
        this.update(sql, Arrays.asList(values));
    }

    public void update(String sql, List<? extends Object> values) throws SQLException {
        this.checkConnection();
        try (PreparedStatement stmt = this.connect.prepareStatement(sql);){
            for (int i = 1; i <= values.size(); ++i) {
                stmt.setString(i, values.get(i - 1).toString());
            }
            stmt.executeUpdate();
        }
    }

    public void update(String table, Map<String, ? extends Object> updateValues, Map<String, ? extends Object> conditions) throws SQLException {
        this.checkConnection();
        StringBuilder updateSB = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, ? extends Object> entry : updateValues.entrySet()) {
            if (updateSB.length() > 0) {
                updateSB.append(", ");
            }
            updateSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        StringBuilder conditionSB = new StringBuilder();
        for (Map.Entry<String, ? extends Object> entry : conditions.entrySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(" AND ");
            }
            conditionSB.append(entry.getKey() + KEY_EQUALS_VALUE_TO_BE_SET);
            values.add(entry.getValue());
        }
        String string = "UPDATE " + table + " SET " + updateSB.toString() + " WHERE " + conditionSB.toString();
        try (PreparedStatement preparedStatement = this.connect.prepareStatement(string);){
            for (int i = 1; i <= values.size(); ++i) {
                this.setValue(preparedStatement, i, values.get(i - 1));
            }
            preparedStatement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueriesAtomically(List<PreparedStatement> queries) throws SQLException {
        this.checkConnection();
        this.connect.setAutoCommit(false);
        try {
            for (PreparedStatement query : queries) {
                query.execute();
            }
            this.connect.commit();
        }
        catch (SQLException e) {
            this.logger.error("Transaction is being rolled back.", (Throwable)e);
            try {
                this.connect.rollback();
            }
            catch (SQLException e1) {
                this.logger.error("Could not rollback the connection", (Throwable)e1);
            }
        }
        finally {
            for (PreparedStatement query : queries) {
                if (query == null) continue;
                query.close();
            }
            this.connect.setAutoCommit(true);
        }
    }

    private void setValue(PreparedStatement stmt, int index, Object val) throws SQLException {
        if (val instanceof Integer) {
            stmt.setInt(index, (Integer)val);
        } else if (val instanceof Number) {
            stmt.setDouble(index, (Double)val);
        } else if (val instanceof String) {
            stmt.setString(index, (String)val);
        } else {
            stmt.setObject(index, val);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connect != null) {
                this.connect.close();
            }
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while closing the database connection.", (Throwable)e);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    private class ShutdownThread
    extends Thread {
        private SQLAdapter adapter;

        public ShutdownThread(SQLAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void run() {
            this.adapter.close();
        }
    }
}

