/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.ISolutionCandidateIterator;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;

public abstract class ASolutionCandidateIterator<I, O>
extends AAlgorithm<I, O>
implements ISolutionCandidateIterator<I, O> {
    public ASolutionCandidateIterator(I input) {
        super(input);
    }

    protected ASolutionCandidateIterator(IAlgorithmConfig config, I input) {
        super(config, input);
    }

    @Override
    public O nextSolutionCandidate() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        SolutionCandidateFoundEvent<O> event = this.nextSolutionCandidateEvent();
        return event.getSolutionCandidate();
    }

    @Override
    public SolutionCandidateFoundEvent<O> nextSolutionCandidateEvent() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            AlgorithmEvent event = this.nextWithException();
            if (!(event instanceof SolutionCandidateFoundEvent)) continue;
            SolutionCandidateFoundEvent castedEvent = (SolutionCandidateFoundEvent)event;
            return castedEvent;
        }
        throw new NoSuchElementException();
    }

    @Override
    public O call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        O candidate = this.nextSolutionCandidate();
        this.terminate();
        return candidate;
    }

    public List<O> collectAllSolutions() throws InterruptedException, AlgorithmExecutionCanceledException, TimeoutException, AlgorithmException {
        ArrayList<O> solutions = new ArrayList<O>();
        while (this.hasNext()) {
            solutions.add(this.nextSolutionCandidate());
        }
        return solutions;
    }
}

