/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graph;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LabeledGraph<T, L>
extends Graph<T> {
    private final Map<Edge<T>, L> labels = new HashMap<Edge<T>, L>();

    public LabeledGraph() {
    }

    public LabeledGraph(LabeledGraph<T, L> graph) {
        for (Object i : graph.getItems()) {
            this.addItem(i);
        }
        for (Object i : this.getItems()) {
            for (Object i2 : graph.getSuccessors(i)) {
                this.addEdge(i, i2, graph.getEdgeLabel(i, i2));
            }
        }
    }

    @Override
    public void addEdge(T from, T to) {
        this.addEdge(from, to, null);
    }

    public void addEdge(T from, T to, L label) {
        super.addEdge(from, to);
        if (label == null) {
            throw new IllegalArgumentException("No null-labels allowed!");
        }
        this.labels.put(new Edge<T>(from, to), label);
    }

    public final void addGraph(LabeledGraph<T, L> g) {
        for (Object t : SetUtil.difference(g.getItems(), this.getItems())) {
            this.addItem(t);
        }
        for (Object t1 : g.getItems()) {
            for (Object t2 : g.getSuccessors(t1)) {
                this.addEdge(t1, t2, g.getEdgeLabel(t1, t2));
            }
        }
    }

    public L getEdgeLabel(Pair<T, T> edge) {
        return this.getEdgeLabel(edge.getX(), edge.getY());
    }

    public L getEdgeLabel(T from, T to) {
        Edge<T> e = new Edge<T>(from, to);
        if (!this.labels.containsKey(e)) {
            ArrayList<Object> targets = new ArrayList<Object>();
            for (Edge<T> e2 : this.labels.keySet()) {
                if (!((Edge)e2).from.equals(from)) continue;
                targets.add(((Edge)e2).to);
                if (!((Edge)e2).to.equals(to)) continue;
                if (!this.labels.containsKey(e2)) {
                    throw new IllegalStateException("The edge " + e2 + " with hashCode " + e2.hashCode() + " is contained in the labeling but cannot be accessed anymore using new edge object with hash value " + e.hashCode() + "!");
                }
                assert (false) : "This line should never be reached!";
            }
            throw new IllegalArgumentException("No label for the edge from " + from + " (" + from.hashCode() + ") to " + to + " (" + to.hashCode() + ") is available! List of targets of " + from + ": " + targets);
        }
        return this.labels.get(e);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.labels.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabeledGraph other = (LabeledGraph)obj;
        return this.labels.equals(other.labels);
    }

    private static class Edge<T> {
        private T from;
        private T to;

        public Edge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }

        public String toString() {
            return "Edge [from=" + this.from + ", to=" + this.to + "]";
        }
    }
}

