/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;

public class StringUtil {
    private StringUtil() {
    }

    public static char[] getCommonChars(boolean includeDigits) {
        int i;
        LinkedList<Character> chars = new LinkedList<Character>();
        for (i = 65; i <= 90; ++i) {
            chars.add(Character.valueOf((char)i));
        }
        for (i = 97; i <= 122; ++i) {
            chars.add(Character.valueOf((char)i));
        }
        if (includeDigits) {
            for (i = 48; i <= 57; ++i) {
                chars.add(Character.valueOf((char)i));
            }
        }
        char[] charsAsArray = new char[chars.size()];
        for (int i2 = 0; i2 < charsAsArray.length; ++i2) {
            charsAsArray[i2] = ((Character)chars.get(i2)).charValue();
        }
        return charsAsArray;
    }

    public static String getRandomString(int length, char[] chars, long seed) {
        StringBuilder s = new StringBuilder();
        Random rand = new Random(seed);
        for (int i = 0; i < length; ++i) {
            s.append(chars[rand.nextInt(chars.length)]);
        }
        return s.toString();
    }

    public static String implode(Object[] array) {
        return StringUtil.implode(array, ", ");
    }

    public static String implode(Set<Object> set) {
        return StringUtil.implode(set, ", ");
    }

    public static String implode(Collection<?> set, String delimiter) {
        if (set.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (Object elem : set) {
            s.append(delimiter + elem.toString());
        }
        String result = s.toString();
        return result.substring(delimiter.length(), result.length());
    }

    public static String implode(Collection<Object> collection) {
        Object[] array = new Object[collection.size()];
        collection.toArray(array);
        return StringUtil.implode(array);
    }

    public static String implode(Object[] array, String delimiter) {
        StringBuilder s = new StringBuilder();
        if (array == null || array.length == 0) {
            return s.toString();
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] == null) {
                s.append("NULL" + delimiter);
                continue;
            }
            s.append(array[i].toString() + delimiter);
        }
        if (array[array.length - 1] == null) {
            s.append("NULL");
        } else {
            s.append(array[array.length - 1].toString());
        }
        return s.toString();
    }

    public static String[] explode(String string, String delimiter) {
        return string.split(delimiter);
    }

    public static String[] merge(String[] array1, String[] array2) {
        String[] output = new String[array1.length + array2.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = i < array1.length ? array1[i] : array2[i - array1.length];
        }
        return output;
    }

    public static String[] getArrayWithValues(int size, String value) {
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = value.replace("%", "" + (i + 1)).replace("$", String.valueOf((char)(i + 97)));
        }
        return array;
    }

    public static String stripChar(String str, char c) {
        int length = str.length();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == c) continue;
            s.append(str.charAt(i));
        }
        return s.toString();
    }

    public static String[] shiftFirst(String[] input) {
        String[] output = new String[input.length - 1];
        for (int i = 1; i < input.length; ++i) {
            output[i - 1] = input[i];
        }
        return output;
    }

    public static String fromBinary(String binarySequence) {
        StringBuilder sb = new StringBuilder();
        binarySequence = binarySequence.replace(" ", "");
        Arrays.stream(binarySequence.split("(?<=\\G.{8})")).forEach(s -> sb.append((char)Integer.parseInt(s, 2)));
        return sb.toString();
    }

    public static String toStringLimited(Object o, int limit) {
        String str = o.toString();
        if (str.length() <= limit) {
            return str;
        }
        return str.substring(0, limit - 4) + " ...";
    }

    public static String firstElementWithPrefix(Collection<String> collection, String prefix) {
        Optional<String> resultOpt = collection.stream().filter(x -> x.startsWith(prefix)).findFirst();
        if (resultOpt.isPresent()) {
            return resultOpt.get();
        }
        throw new NoSuchElementException("Could not find an element with prefix " + prefix + " in the given collection.");
    }
}

