/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm.reduction;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.ASolutionCandidateIterator;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithm;
import ai.libs.jaicore.basic.algorithm.IAlgorithmFactory;
import ai.libs.jaicore.basic.algorithm.ISolutionCandidateIterator;
import ai.libs.jaicore.basic.algorithm.events.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AReducingSolutionIterator<I1, O1, I2, O2>
extends ASolutionCandidateIterator<I1, O1> {
    private Logger logger = LoggerFactory.getLogger(AReducingSolutionIterator.class);
    private String loggerName;
    private final AlgorithmicProblemReduction<I1, O1, I2, O2> problemTransformer;
    private final ISolutionCandidateIterator<I2, O2> baseAlgorithm;

    public AReducingSolutionIterator(I1 problem, AlgorithmicProblemReduction<I1, O1, I2, O2> problemTransformer, IAlgorithmFactory<I2, O2> baseFactory) {
        super(problem);
        this.problemTransformer = problemTransformer;
        this.baseAlgorithm = (ISolutionCandidateIterator)baseFactory.getAlgorithm(problemTransformer.encodeProblem(problem));
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.baseAlgorithm.cancel();
    }

    public void runPreCreationHook() {
    }

    protected SolutionCandidateFoundEvent<O1> getSolutionEvent(O1 solution) {
        return new ASolutionCandidateFoundEvent<O1>(this.getId(), solution);
    }

    @Override
    public final AlgorithmEvent nextWithException() throws AlgorithmExecutionCanceledException, InterruptedException, AlgorithmTimeoutedException, AlgorithmException {
        if (this.isCanceled()) {
            throw new IllegalStateException("The algorithm has already been canceled. Cannot conduct fut\u00c5\u2022ther steps.");
        }
        switch (this.getState()) {
            case CREATED: {
                this.runPreCreationHook();
                TimeOut to = this.getTimeout();
                this.logger.debug("Setting timeout of search to {}", (Object)to);
                this.baseAlgorithm.setTimeout(to);
                return this.activate();
            }
            case ACTIVE: {
                this.logger.info("Starting/continuing search for next plan.");
                try {
                    O2 solution = this.baseAlgorithm.nextSolutionCandidate();
                    if (solution == null) {
                        this.logger.info("No more solutions will be found. Terminating algorithm.");
                        return this.terminate();
                    }
                    this.logger.info("Next solution found.");
                    O1 solutionToOriginalProlem = this.problemTransformer.decodeSolution(solution);
                    SolutionCandidateFoundEvent<O1> event = this.getSolutionEvent(solutionToOriginalProlem);
                    this.post(event);
                    return event;
                }
                catch (NoSuchElementException e) {
                    return this.terminate();
                }
            }
        }
        throw new IllegalStateException("Don't know what to do in state " + (Object)((Object)this.getState()));
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.problemTransformer instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of problem transformer to {}.problemtransformer", (Object)name);
            ((ILoggingCustomizable)((Object)this.problemTransformer)).setLoggerName(name + ".problemtransformer");
        }
        if (this.baseAlgorithm instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of search to {}.base", (Object)name);
            ((ILoggingCustomizable)((Object)this.baseAlgorithm)).setLoggerName(name + ".base");
        }
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public AlgorithmicProblemReduction<I1, O1, I2, O2> getProblemTransformer() {
        return this.problemTransformer;
    }

    public IAlgorithm<I2, O2> getBaseAlgorithm() {
        return this.baseAlgorithm;
    }
}

