/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.concurrent;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTimer
extends Timer {
    private static final Logger logger = LoggerFactory.getLogger(GlobalTimer.class);
    private static final GlobalTimer instance = new GlobalTimer();
    private final TimerTask refresher = new TimerTask(){

        @Override
        public void run() {
            Thread timerThread = Thread.currentThread();
            logger.info("Changing global timer thread {} priority from {} to {}", new Object[]{timerThread, timerThread.getPriority(), 10});
            timerThread.setPriority(10);
            logger.info("Priority of global timer thread {} is now {}", (Object)timerThread, (Object)timerThread.getPriority());
        }
    };

    private GlobalTimer() {
        super("Global TimeoutTimer", true);
        this.schedule(this.refresher, 0L);
    }

    public static GlobalTimer getInstance() {
        return instance;
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException("The TimeoutTimer must not be canceled manually!");
    }

    public boolean isTaskScheduled(TimerTask task) {
        return this.getActiveTasks().contains(task);
    }

    public List<TimerTask> getActiveTasks() {
        try {
            Field outerQueueField = Timer.class.getDeclaredField("queue");
            outerQueueField.setAccessible(true);
            Object outerQueueObject = outerQueueField.get(this);
            Field innerQueueField = outerQueueObject.getClass().getDeclaredField("queue");
            Field innerScheduledField = TimerTask.class.getDeclaredField("nextExecutionTime");
            Field innerStateField = TimerTask.class.getDeclaredField("state");
            innerQueueField.setAccessible(true);
            innerScheduledField.setAccessible(true);
            innerStateField.setAccessible(true);
            TimerTask[] tasksAsArray = (TimerTask[])innerQueueField.get(outerQueueObject);
            ArrayList<TimerTask> tasks = new ArrayList<TimerTask>();
            for (TimerTask task : tasksAsArray) {
                if (task == null || task == this.refresher || innerScheduledField.getLong(task) < 0L || innerStateField.getInt(task) != 1) continue;
                tasks.add(task);
            }
            return tasks;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error("Could not get active tasks due to {}. Message: {}. Stack trace: {}", new Object[]{e.getClass().getName(), e.getMessage(), Arrays.asList(e.getStackTrace()).stream().map(s -> "\n\t" + s.toString()).collect(Collectors.joining())});
            return new ArrayList<TimerTask>();
        }
    }

    public int getNumberOfActiveTasks() {
        return this.getActiveTasks().size();
    }
}

