/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db.sql;

import ai.libs.jaicore.db.sql.ResultSetSerializerException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;

public class ResultSetToJsonSerializer
extends JsonSerializer<ResultSet> {
    public Class<ResultSet> handledType() {
        return ResultSet.class;
    }

    public void serialize(ResultSet values, JsonGenerator gen, SerializerProvider serializer) throws IOException {
        try {
            ResultSetMetaData rsmd = values.getMetaData();
            int numColumns = rsmd.getColumnCount();
            String[] columnNames = new String[numColumns];
            int[] columnTypes = new int[numColumns];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = rsmd.getColumnLabel(i + 1);
                columnTypes[i] = rsmd.getColumnType(i + 1);
            }
            gen.writeStartArray();
            while (values.next()) {
                gen.writeStartObject();
                block22: for (int i = 0; i < columnNames.length; ++i) {
                    gen.writeFieldName(columnNames[i]);
                    switch (columnTypes[i]) {
                        case 4: {
                            long l = values.getInt(i + 1);
                            if (values.wasNull()) {
                                gen.writeNull();
                                continue block22;
                            }
                            gen.writeNumber(l);
                            continue block22;
                        }
                        case -5: {
                            long l = values.getLong(i + 1);
                            if (values.wasNull()) {
                                gen.writeNull();
                                continue block22;
                            }
                            gen.writeNumber(l);
                            continue block22;
                        }
                        case 2: 
                        case 3: {
                            gen.writeNumber(values.getBigDecimal(i + 1));
                            continue block22;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            double d = values.getDouble(i + 1);
                            if (values.wasNull()) {
                                gen.writeNull();
                                continue block22;
                            }
                            gen.writeNumber(d);
                            continue block22;
                        }
                        case -16: 
                        case -9: 
                        case -1: 
                        case 12: {
                            gen.writeString(values.getString(i + 1));
                            continue block22;
                        }
                        case -7: 
                        case 16: {
                            boolean b = values.getBoolean(i + 1);
                            if (values.wasNull()) {
                                gen.writeNull();
                                continue block22;
                            }
                            gen.writeBoolean(b);
                            continue block22;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            gen.writeBinary(values.getBytes(i + 1));
                            continue block22;
                        }
                        case -6: 
                        case 5: {
                            long l = values.getShort(i + 1);
                            if (values.wasNull()) {
                                gen.writeNull();
                                continue block22;
                            }
                            gen.writeNumber(l);
                            continue block22;
                        }
                        case 91: {
                            serializer.defaultSerializeDateValue((Date)values.getDate(i + 1), gen);
                            continue block22;
                        }
                        case 93: {
                            serializer.defaultSerializeDateValue((Date)values.getTime(i + 1), gen);
                            continue block22;
                        }
                        case 2004: {
                            Blob blob = values.getBlob(i);
                            serializer.defaultSerializeValue((Object)blob.getBinaryStream(), gen);
                            blob.free();
                            continue block22;
                        }
                        case 2005: {
                            Clob clob = values.getClob(i);
                            serializer.defaultSerializeValue((Object)clob.getCharacterStream(), gen);
                            clob.free();
                            continue block22;
                        }
                        case 2003: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type ARRAY");
                        }
                        case 2002: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type STRUCT");
                        }
                        case 2001: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type DISTINCT");
                        }
                        case 2006: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type REF");
                        }
                        default: {
                            serializer.defaultSerializeValue(values.getObject(i + 1), gen);
                        }
                    }
                }
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        catch (SQLException e) {
            throw new ResultSetSerializerException(e);
        }
    }
}

