/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.db.sql;

import ai.libs.jaicore.basic.kvstore.IKVStore;
import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.db.sql.ResultSetSerializerException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ResultSetToKVStoreSerializer {
    public List<IKVStore> serialize(ResultSet values) throws IOException {
        try {
            ResultSetMetaData rsmd = values.getMetaData();
            int numColumns = rsmd.getColumnCount();
            String[] columnNames = new String[numColumns];
            int[] columnTypes = new int[numColumns];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = rsmd.getColumnLabel(i + 1);
                columnTypes[i] = rsmd.getColumnType(i + 1);
            }
            KVStoreCollection collection = new KVStoreCollection();
            while (values.next()) {
                KVStore store = new KVStore();
                for (int i = 0; i < columnNames.length; ++i) {
                    String fieldName = columnNames[i];
                    switch (columnTypes[i]) {
                        case 4: {
                            store.put(fieldName, values.getInt(i + 1));
                            break;
                        }
                        case -5: {
                            store.put(fieldName, values.getLong(i + 1));
                            break;
                        }
                        case 2: 
                        case 3: {
                            store.put(fieldName, values.getBigDecimal(i + 1));
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            store.put(fieldName, values.getDouble(i + 1));
                            break;
                        }
                        case -16: 
                        case -9: 
                        case -1: 
                        case 12: {
                            store.put(fieldName, values.getString(i + 1));
                            break;
                        }
                        case -7: 
                        case 16: {
                            store.put(fieldName, values.getBoolean(i + 1));
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            store.put(fieldName, values.getByte(i + 1));
                            break;
                        }
                        case -6: 
                        case 5: {
                            store.put(fieldName, values.getShort(i + 1));
                            break;
                        }
                        case 91: {
                            store.put(fieldName, values.getDate(i + 1));
                            break;
                        }
                        case 93: {
                            store.put(fieldName, values.getTime(i + 1));
                            break;
                        }
                        case 2004: {
                            store.put(fieldName, values.getBlob(i));
                            break;
                        }
                        case 2005: {
                            store.put(fieldName, values.getClob(i));
                            break;
                        }
                        case 2003: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type ARRAY");
                        }
                        case 2002: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type STRUCT");
                        }
                        case 2001: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type DISTINCT");
                        }
                        case 2006: {
                            throw new ResultSetSerializerException("ResultSetSerializer not yet implemented for SQL type REF");
                        }
                        default: {
                            store.put(fieldName, values.getObject(i + 1));
                        }
                    }
                    if (!values.wasNull()) continue;
                    store.put(fieldName, null);
                }
                collection.add(store);
            }
            return collection;
        }
        catch (SQLException e) {
            throw new ResultSetSerializerException(e);
        }
    }
}

