/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.graph;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public class Graph<T>
implements Serializable {
    private static final long serialVersionUID = 3912962578399588845L;
    private final Map<T, Node> nodes = new HashMap<T, Node>();
    private final Set<Pair<T, T>> edges = new HashSet<Pair<T, T>>();

    public Graph() {
    }

    public Graph(T node) {
        this();
        this.addItem(node);
    }

    public Graph(Collection<T> nodes) {
        this();
        for (T node : nodes) {
            this.addItem(node);
        }
    }

    public Graph(Graph<T> toClone) {
        this();
        for (T i : toClone.nodes.keySet()) {
            this.addItem(i);
        }
        for (T i : this.nodes.keySet()) {
            for (T i2 : toClone.getSuccessors(i)) {
                this.addEdge(i, i2);
            }
        }
    }

    public void addItem(T item) {
        Node n = new Node();
        n.t = item;
        this.nodes.put(item, n);
        if (!this.hasItem(n.t)) {
            throw new IllegalStateException("Just added node " + item + " does not respond positively on a call to hasItem");
        }
    }

    public Set<T> getItems() {
        return this.nodes.keySet();
    }

    public boolean hasItem(T item) {
        return this.nodes.containsKey(item);
    }

    public void removeItem(T item) {
        for (T successor : this.getSuccessors(item)) {
            this.removeEdge(item, successor);
        }
        for (T predecessor : this.getPredecessors(item)) {
            this.removeEdge(predecessor, item);
        }
        this.nodes.remove(item);
    }

    public void addEdge(T from, T to) {
        this.checkNodeExistence(from);
        this.checkNodeExistence(to);
        Node nodeFrom = this.nodes.get(from);
        Node nodeTo = this.nodes.get(to);
        nodeFrom.successors.add(nodeTo);
        nodeTo.predecessors.add(nodeFrom);
        this.edges.add(new Pair<T, T>(from, to));
    }

    public void removeEdge(T from, T to) {
        this.checkNodeExistence(from);
        this.checkNodeExistence(to);
        Node nodeFrom = this.nodes.get(from);
        Node nodeTo = this.nodes.get(to);
        nodeFrom.successors.remove(nodeTo);
        nodeTo.predecessors.remove(nodeFrom);
        this.edges.remove(new Pair<T, T>(from, to));
    }

    public Set<T> getSuccessors(T item) {
        this.checkNodeExistence(item);
        HashSet<Object> successors = new HashSet<Object>();
        for (Node n : this.nodes.get(item).successors) {
            successors.add(n.t);
        }
        return successors;
    }

    public Set<T> getPredecessors(T item) {
        this.checkNodeExistence(item);
        HashSet<Object> predecessors = new HashSet<Object>();
        for (Node n : this.nodes.get(item).predecessors) {
            predecessors.add(n.t);
        }
        return predecessors;
    }

    private void checkNodeExistence(T item) {
        if (!this.nodes.keySet().contains(item)) {
            throw new IllegalArgumentException("Cannot perform operation on node " + item + ", which does not exist!");
        }
    }

    public final Collection<T> getSources() {
        return this.nodes.keySet().stream().filter(n -> this.nodes.get(n).predecessors.isEmpty()).collect(Collectors.toList());
    }

    public final T getRoot() {
        Collection<T> sources = this.getSources();
        if (sources.isEmpty()) {
            throw new NoSuchElementException("The graph is empty, so it has no root");
        }
        if (sources.size() > 1) {
            throw new NoSuchElementException("The graph has several sources, so no unique root can be returned");
        }
        return sources.iterator().next();
    }

    public final Collection<T> getSinks() {
        return this.nodes.keySet().stream().filter(n -> this.nodes.get(n).successors.isEmpty()).collect(Collectors.toList());
    }

    public final void addGraph(Graph<T> g) {
        for (Object t : SetUtil.difference(g.getItems(), this.getItems())) {
            this.addItem(t);
        }
        for (Object t1 : g.getItems()) {
            for (Object t2 : g.getSuccessors(t1)) {
                this.addEdge(t1, t2);
            }
        }
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Set<Pair<T, T>> getEdges() {
        return this.edges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodes.keySet() == null ? 0 : this.nodes.keySet().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Graph other = (Graph)obj;
        for (T t : this.nodes.keySet()) {
            Set<T> successorsOther;
            Set<T> predecessorsOther;
            if (!other.nodes.containsKey(t)) {
                return false;
            }
            Set<T> predecessors = this.getPredecessors(t);
            if (!predecessors.equals(predecessorsOther = other.getPredecessors(t))) {
                return false;
            }
            Set<T> successors = this.getSuccessors(t);
            if (successors.equals(successorsOther = other.getSuccessors(t))) continue;
            return false;
        }
        return true;
    }

    public String getLineBasedStringRepresentation() {
        return this.getLineBasedStringRepresentation(1);
    }

    public String getLineBasedStringRepresentation(int offset) {
        StringBuilder sb = new StringBuilder();
        for (T root : this.getSources()) {
            sb.append(this.getLineBasedStringRepresentation(root, offset, new ArrayList<Boolean>()));
        }
        return sb.toString();
    }

    private String getLineBasedStringRepresentation(T node, int outerOffset, List<Boolean> childrenOffset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < outerOffset; ++i) {
            sb.append("\t");
        }
        for (boolean lastChild : childrenOffset) {
            sb.append(lastChild ? " " : "|");
            sb.append("      ");
        }
        if (!childrenOffset.isEmpty()) {
            sb.append("+----- ");
        }
        sb.append(node.toString());
        Set<T> successors = this.getSuccessors(node);
        int n = successors.size();
        int i = 1;
        for (Object successor : successors) {
            sb.append("\n");
            ArrayList<Boolean> childrenOffsetCopy = new ArrayList<Boolean>(childrenOffset);
            childrenOffsetCopy.add(i++ == n);
            sb.append(this.getLineBasedStringRepresentation(successor, outerOffset, childrenOffsetCopy));
        }
        return sb.toString();
    }

    public boolean isGraphSane() {
        boolean allNodesContained = this.nodes.keySet().stream().allMatch(this::hasItem);
        if (!allNodesContained) {
            assert (allNodesContained) : "Not every node n in the node map have positive responses for a call of hasItem(n)";
            return false;
        }
        boolean allSuccessorsContained = this.nodes.keySet().stream().allMatch(n -> this.getSuccessors(n).stream().allMatch(this::hasItem));
        if (!allSuccessorsContained) {
            assert (allSuccessorsContained) : "There is a node in the graph such that not every successor n of it has a positive response for a call of hasItem(n)";
            return false;
        }
        return true;
    }

    private class Node
    implements Serializable {
        private static final long serialVersionUID = 1083239915581499630L;
        private T t = null;
        private Set<Node> successors = new HashSet<Node>();
        private Set<Node> predecessors = new HashSet<Node>();

        private Node() {
        }
    }
}

