/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.FileIsDirectoryException;
import ai.libs.jaicore.basic.ResourceFile;
import ai.libs.jaicore.basic.ResourceUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static List<String> readFileAsList(File file) throws IOException {
        if (file instanceof ResourceFile) {
            return ResourceUtil.readResourceFileToStringList((ResourceFile)file);
        }
        return FileUtil.readFileAsList(file.getAbsolutePath());
    }

    public static List<String> readFileAsList(String filename) throws IOException {
        try (BufferedReader r = Files.newBufferedReader(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);){
            String line;
            LinkedList<String> lines = new LinkedList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
    }

    public static String readFileAsString(File file) throws IOException {
        return FileUtil.readFileAsString(file.getAbsolutePath());
    }

    public static String readFileAsString(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader r = Files.newBufferedReader(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = r.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static List<List<String>> readFileAsMatrix(String filename, String separation) throws IOException {
        List<String> content = FileUtil.readFileAsList(filename);
        ArrayList<List<String>> matrix = new ArrayList<List<String>>(content.size());
        for (String line : content) {
            String[] lineAsArray = line.split(separation);
            ArrayList<String> lineAsList = new ArrayList<String>(lineAsArray.length);
            for (String field : lineAsArray) {
                lineAsList.add(field.trim());
            }
            matrix.add(lineAsList);
        }
        return matrix;
    }

    public static Properties readPropertiesFile(File propertiesFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propertiesFile));
        return props;
    }

    public static void zipFiles(Collection<String> files, String archive) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(archive);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            int total = files.size();
            int i = 0;
            for (String fileName : files) {
                File file = new File(fileName);
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    zos.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zos.write(bytes, 0, length);
                    }
                    zos.closeEntry();
                }
                logger.debug("{} / {} ready.", (Object)(++i), (Object)total);
            }
        }
    }

    public static synchronized void serializeObject(Object object, String pathname) throws IOException {
        File file = new File(pathname);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (ObjectOutputStream os2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath())));){
            os2.writeObject(object);
        }
        catch (NotSerializableException e) {
            Files.delete(file.toPath());
            throw e;
        }
    }

    public static Object unserializeObject(String pathname) throws IOException, ClassNotFoundException {
        try (ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(pathname)));){
            Object object = is.readObject();
            return object;
        }
    }

    public static void touch(String filename) {
        try (FileWriter fw = new FileWriter(filename);){
            fw.write("");
        }
        catch (IOException e) {
            logger.error("Could not create file {}.", (Object)filename, (Object)e);
        }
    }

    public static boolean move(File from, File to) {
        return from.renameTo(to);
    }

    public static boolean move(String from, String to) {
        return FileUtil.move(new File(from), new File(to));
    }

    public static List<File> getFilesOfFolder(File folder) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) continue;
            files.add(file);
        }
        return files;
    }

    public static void requireFileExists(File file) throws FileIsDirectoryException, FileNotFoundException {
        Objects.requireNonNull(file);
        if (file instanceof ResourceFile) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isFile()) {
            throw new FileIsDirectoryException("The file " + file.getAbsolutePath() + " is not a file but a directory.");
        }
    }

    public static File getExistingFileWithHighestPriority(String resourcePath, String ... fileSystemPaths) {
        if (fileSystemPaths.length > 0) {
            for (String fileSystemConfig : fileSystemPaths) {
                File configFile = new File(fileSystemConfig);
                if (!configFile.exists()) continue;
                return configFile;
            }
        }
        return ResourceUtil.getResourceAsFile(resourcePath);
    }

    public static void deleteFolderRecursively(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.deleteFolderRecursively(new File(dir, children[i]));
            }
        }
        Files.delete(dir.toPath());
    }

    public static void writeFileAsList(List<String> lines, String filename) throws IOException {
        try (FileWriter writer = new FileWriter(filename);){
            for (String line : lines) {
                writer.write(line + System.lineSeparator());
            }
        }
    }
}

