/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.PropertiesLoadFailedException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Mutable;
import org.api4.java.common.control.IConfig;

public interface IOwnerBasedConfig
extends Mutable,
Accessible,
IConfig {
    default public IOwnerBasedConfig loadPropertiesFromFile(File file) {
        return this.loadPropertiesFromFileArray(file);
    }

    default public IOwnerBasedConfig loadPropertiesFromFileArray(File ... files) {
        try {
            ArrayList<String> configLines = new ArrayList<String>();
            for (File f : files) {
                configLines.addAll(FileUtil.readFileAsList(f));
            }
            return this.loadPropertiesFromList(configLines);
        }
        catch (IOException e) {
            throw new PropertiesLoadFailedException("Could not load properties from the given file.", e);
        }
    }

    default public IOwnerBasedConfig loadPropertiesFromResource(String resourcePath) throws IOException {
        ClassLoader classLoader = FileUtil.class.getClassLoader();
        String content = null;
        try (InputStream inputStream = classLoader.getResourceAsStream(resourcePath);){
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            content = result.toString(StandardCharsets.UTF_8.name());
        }
        if (content != null) {
            return this.loadPropertiesFromList((List)Arrays.asList(content.split("\n")));
        }
        return this;
    }

    default public IOwnerBasedConfig loadPropertiesFromList(List<String> propertiesList) {
        for (String line : propertiesList) {
            if (!(line = line.trim()).contains("=") || line.startsWith("#")) continue;
            String[] split = line.split("=");
            if (split.length > 2) {
                throw new IllegalArgumentException("Property line " + line + " contains more than one \"=\" symbol and cannot be parsed.");
            }
            this.setProperty(split[0].trim(), split.length > 1 ? split[1].trim() : null);
        }
        return this;
    }

    default public <T extends IOwnerBasedAlgorithmConfig> T copy(Class<T> configInterface) {
        if (!configInterface.isInstance(this)) {
            throw new IllegalArgumentException("The config " + this + " does not implement the interface " + configInterface.getClass().getName());
        }
        IOwnerBasedAlgorithmConfig clone = (IOwnerBasedAlgorithmConfig)ConfigFactory.create(configInterface, (Map[])new Map[0]);
        for (String property : this.propertyNames()) {
            clone.setProperty(property, this.getProperty(property));
        }
        return (T)clone;
    }
}

