/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.LoadResourceAsFileFailedException;
import ai.libs.jaicore.basic.ResourceFile;
import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static String readResourceFileToString(String path) throws IOException {
        return SetUtil.implode(ResourceUtil.readResourceFileToStringList(path), "\n");
    }

    public static List<String> readResourceFileToStringList(String path) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        InputStream resourceStream = ResourceUtil.class.getClassLoader().getResourceAsStream(path);
        if (resourceStream == null) {
            throw new FileNotFoundException("Could not find resource file '" + path + "'");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ResourceUtil.class.getClassLoader().getResourceAsStream(path)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    public static List<String> readResourceFileToStringList(ResourceFile resourceFile) throws IOException {
        return ResourceUtil.readResourceFileToStringList(resourceFile.getPathName());
    }

    public static ResourceFile getResourceAsFile(String path) {
        return new ResourceFile(path);
    }

    public static URL getResourceAsURL(String path) {
        return ResourceUtil.class.getClassLoader().getResource(path);
    }

    public static String getResourceAsTempFile(String resourcePath) {
        try {
            File tempFile = File.createTempFile("ai.libs-", ".res");
            tempFile.deleteOnExit();
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));){
                bw.write(ResourceUtil.readResourceFileToString(resourcePath));
            }
            return tempFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new LoadResourceAsFileFailedException("Could not load resource as a temporary file", e);
        }
    }
}

