/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import ai.libs.jaicore.basic.FileUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileHandler
implements Closeable {
    private static final String ERR_MSG_CANNOT_CLOSE_READER = "Cannot close reader";
    private Logger logger = LoggerFactory.getLogger(TempFileHandler.class);
    private File tempFileDirectory;
    private Map<String, File> tempFiles;
    private Map<String, BufferedReader> tempFileReaders;
    private Map<String, FileWriter> tempFileWriters;

    public TempFileHandler(File tempFileDirectory) {
        this.tempFileDirectory = tempFileDirectory;
        this.tempFiles = new HashMap<String, File>();
        this.tempFileReaders = new HashMap<String, BufferedReader>();
        this.tempFileWriters = new HashMap<String, FileWriter>();
        if (!tempFileDirectory.exists()) {
            tempFileDirectory.mkdirs();
        }
    }

    public TempFileHandler() {
        this(new File(System.getProperty("user.home") + "/.ailibs"));
    }

    public String createTempFile() {
        String uuid = UUID.randomUUID().toString();
        String path = this.tempFileDirectory.getAbsolutePath() + File.separator + uuid;
        FileUtil.touch(path);
        File file = new File(path);
        file.deleteOnExit();
        this.tempFiles.put(uuid, file);
        return uuid;
    }

    public File getTempFile(String uuid) {
        return this.tempFiles.get(uuid);
    }

    public BufferedReader getFileReaderForTempFile(String uuid) {
        if (this.tempFileReaders.containsKey(uuid)) {
            try {
                this.tempFileReaders.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileReaders.remove(uuid);
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.tempFiles.get(uuid)));
            this.tempFileReaders.put(uuid, reader);
            return reader;
        }
        catch (FileNotFoundException e) {
            this.logger.error(String.format("File for UUID %s does not exist!", uuid), (Throwable)e);
            return null;
        }
    }

    public FileWriter getFileWriterForTempFile(String uuid) {
        if (this.tempFileWriters.containsKey(uuid)) {
            return this.tempFileWriters.get(uuid);
        }
        try {
            FileWriter writer = new FileWriter(this.tempFiles.get(uuid));
            this.tempFileWriters.put(uuid, writer);
            return writer;
        }
        catch (IOException e) {
            this.logger.error(String.format("Cannot create FileWriter for file with UUID %s", uuid), (Throwable)e);
            return null;
        }
    }

    public void deleteTempFile(String uuid) {
        if (this.tempFileReaders.containsKey(uuid)) {
            try {
                this.tempFileReaders.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileReaders.remove(uuid);
        }
        if (this.tempFileWriters.containsKey(uuid)) {
            try {
                this.tempFileWriters.get(uuid).close();
            }
            catch (IOException e) {
                this.logger.error(ERR_MSG_CANNOT_CLOSE_READER, (Throwable)e);
            }
            this.tempFileWriters.remove(uuid);
        }
        if (this.tempFiles.containsKey(uuid)) {
            try {
                Files.delete(this.tempFiles.get(uuid).toPath());
            }
            catch (IOException e) {
                this.logger.error(String.format("Cannot delete file for UUID %s", uuid), (Throwable)e);
            }
            this.tempFiles.remove(uuid);
        }
    }

    public void cleanUp() {
        HashSet<String> uuids = new HashSet<String>(this.tempFiles.keySet());
        for (String uuid : uuids) {
            this.deleteTempFile(uuid);
        }
    }

    @Override
    public void close() throws IOException {
        this.cleanUp();
    }

    public String getTempFileDirPath() {
        return this.tempFileDirectory.getAbsolutePath();
    }
}

