/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.ASolutionCandidateIterator;
import java.util.NoSuchElementException;
import org.api4.java.algorithm.IOptimizationAlgorithm;
import org.api4.java.algorithm.events.IAlgorithmEvent;
import org.api4.java.algorithm.events.result.ISolutionCandidateFoundEvent;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.algorithm.exceptions.AlgorithmTimeoutedException;
import org.api4.java.common.attributedobjects.ScoredItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AOptimizer<I, O extends ScoredItem<V>, V extends Comparable<V>>
extends ASolutionCandidateIterator<I, O>
implements IOptimizationAlgorithm<I, O, V> {
    private Logger logger = LoggerFactory.getLogger(AOptimizer.class);
    private String loggerName;
    private O bestSeenSolution;

    public AOptimizer(I input) {
        super(input);
    }

    protected AOptimizer(IOwnerBasedAlgorithmConfig config, I input) {
        super(config, input);
    }

    protected boolean updateBestSeenSolution(O candidate) {
        assert (candidate != null) : "Cannot update best solution with null.";
        if (this.bestSeenSolution == null || candidate.getScore() != null && candidate.getScore().compareTo(this.bestSeenSolution.getScore()) < 0) {
            this.bestSeenSolution = candidate;
            return true;
        }
        return false;
    }

    protected boolean setBestSeenSolution(O candidate) {
        boolean isBetterThanCurrent = this.bestSeenSolution == null || candidate.getScore() != null && candidate.getScore().compareTo(this.bestSeenSolution.getScore()) < 0;
        this.bestSeenSolution = candidate;
        return isBetterThanCurrent;
    }

    @Override
    public O nextSolutionCandidate() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        ScoredItem candidate = (ScoredItem)super.nextSolutionCandidate();
        this.updateBestSeenSolution(candidate);
        return (O)candidate;
    }

    @Override
    public ISolutionCandidateFoundEvent<O> nextSolutionCandidateEvent() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            IAlgorithmEvent event = this.nextWithException();
            if (!(event instanceof ISolutionCandidateFoundEvent)) continue;
            ISolutionCandidateFoundEvent castedEvent = (ISolutionCandidateFoundEvent)event;
            return castedEvent;
        }
        throw new NoSuchElementException();
    }

    public O getBestSeenSolution() {
        return this.bestSeenSolution;
    }

    @Override
    public O call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.bestSeenSolution;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._algorithm");
    }
}

