/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.api4.java.datastructure.kvstore.IKVStore;

public class KVStoreCollectionOneLayerPartition
implements Iterable<Map.Entry<String, KVStoreCollection>> {
    private final String partitionKey;
    private Map<String, KVStoreCollection> data;

    public KVStoreCollectionOneLayerPartition(String partitionKey, KVStoreCollection collection) {
        this(partitionKey);
        this.addAll(collection);
    }

    public KVStoreCollectionOneLayerPartition(String firstLevelKey) {
        this.partitionKey = firstLevelKey;
        this.data = new HashMap<String, KVStoreCollection>();
    }

    public Map<String, KVStoreCollection> getData() {
        return this.data;
    }

    public void add(IKVStore store) {
        String keyForPartition = store.getAsString(this.partitionKey);
        if (!this.data.containsKey(keyForPartition)) {
            this.data.put(keyForPartition, new KVStoreCollection());
        }
        this.data.get(keyForPartition).add(store);
    }

    public void addAll(KVStoreCollection collection) {
        collection.forEach(this::add);
    }

    public Set<Map.Entry<String, KVStoreCollection>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Iterator<Map.Entry<String, KVStoreCollection>> iterator() {
        return this.data.entrySet().iterator();
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("partitionKey", this.partitionKey);
        fields.put("data", this.data);
        return ToJSONStringUtil.toJSONString(fields);
    }
}

