/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import java.util.Comparator;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStoreSequentialComparator
implements Comparator<IKVStore> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KVStoreSequentialComparator.class);
    private final String[] sortKeys;

    public KVStoreSequentialComparator(String ... sortKeys) {
        this.sortKeys = sortKeys;
    }

    @Override
    public int compare(IKVStore arg0, IKVStore arg1) {
        for (String sortKey : this.sortKeys) {
            Integer compare = null;
            try {
                compare = arg0.getAsInt(sortKey).compareTo(arg1.getAsInt(sortKey));
            }
            catch (Exception e) {
                try {
                    compare = arg0.getAsLong(sortKey).compareTo(arg1.getAsLong(sortKey));
                }
                catch (Exception e1) {
                    try {
                        compare = arg0.getAsString(sortKey).compareTo(arg1.getAsString(sortKey));
                    }
                    catch (Exception e2) {
                        LOGGER.warn("The values of the key {} are neither int nor long nor string. This type of value is thus not supported for sorting and the key is skipped.", (Object)sortKey);
                    }
                }
            }
            if (compare == null || compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

