/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.kvstore.KVStoreCollection;
import ai.libs.jaicore.basic.kvstore.Table;
import ai.libs.jaicore.db.sql.SQLAdapter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.api4.java.datastructure.kvstore.IKVStore;

public class KVStoreUtil {
    private KVStoreUtil() {
    }

    public static String kvStoreCollectionToLaTeXTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting) {
        return KVStoreUtil.kvStoreCollectionToLaTeXTable(kvStoreCollection, rowIndex, columnIndex, cellFormatting, "");
    }

    public static String kvStoreCollectionToLaTeXTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String missingEntry) {
        StringBuilder sb = new StringBuilder();
        Table<String> table = new Table<String>();
        for (IKVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey((Object)cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        sb.append(table.toLaTeX(missingEntry));
        return sb.toString();
    }

    public static String kvStoreCollectionToCSVTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String standardValue) {
        return KVStoreUtil.kvStoreCollectionToTable(kvStoreCollection, rowIndex, columnIndex, cellFormatting, standardValue).toCSV(standardValue);
    }

    public static Table<String> kvStoreCollectionToTable(KVStoreCollection kvStoreCollection, String rowIndex, String columnIndex, String cellFormatting, String standardValue) {
        Table<String> table = new Table<String>();
        for (IKVStore store : kvStoreCollection) {
            String[] cellFormattingSplit = store.getAsString(cellFormatting).split("#");
            List cleanedCellFormatting = Arrays.stream(cellFormattingSplit).filter(x -> !x.equals("")).collect(Collectors.toList());
            String rowValue = store.getAsString(rowIndex).replaceAll("\\_", "\\\\_");
            String columnValue = store.getAsString(columnIndex).replaceAll("\\_", "\\\\_");
            StringBuilder tableEntryBuilder = new StringBuilder();
            for (String cellKey : cleanedCellFormatting) {
                if (!store.containsKey((Object)cellKey)) {
                    tableEntryBuilder.append(cellKey);
                    continue;
                }
                tableEntryBuilder.append(store.getAsString(cellKey));
            }
            table.add(columnValue, rowValue, tableEntryBuilder.toString());
        }
        return table;
    }

    public static KVStoreCollection readFromCSVWithHeader(File csvFile, Map<String, String> commonFields) throws IOException {
        return KVStoreUtil.readFromCSVWithHeader(csvFile, commonFields, ";");
    }

    public static KVStoreCollection readFromCSVWithHeader(File csvFile, Map<String, String> commonFields, String separator) throws IOException {
        return KVStoreUtil.readFromCSVDataWithHeader(FileUtil.readFileAsList(csvFile), commonFields, separator);
    }

    public static KVStoreCollection readFromCSV(String[] columns, File csvFile, Map<String, String> commonFields) throws IOException {
        return KVStoreUtil.readFromCSV(columns, csvFile, commonFields, ";");
    }

    public static KVStoreCollection readFromCSV(String[] columns, File csvFile, Map<String, String> commonFields, String separator) throws IOException {
        return KVStoreUtil.readFromCSVData(FileUtil.readFileAsList(csvFile), columns, commonFields, separator);
    }

    public static KVStoreCollection readFromCSVDataWithHeader(List<String> data, Map<String, String> commonFields, String separator) {
        return KVStoreUtil.readFromCSVData(data, data.remove(0).split(separator), commonFields, separator);
    }

    public static KVStoreCollection readFromCSVData(List<String> data, String[] columns, Map<String, String> commonFields, String separator) {
        KVStoreCollection kvStoreCollection = new KVStoreCollection();
        for (String line : data) {
            if (KVStoreUtil.skipLine(line)) continue;
            KVStore t = KVStoreUtil.readLine(columns, line, separator);
            for (Map.Entry<String, String> commonEntry : commonFields.entrySet()) {
                t.put(commonEntry.getKey(), commonEntry.getValue());
            }
            t.setCollection(kvStoreCollection);
            kvStoreCollection.add(t);
        }
        return kvStoreCollection;
    }

    private static KVStore readLine(String[] columns, String line, String separator) {
        String[] lineSplit = line.split(separator);
        if (lineSplit.length != columns.length) {
            throw new IllegalArgumentException("Malformed line in csv file: Number of column heads " + columns.length + " Number of columns in line: " + lineSplit.length + " " + line);
        }
        KVStore t = new KVStore();
        for (int i = 0; i < columns.length; ++i) {
            t.put(columns[i], lineSplit[i]);
        }
        return t;
    }

    private static boolean skipLine(String line) {
        return line.trim().equals("") || line.trim().startsWith("#");
    }

    public static KVStoreCollection readFromMySQLResultSet(ResultSet rs, Map<String, String> commonFields) throws SQLException {
        KVStoreCollection kvStoreCollection = new KVStoreCollection();
        int n = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            KVStore t = new KVStore();
            t.setCollection(kvStoreCollection);
            for (int i = 1; i <= n; ++i) {
                t.put(rs.getMetaData().getColumnLabel(i), rs.getString(i));
                for (Map.Entry<String, String> commonEntry : commonFields.entrySet()) {
                    t.put(commonEntry.getKey(), commonEntry.getValue());
                }
            }
            kvStoreCollection.add(t);
        }
        return kvStoreCollection;
    }

    public static KVStoreCollection readFromMySQLQuery(SQLAdapter adapter, String query, Map<String, String> commonFields) throws SQLException {
        return KVStoreUtil.addCommonFields(new KVStoreCollection(adapter.getResultsOfQuery(query)), commonFields);
    }

    public static KVStoreCollection readFromMySQLTable(SQLAdapter adapter, String table, Map<String, String> commonFields) throws SQLException {
        return KVStoreUtil.addCommonFields(new KVStoreCollection(adapter.getRowsOfTable(table)), commonFields);
    }

    private static KVStoreCollection addCommonFields(KVStoreCollection collection, Map<String, String> commonFields) {
        collection.stream().forEach(x -> x.putAll(commonFields));
        return collection;
    }

    public static KVStoreCollection readFromJson(JsonNode res) {
        if (res instanceof ArrayNode) {
            return KVStoreUtil.readFromJsonArray((ArrayNode)res);
        }
        return KVStoreUtil.readFromJsonArray((ArrayNode)res.get(0));
    }

    public static KVStoreCollection readFromJsonArray(ArrayNode list) {
        KVStoreCollection col = new KVStoreCollection();
        for (JsonNode node : list) {
            col.add(KVStoreUtil.readObjectNodeToKVStore((ObjectNode)node));
        }
        return col;
    }

    private static IKVStore readObjectNodeToKVStore(ObjectNode node) {
        Iterator fieldNameIt = node.fieldNames();
        KVStore store = new KVStore();
        block7: while (fieldNameIt.hasNext()) {
            String fieldName = (String)fieldNameIt.next();
            JsonNode value = node.get(fieldName);
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    store.put(fieldName, value.asBoolean());
                    continue block7;
                }
                case MISSING: {
                    store.put(fieldName, null);
                    continue block7;
                }
                case NULL: {
                    store.put(fieldName, null);
                    continue block7;
                }
                case NUMBER: {
                    store.put(fieldName, value.asText());
                    continue block7;
                }
                case STRING: {
                    store.put(fieldName, value.asText());
                    continue block7;
                }
            }
            store.put(fieldName, value.asText());
        }
        return store;
    }
}

