/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import ai.libs.jaicore.basic.metric.AWeightedTrigometricDistance;
import ai.libs.jaicore.basic.transform.vector.derivate.ADerivateFilter;
import ai.libs.jaicore.basic.transform.vector.derivate.BackwardDifferenceDerivate;
import org.api4.java.common.metric.IDistanceMetric;

public class DerivateDistance
extends AWeightedTrigometricDistance {
    private ADerivateFilter derivate;
    private IDistanceMetric timeSeriesDistance;
    private IDistanceMetric baseDerivateDistance;

    public DerivateDistance(double alpha, ADerivateFilter derivate, IDistanceMetric timeSeriesDistance, IDistanceMetric derivateDistance) {
        super(alpha);
        if (derivate == null) {
            throw new IllegalArgumentException("Parameter derivate must not be null.");
        }
        if (timeSeriesDistance == null) {
            throw new IllegalArgumentException("Parameter timeSeriesDistance must not be null.");
        }
        if (derivateDistance == null) {
            throw new IllegalArgumentException("Parameter derivateDistance must not be null.");
        }
        this.derivate = derivate;
        this.timeSeriesDistance = timeSeriesDistance;
        this.baseDerivateDistance = derivateDistance;
    }

    public DerivateDistance(double alpha, IDistanceMetric timeSeriesDistance, IDistanceMetric derivateDistance) {
        this(alpha, new BackwardDifferenceDerivate(), timeSeriesDistance, derivateDistance);
    }

    public DerivateDistance(double alpha, ADerivateFilter derivate, IDistanceMetric distance) {
        this(alpha, derivate, distance, distance);
    }

    public DerivateDistance(double alpha, IDistanceMetric distance) {
        this(alpha, new BackwardDifferenceDerivate(), distance, distance);
    }

    @Override
    public double distance(double[] a, double[] b) {
        double[] derivateA = this.derivate.transform(a);
        double[] derivateB = this.derivate.transform(b);
        return this.getA() * this.timeSeriesDistance.distance(a, b) + this.getB() * this.baseDerivateDistance.distance(derivateA, derivateB);
    }
}

