/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.metric;

import ai.libs.jaicore.basic.transform.vector.CosineTransform;
import ai.libs.jaicore.basic.transform.vector.IVectorTransform;
import ai.libs.jaicore.basic.transform.vector.derivate.ADerivateFilter;
import ai.libs.jaicore.basic.transform.vector.derivate.BackwardDifferenceDerivate;
import org.api4.java.common.metric.IDistanceMetric;

public class DerivateTransformDistance
implements IDistanceMetric {
    private double a;
    private double b;
    private double c;
    private ADerivateFilter derivate;
    private IVectorTransform transform;
    private IDistanceMetric timeSeriesDistance;
    private IDistanceMetric derivateDistance;
    private IDistanceMetric transformDistance;

    public DerivateTransformDistance(double a, double b, double c, ADerivateFilter derivate, IVectorTransform transform, IDistanceMetric timeSeriesDistance, IDistanceMetric derivateDistance, IDistanceMetric transformDistance) {
        if (derivate == null) {
            throw new IllegalArgumentException("Parameter derivate must not be null.");
        }
        if (transform == null) {
            throw new IllegalArgumentException("Parameter transform must not be null.");
        }
        if (timeSeriesDistance == null) {
            throw new IllegalArgumentException("Parameter timeSeriesDistance must not be null.");
        }
        if (derivateDistance == null) {
            throw new IllegalArgumentException("Parameter derivateDistance must not be null.");
        }
        if (transformDistance == null) {
            throw new IllegalArgumentException("Parameter transformDistance must not be null.");
        }
        this.setA(a);
        this.setB(b);
        this.setC(c);
        this.derivate = derivate;
        this.transform = transform;
        this.timeSeriesDistance = timeSeriesDistance;
        this.derivateDistance = derivateDistance;
        this.transformDistance = transformDistance;
    }

    public DerivateTransformDistance(double a, double b, double c, IDistanceMetric timeSeriesDistance, IDistanceMetric derivateDistance, IDistanceMetric transformDistance) {
        this(a, b, c, new BackwardDifferenceDerivate(), new CosineTransform(), timeSeriesDistance, derivateDistance, transformDistance);
    }

    public DerivateTransformDistance(double a, double b, double c, ADerivateFilter derivate, IVectorTransform transform, IDistanceMetric distance) {
        this(a, b, c, derivate, transform, distance, distance, distance);
    }

    public DerivateTransformDistance(double a, double b, double c, IDistanceMetric distance) {
        this(a, b, c, new BackwardDifferenceDerivate(), new CosineTransform(), distance, distance, distance);
    }

    @Override
    public double distance(double[] a, double[] b) {
        double[] derivateA = this.derivate.transform(a);
        double[] derivateB = this.derivate.transform(b);
        double[] transformA = this.transform.transform(a);
        double[] transformB = this.transform.transform(b);
        return this.a * this.timeSeriesDistance.distance(a, b) + this.b * this.derivateDistance.distance(derivateA, derivateB) + this.c * this.transformDistance.distance(transformA, transformB);
    }

    public void setA(double a) {
        if (a < 0.0 || a > 1.0) {
            throw new IllegalArgumentException("Parameter a must be in interval [0,1].");
        }
        this.a = a;
    }

    public void setB(double b) {
        if (b < 0.0 || b > 1.0) {
            throw new IllegalArgumentException("Parameter b must be in interval [0,1].");
        }
        this.b = b;
    }

    public void setC(double c) {
        if (c < 0.0 || c > 1.0) {
            throw new IllegalArgumentException("Parameter c must be in interval [0,1].");
        }
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }
}

